/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.leptonica.android;

import com.googlecode.leptonica.android.Pix;

public class Skew {
    public static final float SWEEP_RANGE = 30.0f;
    public static final float SWEEP_DELTA = 5.0f;
    public static final int SWEEP_REDUCTION = 8;
    public static final int SEARCH_REDUCTION = 4;
    public static final float SEARCH_MIN_DELTA = 0.01f;

    public static float findSkew(Pix pixs) {
        return Skew.findSkew(pixs, 30.0f, 5.0f, 8, 4, 0.01f);
    }

    public static float findSkew(Pix pixs, float sweepRange, float sweepDelta, int sweepReduction, int searchReduction, float searchMinDelta) {
        if (pixs == null) {
            throw new IllegalArgumentException("Source pix must be non-null");
        }
        return Skew.nativeFindSkew(pixs.getNativePix(), sweepRange, sweepDelta, sweepReduction, searchReduction, searchMinDelta);
    }

    private static native float nativeFindSkew(long var0, float var2, float var3, int var4, int var5, float var6);

    static {
        System.loadLibrary("lept");
        System.loadLibrary("jpgt");
    }
}

