/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.mrzscanner.model;

import android.os.Parcel;
import android.os.Parcelable;
import io.scanbot.mrzscanner.model.MRZCheckDigit;
import io.scanbot.mrzscanner.model.MRZDocumentType;
import io.scanbot.mrzscanner.model.MRZField;
import io.scanbot.mrzscanner.model.MRZFieldName;
import io.scanbot.mrzscanner.model.MRZTextRecognitionResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;

public class MRZRecognitionResult
implements Parcelable {
    public static final int NO_ERROR = -1;
    public static final int ERROR_LICENSE_INVALID = 1;
    public final boolean recognitionSuccessful;
    public final List<MRZField> fields;
    @Deprecated
    public final String documentCode;
    @Deprecated
    public final String firstName;
    @Deprecated
    public final String lastName;
    @Deprecated
    public final String issuingStateOrOrganization;
    @Deprecated
    public final String departmentOfIssuance;
    @Deprecated
    public final String nationality;
    @Deprecated
    public final String dateOfBirth;
    @Deprecated
    public final String gender;
    @Deprecated
    public final String dateOfExpiry;
    @Deprecated
    public final String personalNumber;
    @Deprecated
    public final String optional1;
    @Deprecated
    public final String optional2;
    @Deprecated
    public final String discreetIssuingStateOrOrganization;
    public final int validCheckDigitsCount;
    public final int checkDigitsCount;
    public final MRZDocumentType travelDocType;
    public final List<MRZTextRecognitionResult> recognizedMRZLines;
    public final int errorCode;
    public final List<MRZCheckDigit> checkDigits;
    public static final Parcelable.Creator<MRZRecognitionResult> CREATOR = new Parcelable.Creator<MRZRecognitionResult>(){

        public MRZRecognitionResult createFromParcel(Parcel in) {
            return new MRZRecognitionResult(in);
        }

        public MRZRecognitionResult[] newArray(int size) {
            return new MRZRecognitionResult[size];
        }
    };

    public MRZRecognitionResult(List<MRZField> fields, int validCheckDigitsCount, int checkDigitsCount, int travelDocTypeValue, boolean recognitionSuccessful, List<MRZTextRecognitionResult> recognizedMRZLines, List<MRZCheckDigit> checkDigits) {
        this.fields = fields;
        this.documentCode = this.documentCodeField().value;
        this.firstName = this.firstNameField().value;
        this.lastName = this.lastNameField().value;
        this.issuingStateOrOrganization = this.issuingStateOrOrganizationField().value;
        this.departmentOfIssuance = this.departmentOfIssuanceField().value;
        this.nationality = this.nationalityField().value;
        this.dateOfBirth = this.dateOfBirthField().value;
        this.gender = this.genderField().value;
        this.dateOfExpiry = this.dateOfExpiryField().value;
        this.personalNumber = this.personalNumberField().value;
        this.optional1 = this.optional1Field().value;
        this.optional2 = this.optional2Field().value;
        this.discreetIssuingStateOrOrganization = this.discreetIssuingStateOrOrganizationField().value;
        this.validCheckDigitsCount = validCheckDigitsCount;
        this.checkDigitsCount = checkDigitsCount;
        this.travelDocType = this.docTypeFromInt(travelDocTypeValue);
        this.recognitionSuccessful = recognitionSuccessful;
        this.recognizedMRZLines = recognizedMRZLines;
        this.checkDigits = checkDigits;
        this.errorCode = -1;
    }

    @Deprecated
    public MRZRecognitionResult(String documentCode, String firstName, String lastName, String issuingStateOrOrganization, String departmentOfIssuance, String nationality, String dateOfBirth, String gender, String dateOfExpiry, String personalNumber, String optional1, String optional2, String discreetIssuingStateOrOrganization, int validCheckDigitsCount, int checkDigitsCount, int travelDocTypeValue, boolean recognitionSuccessful, List<MRZTextRecognitionResult> recognizedMRZLines, List<MRZCheckDigit> checkDigits) {
        this.fields = new ArrayList<MRZField>();
        this.documentCode = documentCode;
        this.firstName = firstName;
        this.lastName = lastName;
        this.issuingStateOrOrganization = issuingStateOrOrganization;
        this.departmentOfIssuance = departmentOfIssuance;
        this.nationality = nationality;
        this.dateOfBirth = dateOfBirth;
        this.gender = gender;
        this.dateOfExpiry = dateOfExpiry;
        this.personalNumber = personalNumber;
        this.optional1 = optional1;
        this.optional2 = optional2;
        this.discreetIssuingStateOrOrganization = discreetIssuingStateOrOrganization;
        this.validCheckDigitsCount = validCheckDigitsCount;
        this.checkDigitsCount = checkDigitsCount;
        this.travelDocType = this.docTypeFromInt(travelDocTypeValue);
        this.recognitionSuccessful = recognitionSuccessful;
        this.recognizedMRZLines = recognizedMRZLines;
        this.checkDigits = checkDigits;
        this.errorCode = -1;
    }

    protected MRZRecognitionResult(Parcel in) {
        this.recognitionSuccessful = in.readByte() != 0;
        this.fields = in.createTypedArrayList(MRZField.CREATOR);
        this.documentCode = in.readString();
        this.firstName = in.readString();
        this.lastName = in.readString();
        this.issuingStateOrOrganization = in.readString();
        this.departmentOfIssuance = in.readString();
        this.nationality = in.readString();
        this.dateOfBirth = in.readString();
        this.gender = in.readString();
        this.dateOfExpiry = in.readString();
        this.personalNumber = in.readString();
        this.optional1 = in.readString();
        this.optional2 = in.readString();
        this.discreetIssuingStateOrOrganization = in.readString();
        this.validCheckDigitsCount = in.readInt();
        this.checkDigitsCount = in.readInt();
        this.recognizedMRZLines = in.createTypedArrayList(MRZTextRecognitionResult.CREATOR);
        this.travelDocType = MRZDocumentType.valueOf(in.readString());
        this.checkDigits = in.createTypedArrayList(MRZCheckDigit.CREATOR);
        this.errorCode = -1;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeByte((byte)(this.recognitionSuccessful ? 1 : 0));
        dest.writeTypedList(this.fields);
        dest.writeString(this.documentCode);
        dest.writeString(this.firstName);
        dest.writeString(this.lastName);
        dest.writeString(this.issuingStateOrOrganization);
        dest.writeString(this.departmentOfIssuance);
        dest.writeString(this.nationality);
        dest.writeString(this.dateOfBirth);
        dest.writeString(this.gender);
        dest.writeString(this.dateOfExpiry);
        dest.writeString(this.personalNumber);
        dest.writeString(this.optional1);
        dest.writeString(this.optional2);
        dest.writeString(this.discreetIssuingStateOrOrganization);
        dest.writeInt(this.validCheckDigitsCount);
        dest.writeInt(this.checkDigitsCount);
        dest.writeTypedList(this.recognizedMRZLines);
        dest.writeString(this.travelDocType.name());
        dest.writeTypedList(this.checkDigits);
    }

    public MRZRecognitionResult(int errorCode) {
        this.fields = Collections.emptyList();
        this.documentCode = null;
        this.firstName = null;
        this.lastName = null;
        this.issuingStateOrOrganization = null;
        this.departmentOfIssuance = null;
        this.nationality = null;
        this.dateOfBirth = null;
        this.gender = null;
        this.dateOfExpiry = null;
        this.personalNumber = null;
        this.optional1 = null;
        this.optional2 = null;
        this.discreetIssuingStateOrOrganization = null;
        this.validCheckDigitsCount = 0;
        this.checkDigitsCount = 0;
        this.travelDocType = null;
        this.recognitionSuccessful = false;
        this.recognizedMRZLines = Collections.emptyList();
        this.checkDigits = Collections.emptyList();
        this.errorCode = errorCode;
    }

    public int describeContents() {
        return 0;
    }

    protected MRZDocumentType docTypeFromInt(int value) {
        switch (value) {
            case 0: {
                return MRZDocumentType.Passport;
            }
            case 1: {
                return MRZDocumentType.TravelDocument;
            }
            case 2: {
                return MRZDocumentType.Visa;
            }
            case 3: {
                return MRZDocumentType.IDCard;
            }
        }
        return MRZDocumentType.Undefined;
    }

    public MRZField fieldByName(MRZFieldName name) {
        ListIterator<MRZField> it = this.fields.listIterator();
        while (it.hasNext()) {
            MRZField field = it.next();
            if (field.name != name) continue;
            return field;
        }
        return new MRZField(name);
    }

    public MRZField documentCodeField() {
        return this.fieldByName(MRZFieldName.DocumentCode);
    }

    public MRZField issuingStateOrOrganizationField() {
        return this.fieldByName(MRZFieldName.IssuingStateOrOrganization);
    }

    public MRZField departmentOfIssuanceField() {
        return this.fieldByName(MRZFieldName.DepartmentOfIssuance);
    }

    public MRZField firstNameField() {
        return this.fieldByName(MRZFieldName.FirstName);
    }

    public MRZField lastNameField() {
        return this.fieldByName(MRZFieldName.LastName);
    }

    public MRZField nationalityField() {
        return this.fieldByName(MRZFieldName.Nationality);
    }

    public MRZField dateOfBirthField() {
        return this.fieldByName(MRZFieldName.DateOfBirth);
    }

    public MRZField genderField() {
        return this.fieldByName(MRZFieldName.Gender);
    }

    public MRZField dateOfExpiryField() {
        return this.fieldByName(MRZFieldName.DateOfExpiry);
    }

    public MRZField personalNumberField() {
        return this.fieldByName(MRZFieldName.PersonalNumber);
    }

    public MRZField travelDocTypeField() {
        return this.fieldByName(MRZFieldName.TravelDocType);
    }

    public MRZField optional1Field() {
        return this.fieldByName(MRZFieldName.Optional1);
    }

    public MRZField optional2Field() {
        return this.fieldByName(MRZFieldName.Optional2);
    }

    public MRZField discreetIssuingStateOrOrganizationField() {
        return this.fieldByName(MRZFieldName.DiscreetIssuingStateOrOrganization);
    }
}

