/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.dcscanner.model;

import android.graphics.Bitmap;
import android.os.Parcel;
import android.os.Parcelable;
import io.scanbot.dcscanner.model.DateRecord;
import io.scanbot.dcscanner.model.DisabilityCertificateInfoBox;
import io.scanbot.dcscanner.model.DisabilityCertificateInsuredPersonType;
import io.scanbot.dcscanner.model.DisabilityCertificateIntention;
import java.util.List;

public class DisabilityCertificateRecognizerResultInfo
implements Parcelable {
    public final boolean recognitionSuccessful;
    public final DisabilityCertificateInfoBox patientInfoBox;
    public final List<DisabilityCertificateInfoBox> checkboxes;
    public final List<DateRecord> dates;
    public final Bitmap debugImage;
    public final DisabilityCertificateIntention intention;
    public final DisabilityCertificateInsuredPersonType insuredPersonType;
    public static final Parcelable.Creator<DisabilityCertificateRecognizerResultInfo> CREATOR = new Parcelable.Creator<DisabilityCertificateRecognizerResultInfo>(){

        public DisabilityCertificateRecognizerResultInfo createFromParcel(Parcel in) {
            return new DisabilityCertificateRecognizerResultInfo(in);
        }

        public DisabilityCertificateRecognizerResultInfo[] newArray(int size) {
            return new DisabilityCertificateRecognizerResultInfo[size];
        }
    };

    public DisabilityCertificateRecognizerResultInfo(boolean recognitionSuccessful, DisabilityCertificateInfoBox patientInfoBox, List<DisabilityCertificateInfoBox> checkboxes, List<DateRecord> dates, int intention, int insuredPersonType, Bitmap debugImage) {
        this.patientInfoBox = patientInfoBox;
        this.checkboxes = checkboxes;
        this.dates = dates;
        this.intention = this.intentionFromInt(intention);
        this.insuredPersonType = this.insuredPersonTypeFromInt(insuredPersonType);
        this.recognitionSuccessful = recognitionSuccessful;
        this.debugImage = debugImage;
    }

    private DisabilityCertificateIntention intentionFromInt(int value) {
        switch (value) {
            case 0: {
                return DisabilityCertificateIntention.CertificateIntentionEmployer;
            }
            case 1: {
                return DisabilityCertificateIntention.CertificateIntentionInsuranceCompany;
            }
            case 2: {
                return DisabilityCertificateIntention.CertificateIntentionInsuredPerson;
            }
        }
        return DisabilityCertificateIntention.CertificateIntentionUnknown;
    }

    private int intentionToInt() {
        switch (this.intention) {
            case CertificateIntentionEmployer: {
                return 0;
            }
            case CertificateIntentionInsuranceCompany: {
                return 1;
            }
            case CertificateIntentionInsuredPerson: {
                return 2;
            }
        }
        return -1;
    }

    private int insuredPersonTypeToInt() {
        switch (this.insuredPersonType) {
            case CertificateInsuredPersonTypeAdult: {
                return 0;
            }
            case CertificateInsuredPersonTypeChild: {
                return 1;
            }
        }
        return -1;
    }

    private DisabilityCertificateInsuredPersonType insuredPersonTypeFromInt(int value) {
        switch (value) {
            case 0: {
                return DisabilityCertificateInsuredPersonType.CertificateInsuredPersonTypeAdult;
            }
            case 1: {
                return DisabilityCertificateInsuredPersonType.CertificateInsuredPersonTypeChild;
            }
        }
        return DisabilityCertificateInsuredPersonType.CertificateInsuredPersonTypeUnknown;
    }

    protected DisabilityCertificateRecognizerResultInfo(Parcel in) {
        this.recognitionSuccessful = in.readByte() != 0;
        this.patientInfoBox = (DisabilityCertificateInfoBox)in.readParcelable(DisabilityCertificateInfoBox.class.getClassLoader());
        this.checkboxes = in.createTypedArrayList(DisabilityCertificateInfoBox.CREATOR);
        this.dates = in.createTypedArrayList(DateRecord.CREATOR);
        this.intention = this.intentionFromInt(in.readInt());
        this.insuredPersonType = this.insuredPersonTypeFromInt(in.readInt());
        this.debugImage = (Bitmap)in.readParcelable(Bitmap.class.getClassLoader());
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeByte((byte)(this.recognitionSuccessful ? 1 : 0));
        dest.writeParcelable((Parcelable)this.patientInfoBox, flags);
        dest.writeTypedList(this.checkboxes);
        dest.writeTypedList(this.dates);
        dest.writeInt(this.intentionToInt());
        dest.writeInt(this.insuredPersonTypeToInt());
        dest.writeParcelable((Parcelable)this.debugImage, flags);
    }

    public int describeContents() {
        return 0;
    }
}

