/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.textorientation.model;

import android.util.SparseArray;

public enum TextOrientation {
    TEXT_ORIENTATION_NOTRECOGNIZED(-2),
    TEXT_ORIENTATION_LOWCONFIDENCE(-1),
    TEXT_ORIENTATION_NORMAL(0),
    TEXT_ORIENTATION_ROTATED90(90),
    TEXT_ORIENTATION_ROTATED180(180),
    TEXT_ORIENTATION_ROTATED270(270);

    private static final SparseArray<TextOrientation> code2Type;
    private final int code;

    private TextOrientation(int code) {
        this.code = code;
    }

    public int getCode() {
        return this.code;
    }

    public static TextOrientation getByCode(int code) {
        TextOrientation type = (TextOrientation)((Object)code2Type.get(code));
        if (type == null) {
            throw new IllegalStateException("No TextOrientation type for code: " + code);
        }
        return type;
    }

    static {
        code2Type = new SparseArray();
        for (TextOrientation type : TextOrientation.values()) {
            code2Type.put(type.getCode(), (Object)type);
        }
    }
}

