/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.hicscanner.model;

import android.graphics.Bitmap;
import android.os.Parcel;
import android.os.Parcelable;
import io.scanbot.hicscanner.model.HealthInsuranceCardDetectionStatus;
import io.scanbot.hicscanner.model.HealthInsuranceCardField;
import java.util.Collections;
import java.util.List;

public class HealthInsuranceCardRecognitionResult
implements Parcelable {
    public static final int NO_ERROR = -1;
    public static final int ERROR_LICENSE_INVALID = 1;
    public final List<HealthInsuranceCardField> fields;
    public final HealthInsuranceCardDetectionStatus status;
    public int errorCode = -1;
    public Bitmap debugImage;
    public static final Parcelable.Creator<HealthInsuranceCardRecognitionResult> CREATOR = new Parcelable.Creator<HealthInsuranceCardRecognitionResult>(){

        public HealthInsuranceCardRecognitionResult createFromParcel(Parcel in) {
            return new HealthInsuranceCardRecognitionResult(in);
        }

        public HealthInsuranceCardRecognitionResult[] newArray(int size) {
            return new HealthInsuranceCardRecognitionResult[size];
        }
    };

    public HealthInsuranceCardRecognitionResult(List<HealthInsuranceCardField> fields, int status, Bitmap debugImage) {
        this.fields = fields;
        this.status = this.healthInsuranceCardDetectionStatusFromInt(status);
        this.debugImage = debugImage;
    }

    public HealthInsuranceCardRecognitionResult(int errorCode) {
        this.errorCode = errorCode;
        this.fields = Collections.emptyList();
        this.status = HealthInsuranceCardDetectionStatus.FAILED_DETECTION;
    }

    protected HealthInsuranceCardRecognitionResult(Parcel in) {
        this.fields = in.createTypedArrayList(HealthInsuranceCardField.CREATOR);
        this.status = HealthInsuranceCardDetectionStatus.valueOf(in.readString());
        this.errorCode = in.readInt();
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeTypedList(this.fields);
        dest.writeString(this.status.name());
        dest.writeInt(this.errorCode);
    }

    public int describeContents() {
        return 0;
    }

    private HealthInsuranceCardDetectionStatus healthInsuranceCardDetectionStatusFromInt(int value) {
        switch (value) {
            case 0: {
                return HealthInsuranceCardDetectionStatus.SUCCESS;
            }
            case 1: {
                return HealthInsuranceCardDetectionStatus.FAILED_DETECTION;
            }
            case 2: {
                return HealthInsuranceCardDetectionStatus.FAILED_VALIDATION;
            }
        }
        return HealthInsuranceCardDetectionStatus.FAILED_DETECTION;
    }
}

