/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.barcodescanner;

import android.graphics.Bitmap;
import android.graphics.Rect;
import android.util.Log;
import io.scanbot.barcodescanner.model.BarCodeScannerResult;
import io.scanbot.barcodescanner.model.BarCodeType;
import java.util.List;

public class BarCodeScanner {
    public BarCodeScanner() {
        BarCodeScanner.ctor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BarCodeScannerResult detectAndDecode(byte[] nv21, List<BarCodeType> barcodeTypes, int width, int height, int orientation) {
        long a = System.currentTimeMillis();
        try {
            BarCodeScannerResult barCodeScannerResult = BarCodeScanner.recognize(nv21, this.barcodesListToIntegerArray(barcodeTypes), width, height, orientation);
            return barCodeScannerResult;
        }
        finally {
            long b = System.currentTimeMillis();
            Log.d((String)"BarCodeScanner", (String)("Total time (sec): " + (float)(b - a) / 1000.0f));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BarCodeScannerResult detectAndDecodeInArea(byte[] nv21, List<BarCodeType> barcodeTypes, Rect areaRect, int width, int height, int orientation) {
        long a = System.currentTimeMillis();
        try {
            BarCodeScannerResult barCodeScannerResult = BarCodeScanner.recognizeInArea(nv21, this.barcodesListToIntegerArray(barcodeTypes), width, height, areaRect.left, areaRect.top, areaRect.width(), areaRect.height(), orientation);
            return barCodeScannerResult;
        }
        finally {
            long b = System.currentTimeMillis();
            Log.d((String)"BarCodeScanner", (String)("Total time (sec): " + (float)(b - a) / 1000.0f));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BarCodeScannerResult detectAndDecodeBGR(byte[] bgr, List<BarCodeType> barcodeTypes, int width, int height, int orientation) {
        long a = System.currentTimeMillis();
        try {
            BarCodeScannerResult barCodeScannerResult = BarCodeScanner.recognizeBGR(bgr, this.barcodesListToIntegerArray(barcodeTypes), width, height, orientation);
            return barCodeScannerResult;
        }
        finally {
            long b = System.currentTimeMillis();
            Log.d((String)"BarCodeScanner", (String)("Total time (sec): " + (float)(b - a) / 1000.0f));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BarCodeScannerResult detectAndDecodeJPEG(byte[] jpeg, List<BarCodeType> barcodeTypes, int width, int height, int orientation) {
        long a = System.currentTimeMillis();
        try {
            BarCodeScannerResult barCodeScannerResult = BarCodeScanner.recognizeJPEG(jpeg, this.barcodesListToIntegerArray(barcodeTypes), width, height, orientation);
            return barCodeScannerResult;
        }
        finally {
            long b = System.currentTimeMillis();
            Log.d((String)"BarCodeScanner", (String)("Total time (sec): " + (float)(b - a) / 1000.0f));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BarCodeScannerResult detectAndDecodeBitmap(Bitmap bitmap, List<BarCodeType> barcodeTypes, int orientation) {
        long a = System.currentTimeMillis();
        try {
            BarCodeScannerResult barCodeScannerResult = BarCodeScanner.recognizeBitmap(bitmap, this.barcodesListToIntegerArray(barcodeTypes), orientation);
            return barCodeScannerResult;
        }
        finally {
            long b = System.currentTimeMillis();
            Log.d((String)"BarCodeScanner", (String)("Total time (sec): " + (float)(b - a) / 1000.0f));
        }
    }

    private int barCodeTypeToInt(BarCodeType type) {
        switch (type) {
            case AZTEC: {
                return 0;
            }
            case CODABAR: {
                return 1;
            }
            case CODE_39: {
                return 2;
            }
            case CODE_93: {
                return 3;
            }
            case CODE_128: {
                return 4;
            }
            case DATA_MATRIX: {
                return 5;
            }
            case EAN_8: {
                return 6;
            }
            case EAN_13: {
                return 7;
            }
            case ITF: {
                return 8;
            }
            case MAXICODE: {
                return 9;
            }
            case PDF_417: {
                return 10;
            }
            case QR_CODE: {
                return 11;
            }
            case RSS_14: {
                return 12;
            }
            case RSS_EXPANDED: {
                return 13;
            }
            case UPC_A: {
                return 14;
            }
            case UPC_E: {
                return 15;
            }
            case UPC_EAN_EXTENSION: {
                return 16;
            }
        }
        return 17;
    }

    private int[] barcodesListToIntegerArray(List<BarCodeType> barcodeTypes) {
        int[] result = new int[barcodeTypes.size()];
        for (int index = 0; index < barcodeTypes.size(); ++index) {
            result[index] = this.barCodeTypeToInt(barcodeTypes.get(index));
        }
        return result;
    }

    private static native void ctor();

    private static native BarCodeScannerResult recognize(byte[] var0, int[] var1, int var2, int var3, int var4);

    private static native BarCodeScannerResult recognizeInArea(byte[] var0, int[] var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8);

    private static native BarCodeScannerResult recognizeBGR(byte[] var0, int[] var1, int var2, int var3, int var4);

    private static native BarCodeScannerResult recognizeJPEG(byte[] var0, int[] var1, int var2, int var3, int var4);

    private static native BarCodeScannerResult recognizeBitmap(Bitmap var0, int[] var1, int var2);

    static {
        System.loadLibrary("lept");
        System.loadLibrary("tess");
        System.loadLibrary("scanbotsdk");
    }
}

