/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.chequescanner;

import android.graphics.Bitmap;
import android.util.Log;
import io.scanbot.chequescanner.model.Result;

public class ChequeRecognizer {
    public ChequeRecognizer(String tessDataPath) {
        ChequeRecognizer.ctor(tessDataPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result recognizeCheque(byte[] nv21, int width, int height, int orientation) {
        long a = System.currentTimeMillis();
        try {
            Result result = ChequeRecognizer.recognize(nv21, width, height, orientation);
            return result;
        }
        finally {
            long b = System.currentTimeMillis();
            Log.d((String)"ChequeRecognizer", (String)("Total recognition time (sec): " + (float)(b - a) / 1000.0f));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result recognizeChequeBGR(byte[] bgr, int width, int height, int orientation) {
        long a = System.currentTimeMillis();
        try {
            Result result = ChequeRecognizer.recognizeBGR(bgr, width, height, orientation);
            return result;
        }
        finally {
            long b = System.currentTimeMillis();
            Log.d((String)"ChequeRecognizer", (String)("Total recognition time (sec): " + (float)(b - a) / 1000.0f));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result recognizeChequeJPEG(byte[] bgr, int width, int height, int orientation) {
        long a = System.currentTimeMillis();
        try {
            Result result = ChequeRecognizer.recognizeJPEG(bgr, width, height, orientation);
            return result;
        }
        finally {
            long b = System.currentTimeMillis();
            Log.d((String)"ChequeRecognizer", (String)("Total recognition time (sec): " + (float)(b - a) / 1000.0f));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result recognizeChequeBitmap(Bitmap image, int orientation) {
        long a = System.currentTimeMillis();
        try {
            Result result = ChequeRecognizer.recognizeBitmap(image, orientation);
            return result;
        }
        finally {
            long b = System.currentTimeMillis();
            Log.d((String)"ChequeRecognizer", (String)("Total recognition time (sec): " + (float)(b - a) / 1000.0f));
        }
    }

    private static native void ctor(String var0);

    private static native Result recognize(byte[] var0, int var1, int var2, int var3);

    private static native Result recognizeBGR(byte[] var0, int var1, int var2, int var3);

    private static native Result recognizeJPEG(byte[] var0, int var1, int var2, int var3);

    private static native Result recognizeBitmap(Bitmap var0, int var1);

    static {
        System.loadLibrary("lept");
        System.loadLibrary("tess");
        System.loadLibrary("scanbotsdk");
    }
}

