/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.tesseract.android;

import com.googlecode.tesseract.android.TessBaseAPI;

public class TessPdfRenderer {
    private final long mNativePdfRenderer;
    private boolean mRecycled;

    public TessPdfRenderer(TessBaseAPI baseApi, String outputPath) {
        this.mNativePdfRenderer = TessPdfRenderer.nativeCreate(baseApi.getNativeData(), outputPath);
        this.mRecycled = false;
    }

    public long getNativePdfRenderer() {
        if (this.mRecycled) {
            throw new IllegalStateException();
        }
        return this.mNativePdfRenderer;
    }

    public void recycle() {
        TessPdfRenderer.nativeRecycle(this.mNativePdfRenderer);
        this.mRecycled = true;
    }

    private static native long nativeCreate(long var0, String var2);

    private static native void nativeRecycle(long var0);

    static {
        System.loadLibrary("lept");
        System.loadLibrary("tess");
        System.loadLibrary("jpgt");
    }
}

