/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.tiffwriter;

import android.graphics.Bitmap;
import android.util.Log;
import io.scanbot.tiffwriter.model.TIFFImageWriterParameters;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class TIFFWriter {
    public boolean writeTIFFFromImages(Bitmap[] images, File targetFile, TIFFImageWriterParameters parameters) {
        boolean result = TIFFWriter.writeTIFF(images, targetFile.getPath(), parameters);
        if (result) {
            Log.d((String)"TIFFWriter", (String)("TIFF file saved: " + targetFile.getPath()));
        } else {
            Log.d((String)"TIFFWriter", (String)"TIFF file save failed.");
        }
        return result;
    }

    public boolean writeTIFFFromFiles(List<File> sourceFiles, File targetFile, TIFFImageWriterParameters parameters) {
        ArrayList<String> sourcePaths = new ArrayList<String>();
        for (File sourceFile : sourceFiles) {
            sourcePaths.add(sourceFile.getPath());
        }
        boolean result = TIFFWriter.writeTIFFFromFilePaths(sourcePaths.toArray(new String[sourcePaths.size()]), targetFile.getPath(), parameters);
        if (result) {
            Log.d((String)"TIFFWriter", (String)("TIFF file saved: " + targetFile.getPath()));
        } else {
            Log.d((String)"TIFFWriter", (String)"TIFF file save failed.");
        }
        return result;
    }

    @Deprecated
    public boolean writeSinglePageTIFFFromBitmap(Bitmap bitmap, File targetFile) {
        boolean result = TIFFWriter.writeTIFF(new Bitmap[]{bitmap}, targetFile.getPath(), TIFFImageWriterParameters.defaultParameters());
        if (result) {
            Log.d((String)"TIFFWriter", (String)("TIFF file saved: " + targetFile.getPath()));
        } else {
            Log.d((String)"TIFFWriter", (String)"TIFF file save failed.");
        }
        return result;
    }

    @Deprecated
    public boolean writeBinarizedSinglePageTIFFFromBitmap(Bitmap bitmap, File targetFile) {
        boolean result = TIFFWriter.writeTIFF(new Bitmap[]{bitmap}, targetFile.getPath(), TIFFImageWriterParameters.defaultParametersForBinaryImages());
        if (result) {
            Log.d((String)"TIFFWriter", (String)("TIFF file saved: " + targetFile.getPath()));
        } else {
            Log.d((String)"TIFFWriter", (String)"TIFF file save failed.");
        }
        return result;
    }

    @Deprecated
    public boolean writeSinglePageTIFFFromFile(File sourceFile, File targetFile) {
        boolean result = TIFFWriter.writeTIFFFromFilePaths(new String[]{sourceFile.getPath()}, targetFile.getPath(), TIFFImageWriterParameters.defaultParameters());
        if (result) {
            Log.d((String)"TIFFWriter", (String)("TIFF file saved: " + targetFile.getPath()));
        } else {
            Log.d((String)"TIFFWriter", (String)"TIFF file save failed.");
        }
        return result;
    }

    @Deprecated
    public boolean writeBinarizedSinglePageTIFFFromFile(File sourceFile, File targetFile) {
        boolean result = TIFFWriter.writeTIFFFromFilePaths(new String[]{sourceFile.getPath()}, targetFile.getPath(), TIFFImageWriterParameters.defaultParametersForBinaryImages());
        if (result) {
            Log.d((String)"TIFFWriter", (String)("TIFF file saved: " + targetFile.getPath()));
        } else {
            Log.d((String)"TIFFWriter", (String)"TIFF file save failed.");
        }
        return result;
    }

    @Deprecated
    public boolean writeMultiPageTIFFFromBitmapList(List<Bitmap> bitmaps, File targetFile) {
        boolean result = TIFFWriter.writeTIFF(bitmaps.toArray(new Bitmap[bitmaps.size()]), targetFile.getPath(), TIFFImageWriterParameters.defaultParameters());
        if (result) {
            Log.d((String)"TIFFWriter", (String)("TIFF file saved: " + targetFile.getPath()));
        } else {
            Log.d((String)"TIFFWriter", (String)"TIFF file save failed.");
        }
        return result;
    }

    @Deprecated
    public boolean writeBinarizedMultiPageTIFFFromBitmapList(List<Bitmap> bitmaps, File targetFile) {
        boolean result = TIFFWriter.writeTIFF(bitmaps.toArray(new Bitmap[bitmaps.size()]), targetFile.getPath(), TIFFImageWriterParameters.defaultParametersForBinaryImages());
        if (result) {
            Log.d((String)"TIFFWriter", (String)("TIFF file saved: " + targetFile.getPath()));
        } else {
            Log.d((String)"TIFFWriter", (String)"TIFF file save failed.");
        }
        return result;
    }

    @Deprecated
    public boolean writeMultiPageTIFFFromFileList(List<File> sourceFiles, File targetFile) {
        ArrayList<String> sourcePaths = new ArrayList<String>();
        for (File sourceFile : sourceFiles) {
            sourcePaths.add(sourceFile.getPath());
        }
        boolean result = TIFFWriter.writeTIFFFromFilePaths(sourcePaths.toArray(new String[sourcePaths.size()]), targetFile.getPath(), TIFFImageWriterParameters.defaultParameters());
        if (result) {
            Log.d((String)"TIFFWriter", (String)("TIFF file saved: " + targetFile.getPath()));
        } else {
            Log.d((String)"TIFFWriter", (String)"TIFF file save failed.");
        }
        return result;
    }

    @Deprecated
    public boolean writeBinarizedMultiPageTIFFFromFileList(List<File> sourceFiles, File targetFile) {
        ArrayList<String> sourcePaths = new ArrayList<String>();
        for (File sourceFile : sourceFiles) {
            sourcePaths.add(sourceFile.getPath());
        }
        boolean result = TIFFWriter.writeTIFFFromFilePaths(sourcePaths.toArray(new String[sourcePaths.size()]), targetFile.getPath(), TIFFImageWriterParameters.defaultParametersForBinaryImages());
        if (result) {
            Log.d((String)"TIFFWriter", (String)("TIFF file saved: " + targetFile.getPath()));
        } else {
            Log.d((String)"TIFFWriter", (String)"TIFF file save failed.");
        }
        return result;
    }

    private static native boolean writeTIFF(Bitmap[] var0, String var1, TIFFImageWriterParameters var2);

    private static native boolean writeTIFFFromFilePaths(String[] var0, String var1, TIFFImageWriterParameters var2);

    static {
        System.loadLibrary("scanbotsdk");
    }
}

