/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.persistence.fileio;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import io.scanbot.sdk.exceptions.crypto.EncryptionArgumentsException;
import io.scanbot.sdk.exceptions.crypto.SourceFileDoesNotExistException;
import io.scanbot.sdk.persistence.fileio.FileIOProcessor;
import io.scanbot.sdk.util.log.LoggerProvider;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.KeySpec;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 52\u00020\u0001:\u000245B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001eH\u0016J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u001eH\u0016J\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u001eH\u0016J\u0012\u0010&\u001a\u0004\u0018\u00010\n2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u001c\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010)\u001a\u00020*2\b\u0010+\u001a\u0004\u0018\u00010,H\u0016J\u001c\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010\u001d\u001a\u00020\u001e2\b\u0010+\u001a\u0004\u0018\u00010,H\u0016J\u0018\u0010-\u001a\u00020\u001c2\u0006\u0010.\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020\u001eH\u0016J(\u0010/\u001a\u00020\u001c2\u0006\u00100\u001a\u00020(2\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020\u001eH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\t\u001a\u00020\n8F\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000eX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\u0011\u001a\u0004\u0018\u00010\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0013\u0010\u0015\u001a\u00020\n8F\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\fR\u0014\u0010\u0017\u001a\u00020\u0018X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u00066"}, d2={"Lio/scanbot/sdk/persistence/fileio/AESEncryptedFileIOProcessor;", "Lio/scanbot/sdk/persistence/fileio/FileIOProcessor;", "password", "", "encrypterMode", "Lio/scanbot/sdk/persistence/fileio/AESEncryptedFileIOProcessor$AESEncrypterMode;", "(Ljava/lang/String;Lio/scanbot/sdk/persistence/fileio/AESEncryptedFileIOProcessor$AESEncrypterMode;)V", "getEncrypterMode", "()Lio/scanbot/sdk/persistence/fileio/AESEncryptedFileIOProcessor$AESEncrypterMode;", "initializationVector", "", "getInitializationVector", "()[B", "iterationCount", "", "getIterationCount", "()I", "key", "Ljavax/crypto/SecretKey;", "getKey", "()Ljavax/crypto/SecretKey;", "salt", "getSalt", "useEncryption", "", "getUseEncryption", "()Z", "copyRaw", "", "encryptedSource", "Ljava/io/File;", "destination", "openFileInputStream", "Ljava/io/InputStream;", "sourceFile", "openFileOutputStream", "Ljava/io/OutputStream;", "destinationFile", "read", "readImage", "Landroid/graphics/Bitmap;", "encryptedSourceUri", "Landroid/net/Uri;", "options", "Landroid/graphics/BitmapFactory$Options;", "write", "byteArray", "writeImage", "bitmap", "compressFormat", "Landroid/graphics/Bitmap$CompressFormat;", "quality", "AESEncrypterMode", "Companion", "scanbot-sdk-crypto-persistence_release"})
public final class AESEncryptedFileIOProcessor
implements FileIOProcessor {
    private final boolean useEncryption;
    @Nullable
    private final SecretKey key;
    @NotNull
    private final byte[] initializationVector;
    @NotNull
    private final byte[] salt;
    private final int iterationCount;
    @NotNull
    private final AESEncrypterMode encrypterMode;
    public static final int kCCKeySizeAES128 = 16;
    public static final int kCCKeySizeAES256 = 32;
    @NotNull
    public static final String DEFAULT_ENCRYPTION_ALGORITHM = "AES/CBC/PKCS5Padding";
    @NotNull
    public static final String DEFAULT_KEY_GENERATION_ALGORITHM = "PBKDF2WithHmacSHA1";
    @NotNull
    public static final String DEFAULT_KEY_ALGORITHM = "AES";
    public static final Companion Companion = new Companion(null);

    public boolean getUseEncryption() {
        return this.useEncryption;
    }

    @Nullable
    public final SecretKey getKey() {
        return this.key;
    }

    @NotNull
    public final byte[] getInitializationVector() {
        byte[] byArray = this.initializationVector;
        boolean bl = false;
        byte[] byArray2 = Arrays.copyOf(byArray, byArray.length);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"java.util.Arrays.copyOf(this, size)");
        return byArray2;
    }

    @NotNull
    public final byte[] getSalt() {
        byte[] byArray = this.salt;
        boolean bl = false;
        byte[] byArray2 = Arrays.copyOf(byArray, byArray.length);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"java.util.Arrays.copyOf(this, size)");
        return byArray2;
    }

    public final int getIterationCount() {
        return this.iterationCount;
    }

    private final SecretKey getKey(String password) {
        SecretKey secretKey = null;
        try {
            String string = password;
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            char[] cArray = string2.toCharArray();
            Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"(this as java.lang.String).toCharArray()");
            KeySpec keySpec = new PBEKeySpec(cArray, this.getSalt(), this.iterationCount, this.encrypterMode.getKeySize() * 8);
            SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(DEFAULT_KEY_GENERATION_ALGORITHM);
            Intrinsics.checkNotNullExpressionValue((Object)secretKeyFactory, (String)"SecretKeyFactory\n       \u2026KEY_GENERATION_ALGORITHM)");
            SecretKeyFactory keyFactory = secretKeyFactory;
            SecretKey secretKey2 = keyFactory.generateSecret(keySpec);
            Intrinsics.checkNotNullExpressionValue((Object)secretKey2, (String)"keyFactory.generateSecret(keySpec)");
            byte[] byArray = secretKey2.getEncoded();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"keyFactory.generateSecret(keySpec).encoded");
            byte[] keyBytes = byArray;
            secretKey = new SecretKeySpec(keyBytes, DEFAULT_KEY_ALGORITHM);
        }
        catch (NoSuchAlgorithmException e) {
            LoggerProvider.getLogger().logException((Throwable)e);
        }
        return secretKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeImage(@NotNull Bitmap bitmap, @NotNull Bitmap.CompressFormat compressFormat, int quality, @NotNull File destination) {
        Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
        Intrinsics.checkNotNullParameter((Object)compressFormat, (String)"compressFormat");
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        if (destination.exists()) {
            FileUtils.deleteQuietly((File)destination);
        }
        ByteArrayOutputStream imageOutputStream = null;
        try {
            imageOutputStream = new ByteArrayOutputStream();
            bitmap.compress(compressFormat, quality, (OutputStream)imageOutputStream);
            byte[] byArray = imageOutputStream.toByteArray();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"imageOutputStream.toByteArray()");
            this.write(byArray, destination);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)imageOutputStream);
        }
    }

    @Nullable
    public Bitmap readImage(@NotNull File encryptedSource, @Nullable BitmapFactory.Options options) {
        Intrinsics.checkNotNullParameter((Object)encryptedSource, (String)"encryptedSource");
        Uri uri = Uri.fromFile((File)encryptedSource);
        Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"Uri.fromFile(encryptedSource)");
        return this.readImage(uri, options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Bitmap readImage(@NotNull Uri encryptedSourceUri, @Nullable BitmapFactory.Options options) {
        Intrinsics.checkNotNullParameter((Object)encryptedSourceUri, (String)"encryptedSourceUri");
        if (!new File(encryptedSourceUri.getPath()).exists()) {
            throw (Throwable)new SourceFileDoesNotExistException();
        }
        try {
            Closeable closeable = this.openFileInputStream(new File(encryptedSourceUri.getPath()));
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                InputStream it = (InputStream)closeable;
                boolean bl3 = false;
                Bitmap bitmap = BitmapFactory.decodeStream((InputStream)it, null, (BitmapFactory.Options)options);
                return bitmap;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (NoSuchAlgorithmException e) {
            LoggerProvider.getLogger().logException((Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public byte[] read(@NotNull File encryptedSource) {
        Intrinsics.checkNotNullParameter((Object)encryptedSource, (String)"encryptedSource");
        if (!encryptedSource.exists()) {
            throw (Throwable)new SourceFileDoesNotExistException();
        }
        try {
            Closeable closeable = this.openFileInputStream(encryptedSource);
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                InputStream it = (InputStream)closeable;
                boolean bl3 = false;
                byte[] byArray = ByteStreamsKt.readBytes((InputStream)it);
                return byArray;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (NoSuchAlgorithmException e) {
            LoggerProvider.getLogger().logException((Throwable)e);
            return null;
        }
    }

    public void write(@NotNull byte[] byteArray, @NotNull File destination) {
        Intrinsics.checkNotNullParameter((Object)byteArray, (String)"byteArray");
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        if (destination.exists()) {
            FileUtils.deleteQuietly((File)destination);
        }
        try {
            OutputStream cipherOutputStream = this.openFileOutputStream(destination);
            cipherOutputStream.write(byteArray);
            cipherOutputStream.flush();
            cipherOutputStream.close();
        }
        catch (NoSuchAlgorithmException e) {
            LoggerProvider.getLogger().logException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyRaw(@NotNull File encryptedSource, @NotNull File destination) {
        Intrinsics.checkNotNullParameter((Object)encryptedSource, (String)"encryptedSource");
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        if (!encryptedSource.exists()) {
            throw (Throwable)new IOException("Source file does not exist");
        }
        try {
            Closeable closeable = this.openFileInputStream(encryptedSource);
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                InputStream it = (InputStream)closeable;
                boolean bl3 = false;
                FileUtils.copyInputStreamToFile((InputStream)it, (File)destination);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (NoSuchAlgorithmException e) {
            LoggerProvider.getLogger().logException((Throwable)e);
        }
    }

    @NotNull
    public OutputStream openFileOutputStream(@NotNull File destinationFile) {
        Intrinsics.checkNotNullParameter((Object)destinationFile, (String)"destinationFile");
        FileOutputStream destinationOutputStream = new FileOutputStream(destinationFile);
        IvParameterSpec ivSpec = new IvParameterSpec(this.getInitializationVector());
        Cipher aesCipher = Cipher.getInstance(DEFAULT_ENCRYPTION_ALGORITHM);
        aesCipher.init(1, (Key)this.key, ivSpec);
        return new CipherOutputStream(destinationOutputStream, aesCipher);
    }

    @NotNull
    public InputStream openFileInputStream(@NotNull File sourceFile) {
        Intrinsics.checkNotNullParameter((Object)sourceFile, (String)"sourceFile");
        FileInputStream encryptedFileInputStream = new FileInputStream(sourceFile);
        IvParameterSpec ivSpec = new IvParameterSpec(this.getInitializationVector());
        Cipher aesCipher = Cipher.getInstance(DEFAULT_ENCRYPTION_ALGORITHM);
        aesCipher.init(2, (Key)this.key, ivSpec);
        return new CipherInputStream(encryptedFileInputStream, aesCipher);
    }

    @NotNull
    public final AESEncrypterMode getEncrypterMode() {
        return this.encrypterMode;
    }

    public AESEncryptedFileIOProcessor(@NotNull String password, @NotNull AESEncrypterMode encrypterMode) {
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        Intrinsics.checkNotNullParameter((Object)((Object)encrypterMode), (String)"encrypterMode");
        this.encrypterMode = encrypterMode;
        this.useEncryption = true;
        String string = "ScanbotSDK rocks";
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        this.initializationVector = byArray;
        string = "ScanbotSDK rocks";
        charset = Charsets.UTF_8;
        bl = false;
        byte[] byArray2 = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"(this as java.lang.String).getBytes(charset)");
        this.salt = byArray2;
        this.iterationCount = 5000;
        this.key = this.getKey(password);
        if (this.getInitializationVector().length != 16) {
            throw (Throwable)new EncryptionArgumentsException("AESEncryptedImageFileIOProcessor: initialization vector length must be 16.");
        }
    }

    public /* synthetic */ AESEncryptedFileIOProcessor(String string, AESEncrypterMode aESEncrypterMode, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            aESEncrypterMode = AESEncrypterMode.AES256;
        }
        this(string, aESEncrypterMode);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\t"}, d2={"Lio/scanbot/sdk/persistence/fileio/AESEncryptedFileIOProcessor$AESEncrypterMode;", "", "keySize", "", "(Ljava/lang/String;II)V", "getKeySize", "()I", "AES128", "AES256", "scanbot-sdk-crypto-persistence_release"})
    public static final class AESEncrypterMode
    extends Enum<AESEncrypterMode> {
        public static final /* enum */ AESEncrypterMode AES128;
        public static final /* enum */ AESEncrypterMode AES256;
        private static final /* synthetic */ AESEncrypterMode[] $VALUES;
        private final int keySize;

        static {
            AESEncrypterMode[] aESEncrypterModeArray = new AESEncrypterMode[2];
            AESEncrypterMode[] aESEncrypterModeArray2 = aESEncrypterModeArray;
            aESEncrypterModeArray[0] = AES128 = new AESEncrypterMode(16);
            aESEncrypterModeArray[1] = AES256 = new AESEncrypterMode(32);
            $VALUES = aESEncrypterModeArray;
        }

        public final int getKeySize() {
            return this.keySize;
        }

        private AESEncrypterMode(int keySize) {
            this.keySize = keySize;
        }

        public static AESEncrypterMode[] values() {
            return (AESEncrypterMode[])$VALUES.clone();
        }

        public static AESEncrypterMode valueOf(String string) {
            return Enum.valueOf(AESEncrypterMode.class, string);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lio/scanbot/sdk/persistence/fileio/AESEncryptedFileIOProcessor$Companion;", "", "()V", "DEFAULT_ENCRYPTION_ALGORITHM", "", "DEFAULT_KEY_ALGORITHM", "DEFAULT_KEY_GENERATION_ALGORITHM", "kCCKeySizeAES128", "", "kCCKeySizeAES256", "scanbot-sdk-crypto-persistence_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

