/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.persistence.fileio;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import androidx.security.crypto.EncryptedFile;
import androidx.security.crypto.MasterKey;
import io.scanbot.sdk.exceptions.crypto.SourceFileDoesNotExistException;
import io.scanbot.sdk.persistence.fileio.FileIOProcessor;
import io.scanbot.sdk.util.FileUtilsKt;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0010H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0010H\u0016J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u0010H\u0016J\u001c\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0016J\u001c\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001a\u001a\u00020\u00102\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0016J\u0018\u0010!\u001a\u00020\u000e2\u0006\u0010\"\u001a\u00020\u00192\u0006\u0010\u0011\u001a\u00020\u0010H\u0016J(\u0010#\u001a\u00020\u000e2\u0006\u0010$\u001a\u00020\u001c2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u0010\u0011\u001a\u00020\u0010H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006)"}, d2={"Lio/scanbot/sdk/persistence/fileio/EncryptedFileIOProcessor;", "Lio/scanbot/sdk/persistence/fileio/FileIOProcessor;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "getContext", "()Landroid/content/Context;", "mainKey", "Landroidx/security/crypto/MasterKey;", "useEncryption", "", "getUseEncryption", "()Z", "copyRaw", "", "encryptedSource", "Ljava/io/File;", "destination", "openFileInputStream", "Ljava/io/InputStream;", "sourceFile", "openFileOutputStream", "Ljava/io/OutputStream;", "destinationFile", "read", "", "source", "readImage", "Landroid/graphics/Bitmap;", "sourceUri", "Landroid/net/Uri;", "options", "Landroid/graphics/BitmapFactory$Options;", "write", "byteArray", "writeImage", "bitmap", "compressFormat", "Landroid/graphics/Bitmap$CompressFormat;", "quality", "", "scanbot-sdk-crypto-persistence_release"})
public final class EncryptedFileIOProcessor
implements FileIOProcessor {
    @NotNull
    private final Context context;
    private final boolean useEncryption;
    @NotNull
    private final MasterKey mainKey;

    public EncryptedFileIOProcessor(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.useEncryption = true;
        MasterKey masterKey = new MasterKey.Builder(this.context).setKeyScheme(MasterKey.KeyScheme.AES256_GCM).build();
        Intrinsics.checkNotNullExpressionValue((Object)masterKey, (String)"Builder(context)\n       \u2026GCM)\n            .build()");
        this.mainKey = masterKey;
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    public boolean getUseEncryption() {
        return this.useEncryption;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeImage(@NotNull Bitmap bitmap, @NotNull Bitmap.CompressFormat compressFormat, int quality, @NotNull File destination) {
        Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
        Intrinsics.checkNotNullParameter((Object)compressFormat, (String)"compressFormat");
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        Closeable closeable = new ByteArrayOutputStream();
        Throwable throwable = null;
        try {
            ByteArrayOutputStream out = (ByteArrayOutputStream)closeable;
            boolean bl = false;
            bitmap.compress(compressFormat, quality, (OutputStream)out);
            byte[] byArray = out.toByteArray();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"out.toByteArray()");
            this.write(byArray, destination);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @Nullable
    public Bitmap readImage(@NotNull File source, @Nullable BitmapFactory.Options options) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Uri uri = Uri.fromFile((File)source);
        Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"fromFile(source)");
        return this.readImage(uri, options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Bitmap readImage(@NotNull Uri sourceUri, @Nullable BitmapFactory.Options options) {
        Intrinsics.checkNotNullParameter((Object)sourceUri, (String)"sourceUri");
        if (!new File(sourceUri.getPath()).exists()) {
            throw new SourceFileDoesNotExistException();
        }
        Closeable closeable = this.openFileInputStream(new File(sourceUri.getPath()));
        Throwable throwable = null;
        try {
            InputStream it = (InputStream)closeable;
            boolean bl = false;
            Bitmap bitmap = BitmapFactory.decodeStream((InputStream)it, null, (BitmapFactory.Options)options);
            return bitmap;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public byte[] read(@NotNull File source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        if (!source.exists()) {
            throw new SourceFileDoesNotExistException();
        }
        Closeable closeable = this.openFileInputStream(new File(source.getPath()));
        Throwable throwable = null;
        try {
            InputStream it = (InputStream)closeable;
            boolean bl = false;
            byte[] byArray = ByteStreamsKt.readBytes((InputStream)it);
            return byArray;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public void write(@NotNull byte[] byteArray, @NotNull File destination) {
        OutputStream outputStream;
        Intrinsics.checkNotNullParameter((Object)byteArray, (String)"byteArray");
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        if (destination.exists()) {
            destination.delete();
        }
        OutputStream $this$write_u24lambda_u2d3 = outputStream = this.openFileOutputStream(destination);
        boolean bl = false;
        $this$write_u24lambda_u2d3.write(byteArray);
        $this$write_u24lambda_u2d3.flush();
        $this$write_u24lambda_u2d3.close();
    }

    public void copyRaw(@NotNull File encryptedSource, @NotNull File destination) {
        Intrinsics.checkNotNullParameter((Object)encryptedSource, (String)"encryptedSource");
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        if (!encryptedSource.exists()) {
            throw new SourceFileDoesNotExistException();
        }
        FileUtilsKt.copyToFileAndClose((InputStream)this.openFileInputStream(encryptedSource), (File)destination);
    }

    @NotNull
    public OutputStream openFileOutputStream(@NotNull File destinationFile) {
        Intrinsics.checkNotNullParameter((Object)destinationFile, (String)"destinationFile");
        EncryptedFile encryptedFile = new EncryptedFile.Builder(this.context, destinationFile, this.mainKey, EncryptedFile.FileEncryptionScheme.AES256_GCM_HKDF_4KB).build();
        Intrinsics.checkNotNullExpressionValue((Object)encryptedFile, (String)"Builder(\n               \u2026KDF_4KB\n        ).build()");
        EncryptedFile encryptedFile2 = encryptedFile;
        FileOutputStream fileOutputStream = encryptedFile2.openFileOutput();
        Intrinsics.checkNotNullExpressionValue((Object)fileOutputStream, (String)"encryptedFile.openFileOutput()");
        return fileOutputStream;
    }

    @NotNull
    public InputStream openFileInputStream(@NotNull File sourceFile) {
        Intrinsics.checkNotNullParameter((Object)sourceFile, (String)"sourceFile");
        EncryptedFile encryptedFile = new EncryptedFile.Builder(this.context, sourceFile, this.mainKey, EncryptedFile.FileEncryptionScheme.AES256_GCM_HKDF_4KB).build();
        Intrinsics.checkNotNullExpressionValue((Object)encryptedFile, (String)"Builder(\n               \u2026KDF_4KB\n        ).build()");
        EncryptedFile encryptedFile2 = encryptedFile;
        FileInputStream fileInputStream = encryptedFile2.openFileInput();
        Intrinsics.checkNotNullExpressionValue((Object)fileInputStream, (String)"encryptedFile.openFileInput()");
        return fileInputStream;
    }
}

