/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.sdk_native_wrapper.models;

import io.scanbot.sdk.barcode.entity.BarcodeDensity;
import io.scanbot.sdk.barcode.entity.BarcodeDocumentFormat;
import io.scanbot.sdk.barcode.entity.BarcodeFormat;
import io.scanbot.sdk.barcode.entity.EngineMode;
import io.scanbot.sdk.barcode.entity.MSIPlesseyChecksumAlgorithm;
import io.scanbot.sdk.sdk_native_wrapper.converters.BarcodeExtensionsKt;
import io.scanbot.sdk.sdk_native_wrapper.converters.CommonExtensionsKt;
import io.scanbot.sdk.sdk_native_wrapper.helpers.SBNWJsonMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\r\b\u0000\u0018\u00002\u00020\u0001:\u0001EB\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\u0003\u00a2\u0006\u0002\u0010\u0005J\u0014\u0010D\u001a\n\u0012\u0004\u0012\u000209\u0018\u000108*\u000209H\u0002R\"\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\"\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\n\"\u0004\b\u0010\u0010\fR\u001c\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001e\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u001d\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001c\u0010\u001e\u001a\u0004\u0018\u00010\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u001e\u0010$\u001a\u0004\u0018\u00010%X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010*\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R\u001e\u0010+\u001a\u0004\u0018\u00010%X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010*\u001a\u0004\b,\u0010'\"\u0004\b-\u0010)R\u001e\u0010.\u001a\u0004\u0018\u00010\u0018X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u001d\u001a\u0004\b/\u0010\u001a\"\u0004\b0\u0010\u001cR\u001e\u00101\u001a\u0004\u0018\u00010\u0018X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u001d\u001a\u0004\b2\u0010\u001a\"\u0004\b3\u0010\u001cR\u001e\u00104\u001a\u0004\u0018\u00010\u0018X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u001d\u001a\u0004\b5\u0010\u001a\"\u0004\b6\u0010\u001cR\"\u00107\u001a\n\u0012\u0004\u0012\u000209\u0018\u000108X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b:\u0010;\"\u0004\b<\u0010=R\u001e\u0010>\u001a\u0004\u0018\u00010%X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010*\u001a\u0004\b?\u0010'\"\u0004\b@\u0010)R\u001e\u0010A\u001a\u0004\u0018\u00010%X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010*\u001a\u0004\bB\u0010'\"\u0004\bC\u0010)\u00a8\u0006F"}, d2={"Lio/scanbot/sdk/sdk_native_wrapper/models/SBNWBarcodeDetectionParameters;", "", "jsonMap", "", "", "(Ljava/util/Map;)V", "acceptedBarcodeFormats", "", "Lio/scanbot/sdk/barcode/entity/BarcodeFormat;", "getAcceptedBarcodeFormats", "()Ljava/util/List;", "setAcceptedBarcodeFormats", "(Ljava/util/List;)V", "acceptedDocumentFormats", "Lio/scanbot/sdk/barcode/entity/BarcodeDocumentFormat;", "getAcceptedDocumentFormats", "setAcceptedDocumentFormats", "codeDensity", "Lio/scanbot/sdk/barcode/entity/BarcodeDensity;", "getCodeDensity", "()Lio/scanbot/sdk/barcode/entity/BarcodeDensity;", "setCodeDensity", "(Lio/scanbot/sdk/barcode/entity/BarcodeDensity;)V", "decodeStacks1D", "", "getDecodeStacks1D", "()Ljava/lang/Integer;", "setDecodeStacks1D", "(Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "engineMode", "Lio/scanbot/sdk/barcode/entity/EngineMode;", "getEngineMode", "()Lio/scanbot/sdk/barcode/entity/EngineMode;", "setEngineMode", "(Lio/scanbot/sdk/barcode/entity/EngineMode;)V", "gs1DecodingEnabled", "", "getGs1DecodingEnabled", "()Ljava/lang/Boolean;", "setGs1DecodingEnabled", "(Ljava/lang/Boolean;)V", "Ljava/lang/Boolean;", "lowPowerMode", "getLowPowerMode", "setLowPowerMode", "maximumTextLength", "getMaximumTextLength", "setMaximumTextLength", "minimum1DBarcodesQuietZone", "getMinimum1DBarcodesQuietZone", "setMinimum1DBarcodesQuietZone", "minimumTextLength", "getMinimumTextLength", "setMinimumTextLength", "msiPlesseyChecksumAlgorithms", "Ljava/util/EnumSet;", "Lio/scanbot/sdk/barcode/entity/MSIPlesseyChecksumAlgorithm;", "getMsiPlesseyChecksumAlgorithms", "()Ljava/util/EnumSet;", "setMsiPlesseyChecksumAlgorithms", "(Ljava/util/EnumSet;)V", "shouldSaveCameraPreviewFrame", "getShouldSaveCameraPreviewFrame", "setShouldSaveCameraPreviewFrame", "stripCheckDigits", "getStripCheckDigits", "setStripCheckDigits", "toEnumSet", "Keys", "sdk-native-wrapper_release"})
public final class SBNWBarcodeDetectionParameters {
    @Nullable
    private List<? extends BarcodeFormat> acceptedBarcodeFormats;
    @Nullable
    private List<? extends BarcodeDocumentFormat> acceptedDocumentFormats;
    @Nullable
    private Integer minimumTextLength;
    @Nullable
    private Integer maximumTextLength;
    @Nullable
    private Integer minimum1DBarcodesQuietZone;
    @Nullable
    private Boolean stripCheckDigits;
    @Nullable
    private Boolean gs1DecodingEnabled;
    @Nullable
    private EnumSet<MSIPlesseyChecksumAlgorithm> msiPlesseyChecksumAlgorithms;
    @Nullable
    private EngineMode engineMode;
    @Nullable
    private Boolean shouldSaveCameraPreviewFrame;
    @Nullable
    private Boolean lowPowerMode;
    @Nullable
    private Integer decodeStacks1D;
    @Nullable
    private BarcodeDensity codeDensity;

    public SBNWBarcodeDetectionParameters(@NotNull Map<String, ? extends Object> jsonMap) {
        MSIPlesseyChecksumAlgorithm mSIPlesseyChecksumAlgorithm;
        Intrinsics.checkNotNullParameter(jsonMap, (String)"jsonMap");
        SBNWJsonMap map = new SBNWJsonMap(jsonMap);
        List<String> list = map.getStrings("barcodeFormats");
        this.acceptedBarcodeFormats = list == null ? null : BarcodeExtensionsKt.toSdkBarcodeFormats(list);
        List<String> list2 = map.getStrings("acceptedDocumentFormats");
        this.acceptedDocumentFormats = list2 == null ? null : BarcodeExtensionsKt.toSdkBarcodeDocumentFormats(list2);
        this.minimumTextLength = map.getNumberAsInt("minimumTextLength");
        this.maximumTextLength = map.getNumberAsInt("maximumTextLength");
        this.minimum1DBarcodesQuietZone = map.getNumberAsInt("minimum1DBarcodesQuietZone");
        this.stripCheckDigits = map.getBoolean("stripCheckDigits");
        this.gs1DecodingEnabled = map.getBoolean("gs1DecodingEnabled");
        String string = map.getString("msiPlesseyChecksumAlgorithm");
        this.msiPlesseyChecksumAlgorithms = string == null ? null : ((mSIPlesseyChecksumAlgorithm = BarcodeExtensionsKt.toSdkMsiPlesseyChecksumAlgorithm(string)) == null ? null : this.toEnumSet(mSIPlesseyChecksumAlgorithm));
        String string2 = map.getString("engineMode");
        this.engineMode = string2 == null ? null : CommonExtensionsKt.toSdkEngineMode(string2);
        this.shouldSaveCameraPreviewFrame = map.getBoolean("shouldSaveCameraPreviewFrame");
        this.lowPowerMode = map.getBoolean("lowPowerMode");
        this.decodeStacks1D = map.getNumberAsInt("decodeStacks1D");
        String string3 = map.getString("codeDensity");
        this.codeDensity = string3 == null ? null : BarcodeExtensionsKt.toSdkBarcodeDensity(string3);
    }

    @Nullable
    public final List<BarcodeFormat> getAcceptedBarcodeFormats() {
        return this.acceptedBarcodeFormats;
    }

    public final void setAcceptedBarcodeFormats(@Nullable List<? extends BarcodeFormat> list) {
        this.acceptedBarcodeFormats = list;
    }

    @Nullable
    public final List<BarcodeDocumentFormat> getAcceptedDocumentFormats() {
        return this.acceptedDocumentFormats;
    }

    public final void setAcceptedDocumentFormats(@Nullable List<? extends BarcodeDocumentFormat> list) {
        this.acceptedDocumentFormats = list;
    }

    @Nullable
    public final Integer getMinimumTextLength() {
        return this.minimumTextLength;
    }

    public final void setMinimumTextLength(@Nullable Integer n) {
        this.minimumTextLength = n;
    }

    @Nullable
    public final Integer getMaximumTextLength() {
        return this.maximumTextLength;
    }

    public final void setMaximumTextLength(@Nullable Integer n) {
        this.maximumTextLength = n;
    }

    @Nullable
    public final Integer getMinimum1DBarcodesQuietZone() {
        return this.minimum1DBarcodesQuietZone;
    }

    public final void setMinimum1DBarcodesQuietZone(@Nullable Integer n) {
        this.minimum1DBarcodesQuietZone = n;
    }

    @Nullable
    public final Boolean getStripCheckDigits() {
        return this.stripCheckDigits;
    }

    public final void setStripCheckDigits(@Nullable Boolean bl) {
        this.stripCheckDigits = bl;
    }

    @Nullable
    public final Boolean getGs1DecodingEnabled() {
        return this.gs1DecodingEnabled;
    }

    public final void setGs1DecodingEnabled(@Nullable Boolean bl) {
        this.gs1DecodingEnabled = bl;
    }

    @Nullable
    public final EnumSet<MSIPlesseyChecksumAlgorithm> getMsiPlesseyChecksumAlgorithms() {
        return this.msiPlesseyChecksumAlgorithms;
    }

    public final void setMsiPlesseyChecksumAlgorithms(@Nullable EnumSet<MSIPlesseyChecksumAlgorithm> enumSet) {
        this.msiPlesseyChecksumAlgorithms = enumSet;
    }

    @Nullable
    public final EngineMode getEngineMode() {
        return this.engineMode;
    }

    public final void setEngineMode(@Nullable EngineMode engineMode) {
        this.engineMode = engineMode;
    }

    @Nullable
    public final Boolean getShouldSaveCameraPreviewFrame() {
        return this.shouldSaveCameraPreviewFrame;
    }

    public final void setShouldSaveCameraPreviewFrame(@Nullable Boolean bl) {
        this.shouldSaveCameraPreviewFrame = bl;
    }

    @Nullable
    public final Boolean getLowPowerMode() {
        return this.lowPowerMode;
    }

    public final void setLowPowerMode(@Nullable Boolean bl) {
        this.lowPowerMode = bl;
    }

    @Nullable
    public final Integer getDecodeStacks1D() {
        return this.decodeStacks1D;
    }

    public final void setDecodeStacks1D(@Nullable Integer n) {
        this.decodeStacks1D = n;
    }

    @Nullable
    public final BarcodeDensity getCodeDensity() {
        return this.codeDensity;
    }

    public final void setCodeDensity(@Nullable BarcodeDensity barcodeDensity) {
        this.codeDensity = barcodeDensity;
    }

    private final EnumSet<MSIPlesseyChecksumAlgorithm> toEnumSet(MSIPlesseyChecksumAlgorithm $this$toEnumSet) {
        EnumSet<MSIPlesseyChecksumAlgorithm> enumSet;
        EnumSet<MSIPlesseyChecksumAlgorithm> enumSet2 = EnumSet.noneOf(MSIPlesseyChecksumAlgorithm.class);
        if (enumSet2 == null) {
            enumSet = null;
        } else {
            EnumSet<MSIPlesseyChecksumAlgorithm> enumSet3;
            EnumSet<MSIPlesseyChecksumAlgorithm> $this$toEnumSet_u24lambda_u2d0 = enumSet3 = enumSet2;
            boolean bl = false;
            $this$toEnumSet_u24lambda_u2d0.add($this$toEnumSet);
            enumSet = enumSet3;
        }
        return enumSet;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\r\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lio/scanbot/sdk/sdk_native_wrapper/models/SBNWBarcodeDetectionParameters$Keys;", "", "()V", "acceptedBarcodeFormats", "", "acceptedDocumentFormats", "codeDensity", "decodeStacks1D", "engineMode", "gs1DecodingEnabled", "lowPowerMode", "maximumTextLength", "minimum1DBarcodesQuietZone", "minimumTextLength", "msiPlesseyChecksumAlgorithm", "shouldSaveCameraPreviewFrame", "stripCheckDigits", "sdk-native-wrapper_release"})
    public static final class Keys {
        @NotNull
        public static final Keys INSTANCE = new Keys();
        @NotNull
        public static final String acceptedBarcodeFormats = "barcodeFormats";
        @NotNull
        public static final String acceptedDocumentFormats = "acceptedDocumentFormats";
        @NotNull
        public static final String minimumTextLength = "minimumTextLength";
        @NotNull
        public static final String maximumTextLength = "maximumTextLength";
        @NotNull
        public static final String minimum1DBarcodesQuietZone = "minimum1DBarcodesQuietZone";
        @NotNull
        public static final String stripCheckDigits = "stripCheckDigits";
        @NotNull
        public static final String gs1DecodingEnabled = "gs1DecodingEnabled";
        @NotNull
        public static final String msiPlesseyChecksumAlgorithm = "msiPlesseyChecksumAlgorithm";
        @NotNull
        public static final String engineMode = "engineMode";
        @NotNull
        public static final String shouldSaveCameraPreviewFrame = "shouldSaveCameraPreviewFrame";
        @NotNull
        public static final String lowPowerMode = "lowPowerMode";
        @NotNull
        public static final String decodeStacks1D = "decodeStacks1D";
        @NotNull
        public static final String codeDensity = "codeDensity";

        private Keys() {
        }
    }
}

