/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.sdk_native_wrapper.helpers;

import io.scanbot.sdk.barcode.ScanbotBarcodeDetector;
import io.scanbot.sdk.barcode.entity.BarcodeDensity;
import io.scanbot.sdk.barcode.entity.BarcodeDocumentFormat;
import io.scanbot.sdk.barcode.entity.BarcodeScannerAdditionalConfigBuilder;
import io.scanbot.sdk.barcode.entity.BarcodeScannerConfigBuilder;
import io.scanbot.sdk.barcode.entity.BarcodeScanningResult;
import io.scanbot.sdk.barcode.entity.EngineMode;
import io.scanbot.sdk.barcode.entity.MSIPlesseyChecksumAlgorithm;
import io.scanbot.sdk.sdk_native_wrapper.SBNWOperations;
import io.scanbot.sdk.sdk_native_wrapper.helpers.SBNWBitmapHelper;
import io.scanbot.sdk.sdk_native_wrapper.models.SBNWBarcodeDetectionParameters;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0002\u000e\u000fB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0018\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0006J$\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\f2\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0010"}, d2={"Lio/scanbot/sdk/sdk_native_wrapper/helpers/SBNWBarcodeHelper;", "", "()V", "createBarcodeDetector", "Lio/scanbot/sdk/barcode/ScanbotBarcodeDetector;", "detectionParams", "Lio/scanbot/sdk/sdk_native_wrapper/models/SBNWBarcodeDetectionParameters;", "detectBarcodesOnImage", "Lio/scanbot/sdk/barcode/entity/BarcodeScanningResult;", "imageUri", "", "detectBarcodesOnMultipleImages", "", "imageUris", "BarcodeDetectionAdditionalConfigBuilder", "BarcodeDetectionConfigBuilder", "sdk-native-wrapper_release"})
public final class SBNWBarcodeHelper {
    @NotNull
    public static final SBNWBarcodeHelper INSTANCE = new SBNWBarcodeHelper();

    private SBNWBarcodeHelper() {
    }

    @Nullable
    public final BarcodeScanningResult detectBarcodesOnImage(@NotNull String imageUri, @NotNull SBNWBarcodeDetectionParameters detectionParams) {
        Intrinsics.checkNotNullParameter((Object)imageUri, (String)"imageUri");
        Intrinsics.checkNotNullParameter((Object)detectionParams, (String)"detectionParams");
        ScanbotBarcodeDetector detector = this.createBarcodeDetector(detectionParams);
        return detector.detectFromBitmap(SBNWBitmapHelper.INSTANCE.loadImage(imageUri), 0);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<BarcodeScanningResult> detectBarcodesOnMultipleImages(@NotNull List<String> imageUris, @NotNull SBNWBarcodeDetectionParameters detectionParams) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(imageUris, (String)"imageUris");
        Intrinsics.checkNotNullParameter((Object)detectionParams, (String)"detectionParams");
        ScanbotBarcodeDetector detector = this.createBarcodeDetector(detectionParams);
        Iterable $this$map$iv = imageUris;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(detector.detectFromBitmap(SBNWBitmapHelper.INSTANCE.loadImage((String)it), 0));
        }
        return (List)destination$iv$iv;
    }

    private final ScanbotBarcodeDetector createBarcodeDetector(SBNWBarcodeDetectionParameters detectionParams) {
        ScanbotBarcodeDetector detector = SBNWOperations.INSTANCE.getInternalSdk$sdk_native_wrapper_release().createBarcodeDetector();
        detector.modifyConfig((Function1)new BarcodeDetectionConfigBuilder(detectionParams));
        return detector;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0013\u0010\u0007\u001a\u00020\u00032\b\u0010\b\u001a\u0004\u0018\u00010\u0002H\u0096\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lio/scanbot/sdk/sdk_native_wrapper/helpers/SBNWBarcodeHelper$BarcodeDetectionConfigBuilder;", "Lkotlin/Function1;", "Lio/scanbot/sdk/barcode/entity/BarcodeScannerConfigBuilder;", "", "parameters", "Lio/scanbot/sdk/sdk_native_wrapper/models/SBNWBarcodeDetectionParameters;", "(Lio/scanbot/sdk/sdk_native_wrapper/models/SBNWBarcodeDetectionParameters;)V", "invoke", "configBuilder", "sdk-native-wrapper_release"})
    public static final class BarcodeDetectionConfigBuilder
    implements Function1<BarcodeScannerConfigBuilder, Unit> {
        @NotNull
        private final SBNWBarcodeDetectionParameters parameters;

        public BarcodeDetectionConfigBuilder(@NotNull SBNWBarcodeDetectionParameters parameters) {
            Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
            this.parameters = parameters;
        }

        public void invoke(@Nullable BarcodeScannerConfigBuilder configBuilder) {
            EngineMode it;
            EngineMode engineMode = this.parameters.getAcceptedBarcodeFormats();
            if (engineMode != null) {
                it = engineMode;
                boolean bl = false;
                BarcodeScannerConfigBuilder barcodeScannerConfigBuilder = configBuilder;
                if (barcodeScannerConfigBuilder != null) {
                    barcodeScannerConfigBuilder.setBarcodeFormats(it);
                }
            }
            List<BarcodeDocumentFormat> list = this.parameters.getAcceptedDocumentFormats();
            if (list != null) {
                it = list;
                boolean bl = false;
                BarcodeScannerConfigBuilder barcodeScannerConfigBuilder = configBuilder;
                if (barcodeScannerConfigBuilder != null) {
                    barcodeScannerConfigBuilder.setAcceptedDocumentFormats((List)it);
                }
            }
            EngineMode engineMode2 = this.parameters.getEngineMode();
            if (engineMode2 != null) {
                it = engineMode2;
                boolean bl = false;
                BarcodeScannerConfigBuilder barcodeScannerConfigBuilder = configBuilder;
                if (barcodeScannerConfigBuilder != null) {
                    barcodeScannerConfigBuilder.setEngineMode(it);
                }
            }
            Boolean bl = this.parameters.getShouldSaveCameraPreviewFrame();
            if (bl != null) {
                boolean it2 = bl;
                boolean bl2 = false;
                BarcodeScannerConfigBuilder barcodeScannerConfigBuilder = configBuilder;
                if (barcodeScannerConfigBuilder != null) {
                    barcodeScannerConfigBuilder.setSaveCameraPreviewFrame(it2);
                }
            }
            BarcodeScannerConfigBuilder barcodeScannerConfigBuilder = configBuilder;
            if (barcodeScannerConfigBuilder != null) {
                barcodeScannerConfigBuilder.modifyAdditionalConfig((Function1)new BarcodeDetectionAdditionalConfigBuilder(this.parameters));
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0013\u0010\u0007\u001a\u00020\u00032\b\u0010\b\u001a\u0004\u0018\u00010\u0002H\u0096\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lio/scanbot/sdk/sdk_native_wrapper/helpers/SBNWBarcodeHelper$BarcodeDetectionAdditionalConfigBuilder;", "Lkotlin/Function1;", "Lio/scanbot/sdk/barcode/entity/BarcodeScannerAdditionalConfigBuilder;", "", "parameters", "Lio/scanbot/sdk/sdk_native_wrapper/models/SBNWBarcodeDetectionParameters;", "(Lio/scanbot/sdk/sdk_native_wrapper/models/SBNWBarcodeDetectionParameters;)V", "invoke", "builder", "sdk-native-wrapper_release"})
    public static final class BarcodeDetectionAdditionalConfigBuilder
    implements Function1<BarcodeScannerAdditionalConfigBuilder, Unit> {
        @NotNull
        private final SBNWBarcodeDetectionParameters parameters;

        public BarcodeDetectionAdditionalConfigBuilder(@NotNull SBNWBarcodeDetectionParameters parameters) {
            Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
            this.parameters = parameters;
        }

        public void invoke(@Nullable BarcodeScannerAdditionalConfigBuilder builder) {
            boolean bl;
            if (builder == null) {
                return;
            }
            Integer n = this.parameters.getMinimumTextLength();
            if (n != null) {
                int n2 = ((Number)n).intValue();
                bl = false;
                builder.setMinimumTextLength(n2);
            }
            Integer n3 = this.parameters.getMaximumTextLength();
            if (n3 != null) {
                int n4 = ((Number)n3).intValue();
                bl = false;
                builder.setMaximumTextLength(n4);
            }
            Integer n5 = this.parameters.getMinimum1DBarcodesQuietZone();
            if (n5 != null) {
                int n6 = ((Number)n5).intValue();
                bl = false;
                builder.setMinimum1DQuietZoneSize(n6);
            }
            Boolean bl2 = this.parameters.getGs1DecodingEnabled();
            if (bl2 != null) {
                boolean bl3 = bl2;
                boolean bl22 = false;
                builder.setGs1DecodingEnabled(bl3);
            }
            EnumSet<MSIPlesseyChecksumAlgorithm> enumSet = this.parameters.getMsiPlesseyChecksumAlgorithms();
            if (enumSet != null) {
                EnumSet<MSIPlesseyChecksumAlgorithm> enumSet2 = enumSet;
                boolean bl3 = false;
                builder.setMsiPlesseyChecksumAlgorithms(enumSet2);
            }
            Boolean bl4 = this.parameters.getGs1DecodingEnabled();
            if (bl4 != null) {
                boolean bl5 = bl4;
                boolean bl52 = false;
                builder.setGs1DecodingEnabled(bl5);
            }
            Boolean bl6 = this.parameters.getStripCheckDigits();
            if (bl6 != null) {
                boolean bl7 = bl6;
                boolean bl72 = false;
                builder.setStripCheckDigits(bl7);
            }
            Boolean bl8 = this.parameters.getLowPowerMode();
            if (bl8 != null) {
                boolean bl9 = bl8;
                boolean bl92 = false;
                builder.setLowPowerMode(bl9);
            }
            Integer n7 = this.parameters.getDecodeStacks1D();
            if (n7 != null) {
                int n8 = ((Number)n7).intValue();
                boolean bl10 = false;
                builder.setDecodeStacks1D(n8);
            }
            BarcodeDensity barcodeDensity = this.parameters.getCodeDensity();
            if (barcodeDensity != null) {
                BarcodeDensity barcodeDensity2 = barcodeDensity;
                boolean bl11 = false;
                builder.setCodeDensity(barcodeDensity2);
            }
        }
    }
}

