/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.sdk_native_wrapper.wrapper.operations;

import android.content.Context;
import android.graphics.Bitmap;
import android.net.Uri;
import io.scanbot.sdk.persistence.Page;
import io.scanbot.sdk.persistence.PageFileStorage;
import io.scanbot.sdk.sdk_native_wrapper.SBNWOperations;
import io.scanbot.sdk.sdk_native_wrapper.converters.CommonExtensionsKt;
import io.scanbot.sdk.sdk_native_wrapper.converters.PageExtensionsKt;
import io.scanbot.sdk.sdk_native_wrapper.errors.SBNWCommonExceptions;
import io.scanbot.sdk.sdk_native_wrapper.extensions.FileExtensionsKt;
import io.scanbot.sdk.sdk_native_wrapper.helpers.SBNWJsonMap;
import io.scanbot.sdk.sdk_native_wrapper.helpers.SBNWPageHelper;
import io.scanbot.sdk.sdk_native_wrapper.helpers.SBNWPdfHelper;
import io.scanbot.sdk.sdk_native_wrapper.utils.SBNWStorageUtils;
import io.scanbot.sdk.sdk_native_wrapper.wrapper.operations.SBNWPdfOperations;
import io.scanbot.sdk.tiff.model.TIFFImageWriterCompressionOptions;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001\u000fB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00072\u0006\u0010\b\u001a\u00020\u0005J&\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u00042\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u0004J.\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u00042\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u00042\u0006\u0010\f\u001a\u00020\rJ&\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u00042\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u0004\u00a8\u0006\u0010"}, d2={"Lio/scanbot/sdk/sdk_native_wrapper/wrapper/operations/SBNWPdfOperations;", "", "()V", "createPDF", "", "", "imageFileUris", "", "pageSize", "extractImagesFromPdf", "options", "extractPagesFromPdf", "context", "Landroid/content/Context;", "writeTiff", "TiffConstants", "sdk-native-wrapper_release"})
public final class SBNWPdfOperations {
    @NotNull
    public static final SBNWPdfOperations INSTANCE = new SBNWPdfOperations();

    private SBNWPdfOperations() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Map<String, Object> createPDF(@NotNull List<String> imageFileUris, @NotNull String pageSize) {
        Intrinsics.checkNotNullParameter(imageFileUris, (String)"imageFileUris");
        Intrinsics.checkNotNullParameter((Object)pageSize, (String)"pageSize");
        try {
            File file;
            File pdfOutputFile = SBNWStorageUtils.INSTANCE.generateRandomPluginStorageFile("pdf", (Context)SBNWOperations.INSTANCE.getWrapper$sdk_native_wrapper_release().getApplication());
            File tempPdfFile = null;
            File file2 = SBNWOperations.INSTANCE.getInternalSdk$sdk_native_wrapper_release().createPdfRenderer().renderDocumentFromImages(CommonExtensionsKt.toUris(imageFileUris), SBNWOperations.INSTANCE.isEncryptionEnabled(), CommonExtensionsKt.toSdkPdfPageSize(pageSize));
            if (file2 == null) {
                file = null;
            } else {
                File file3;
                File it = file3 = file2;
                boolean bl = false;
                SBNWStorageUtils.INSTANCE.copyFile(it, pdfOutputFile);
                file = file3;
            }
            File file4 = tempPdfFile = file;
            if (file4 != null) {
                FileExtensionsKt.deleteIfExists(file4);
            }
            return MapsKt.mapOf((Pair)TuplesKt.to((Object)"pdfFileUri", (Object)Uri.fromFile((File)pdfOutputFile).toString()));
        }
        catch (IOException err) {
            throw new SBNWCommonExceptions.SBSDKFunctionError(Intrinsics.stringPlus((String)"Error while creating PDF: ", (Object)err));
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, Object> extractPagesFromPdf(@NotNull Map<String, ? extends Object> options, @NotNull Context context) throws SBNWCommonExceptions.SBSDKFunctionError {
        Intrinsics.checkNotNullParameter(options, (String)"options");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = options.get("pdfFilePath");
        if ((object instanceof String ? (String)object : null) == null) {
            throw new SBNWCommonExceptions.SBSDKInvalidJSON("Missing or invalid required 'pdfFilePath' parameter in extractPagesFromPdf options");
        }
        List jsonPages = null;
        try {
            void $this$mapTo$iv$iv;
            Object object2 = this.extractImagesFromPdf(options).get("imagesUris");
            List list = object2 instanceof List ? (List)object2 : null;
            if (list == null) {
                throw new SBNWCommonExceptions.SBSDKFunctionError("Unexpected error while extracting pages from given PDF");
            }
            List imageFileUrls = list;
            Iterable $this$map$iv = imageFileUrls;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                void it;
                Object item$iv$iv;
                Object t = item$iv$iv = iterator.next();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Page page = SBNWPageHelper.INSTANCE.createPageWithImage(String.valueOf(it), context);
                PageFileStorage pageStorage = SBNWOperations.INSTANCE.getInternalSdk$sdk_native_wrapper_release().createPageFileStorage();
                if (pageStorage.getImage(page.getPageId(), PageFileStorage.PageFileType.ORIGINAL, null) != null) {
                    Bitmap image;
                    boolean bl2 = false;
                    pageStorage.setImageForId(image, page.getPageId(), PageFileStorage.PageFileType.UNFILTERED_DOCUMENT);
                    pageStorage.setImageForId(image, page.getPageId(), PageFileStorage.PageFileType.DOCUMENT);
                }
                collection.add(PageExtensionsKt.toJson(page));
            }
            jsonPages = (List)destination$iv$iv;
        }
        catch (IOException ioe) {
            throw new SBNWCommonExceptions.SBSDKFunctionError(Intrinsics.stringPlus((String)"There was a problem when processing the given PDF file: ", (Object)ioe.getMessage()));
        }
        if (!(!((Collection)jsonPages).isEmpty())) {
            throw new SBNWCommonExceptions.SBSDKFunctionError("Cannot extract pages from given PDF");
        }
        return MapsKt.mapOf((Pair)TuplesKt.to((Object)"pages", (Object)jsonPages));
    }

    @NotNull
    public final Map<String, Object> extractImagesFromPdf(@NotNull Map<String, ? extends Object> options) throws IOException {
        String it;
        Intrinsics.checkNotNullParameter(options, (String)"options");
        Function1 error2 = extractImagesFromPdf.error.1.INSTANCE;
        String string = "pdfFilePath";
        SBNWPdfHelper sBNWPdfHelper = SBNWPdfHelper.INSTANCE;
        String string2 = "imageFilesUrls";
        boolean bl = false;
        Object object = options.get(it);
        String string3 = object instanceof String ? (String)object : null;
        if (string3 == null) {
            throw (Throwable)error2.invoke((Object)it);
        }
        String string4 = string3;
        it = "scaling";
        boolean bl2 = false;
        object = options.get(it);
        Float f = object instanceof Float ? (Float)object : null;
        it = "quality";
        boolean bl3 = false;
        object = options.get(it);
        Integer n = object instanceof Integer ? (Integer)object : null;
        it = "bitmapConfig";
        boolean bl4 = false;
        object = options.get(it);
        String string5 = object instanceof String ? (String)object : null;
        Bitmap.Config config = string5 == null ? null : CommonExtensionsKt.toBitmapConfig(string5);
        it = "compression";
        boolean bl5 = false;
        object = options.get(it);
        String string6 = object instanceof String ? (String)object : null;
        Bitmap.CompressFormat compressFormat = string6 == null ? null : CommonExtensionsKt.toBitmapCompressFormat(string6);
        it = "prefix";
        boolean bl6 = false;
        object = options.get(it);
        String string7 = object instanceof String ? (String)object : null;
        return MapsKt.mapOf((Pair)TuplesKt.to((Object)string2, sBNWPdfHelper.extractImagesFromPdf(string4, f, n, config, compressFormat, string7)));
    }

    @NotNull
    public final Map<String, Object> writeTiff(@NotNull Map<String, ? extends Object> options) {
        TIFFImageWriterCompressionOptions compressionOptions;
        TIFFImageWriterCompressionOptions tIFFImageWriterCompressionOptions;
        Intrinsics.checkNotNullParameter(options, (String)"options");
        SBNWJsonMap jsonMap = new SBNWJsonMap(options);
        Boolean bl = jsonMap.getBoolean("oneBitEncoded");
        boolean isBinarized = bl == null ? false : bl;
        Integer n = jsonMap.getNumberAsInt("dpi");
        int dpi = n == null ? 200 : n;
        String string = jsonMap.getString("compression");
        if (string == null) {
            tIFFImageWriterCompressionOptions = null;
        } else {
            String it = string;
            boolean bl2 = false;
            tIFFImageWriterCompressionOptions = TIFFImageWriterCompressionOptions.valueOf((String)it);
        }
        TIFFImageWriterCompressionOptions tIFFImageWriterCompressionOptions2 = tIFFImageWriterCompressionOptions;
        TIFFImageWriterCompressionOptions tIFFImageWriterCompressionOptions3 = tIFFImageWriterCompressionOptions2 == null ? (isBinarized ? TIFFImageWriterCompressionOptions.COMPRESSION_CCITT_T6 : TIFFImageWriterCompressionOptions.COMPRESSION_ADOBE_DEFLATE) : (compressionOptions = tIFFImageWriterCompressionOptions2);
        if (!isBinarized && TiffConstants.INSTANCE.getBinarizedOnlyCompressionTypes().contains(compressionOptions)) {
            throw new SBNWCommonExceptions.SBSDKInvalidJSON("Incompatible compression type. The given compression type " + compressionOptions.name() + " is only applicable to binarized images.");
        }
        return MapsKt.mapOf((Pair)TuplesKt.to((Object)"tiffFileUri", (Object)SBNWPdfHelper.INSTANCE.createTIFF(jsonMap.getStringsOrThrow("imageFileUris"), isBinarized, dpi, compressionOptions)));
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lio/scanbot/sdk/sdk_native_wrapper/wrapper/operations/SBNWPdfOperations$TiffConstants;", "", "()V", "binarizedOnlyCompressionTypes", "", "Lio/scanbot/sdk/tiff/model/TIFFImageWriterCompressionOptions;", "getBinarizedOnlyCompressionTypes", "()Ljava/util/Set;", "sdk-native-wrapper_release"})
    public static final class TiffConstants {
        @NotNull
        public static final TiffConstants INSTANCE = new TiffConstants();
        @NotNull
        private static final Set<TIFFImageWriterCompressionOptions> binarizedOnlyCompressionTypes;

        private TiffConstants() {
        }

        @NotNull
        public final Set<TIFFImageWriterCompressionOptions> getBinarizedOnlyCompressionTypes() {
            return binarizedOnlyCompressionTypes;
        }

        static {
            Object[] objectArray = new TIFFImageWriterCompressionOptions[]{TIFFImageWriterCompressionOptions.COMPRESSION_CCITTRLE, TIFFImageWriterCompressionOptions.COMPRESSION_CCITTFAX3, TIFFImageWriterCompressionOptions.COMPRESSION_CCITTFAX4, TIFFImageWriterCompressionOptions.COMPRESSION_CCITT_T4, TIFFImageWriterCompressionOptions.COMPRESSION_CCITT_T6, TIFFImageWriterCompressionOptions.COMPRESSION_CCITTRLEW};
            binarizedOnlyCompressionTypes = SetsKt.setOf((Object[])objectArray);
        }
    }
}

