/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.sdk_native_wrapper.wrapper.operations;

import android.content.Context;
import android.graphics.Bitmap;
import io.scanbot.sdk.sdk_native_wrapper.SBNWOperations;
import io.scanbot.sdk.sdk_native_wrapper.helpers.SBNWBitmapHelper;
import io.scanbot.sdk.sdk_native_wrapper.helpers.SBNWJsonMap;
import io.scanbot.sdk.sdk_native_wrapper.utils.SBNWStorageUtils;
import java.io.File;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u00042\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u0004J&\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u00042\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u0004J&\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u00042\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u0004\u00a8\u0006\t"}, d2={"Lio/scanbot/sdk/sdk_native_wrapper/wrapper/operations/SBNWImageOperations;", "", "()V", "estimateBlur", "", "", "options", "getBase64ImageData", "rotateImage", "sdk-native-wrapper_release"})
public final class SBNWImageOperations {
    @NotNull
    public static final SBNWImageOperations INSTANCE = new SBNWImageOperations();

    private SBNWImageOperations() {
    }

    @NotNull
    public final Map<String, Object> estimateBlur(@NotNull Map<String, ? extends Object> options) {
        Intrinsics.checkNotNullParameter(options, (String)"options");
        String imageUri = new SBNWJsonMap(options).getStringOrThrow("imageFileUri");
        return MapsKt.mapOf((Pair)TuplesKt.to((Object)"blur", (Object)Float.valueOf(SBNWBitmapHelper.INSTANCE.estimateBlur(imageUri))));
    }

    @NotNull
    public final Map<String, Object> getBase64ImageData(@NotNull Map<String, ? extends Object> options) {
        Intrinsics.checkNotNullParameter(options, (String)"options");
        String imageUri = new SBNWJsonMap(options).getStringOrThrow("imageFileUri");
        return MapsKt.mapOf((Pair)TuplesKt.to((Object)"base64ImageData", (Object)SBNWBitmapHelper.INSTANCE.getBase64Data(imageUri)));
    }

    @NotNull
    public final Map<String, Object> rotateImage(@NotNull Map<String, ? extends Object> options) {
        Intrinsics.checkNotNullParameter(options, (String)"options");
        SBNWJsonMap jsonMap = new SBNWJsonMap(options);
        String imageUri = jsonMap.getStringOrThrow("imageFileUri");
        float degrees = jsonMap.getFloatOrThrow("degrees");
        Bitmap bitmap = SBNWBitmapHelper.INSTANCE.loadImage(imageUri);
        Bitmap rotatedBitmap = SBNWBitmapHelper.INSTANCE.rotateImage(bitmap, -degrees);
        File resultImageUri = SBNWStorageUtils.INSTANCE.storeImageAsFile(rotatedBitmap, SBNWOperations.INSTANCE.getPageStorageSettings$sdk_native_wrapper_release().getImageQuality(), (Context)SBNWOperations.INSTANCE.getWrapper$sdk_native_wrapper_release().getApplication());
        return MapsKt.mapOf((Pair)TuplesKt.to((Object)"imageFileUri", (Object)String.valueOf(resultImageUri)));
    }
}

