/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.sdk_native_wrapper.wrapper.operations;

import io.scanbot.sdk.barcode.entity.BarcodeItem;
import io.scanbot.sdk.barcode.entity.BarcodeScanningResult;
import io.scanbot.sdk.sdk_native_wrapper.converters.BarcodeExtensionsKt;
import io.scanbot.sdk.sdk_native_wrapper.errors.SBNWCommonExceptions;
import io.scanbot.sdk.sdk_native_wrapper.helpers.SBNWBarcodeHelper;
import io.scanbot.sdk.sdk_native_wrapper.helpers.SBNWJsonMap;
import io.scanbot.sdk.sdk_native_wrapper.models.SBNWBarcodeDetectionParameters;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u00042\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u0004J&\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u00042\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u0004\u00a8\u0006\b"}, d2={"Lio/scanbot/sdk/sdk_native_wrapper/wrapper/operations/SBNWBarcodeOperations;", "", "()V", "detectBarcodesOnImage", "", "", "options", "detectBarcodesOnImages", "sdk-native-wrapper_release"})
public final class SBNWBarcodeOperations {
    @NotNull
    public static final SBNWBarcodeOperations INSTANCE = new SBNWBarcodeOperations();

    private SBNWBarcodeOperations() {
    }

    @NotNull
    public final Map<String, Object> detectBarcodesOnImage(@NotNull Map<String, ? extends Object> options) {
        Intrinsics.checkNotNullParameter(options, (String)"options");
        SBNWJsonMap jsonMap = new SBNWJsonMap(options);
        String string = jsonMap.getString("imageFileUri");
        if (string == null) {
            throw new SBNWCommonExceptions.SBSDKInvalidJSON(null, 1, null);
        }
        String imageUri = string;
        BarcodeScanningResult result = SBNWBarcodeHelper.INSTANCE.detectBarcodesOnImage(imageUri, new SBNWBarcodeDetectionParameters(options));
        return BarcodeExtensionsKt.toJson(result);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, Object> detectBarcodesOnImages(@NotNull Map<String, ? extends Object> options) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(options, (String)"options");
        SBNWJsonMap jsonMap = new SBNWJsonMap(options);
        List<String> imageUris = jsonMap.getStringsOrThrow("imageFileUris");
        List<SBNWBarcodeHelper.DetectBarcodesOnMultipleImagesResult> results = SBNWBarcodeHelper.INSTANCE.detectBarcodesOnMultipleImages(imageUris, new SBNWBarcodeDetectionParameters(options));
        Iterable iterable = results;
        String string = "results";
        boolean $i$f$map = false;
        void var7_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Collection<Map<String, Object>> collection;
            void result;
            SBNWBarcodeHelper.DetectBarcodesOnMultipleImagesResult detectBarcodesOnMultipleImagesResult = (SBNWBarcodeHelper.DetectBarcodesOnMultipleImagesResult)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            Pair[] pairArray = new Pair[2];
            pairArray[0] = TuplesKt.to((Object)"imageFileUri", (Object)result.getImageUri());
            Pair[] pairArray2 = pairArray;
            int n = 1;
            String string2 = "barcodeResults";
            BarcodeScanningResult barcodeScanningResult = result.getResult();
            if (barcodeScanningResult == null) {
                collection = null;
            } else {
                List list = barcodeScanningResult.getBarcodeItems();
                if (list == null) {
                    collection = null;
                } else {
                    Collection<Map<String, Object>> collection3;
                    void $this$mapTo$iv$iv2;
                    void $this$map$iv2;
                    Iterable iterable2 = list;
                    String string3 = string2;
                    int n2 = n;
                    Pair[] pairArray3 = pairArray2;
                    boolean $i$f$map2 = false;
                    void var20_21 = $this$map$iv2;
                    Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                    boolean $i$f$mapTo2 = false;
                    for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                        void it;
                        BarcodeItem barcodeItem = (BarcodeItem)item$iv$iv2;
                        collection3 = destination$iv$iv2;
                        boolean bl2 = false;
                        collection3.add(BarcodeExtensionsKt.toJson((BarcodeItem)it));
                    }
                    collection3 = (List)destination$iv$iv2;
                    pairArray2 = pairArray3;
                    n = n2;
                    string2 = string3;
                    collection = collection3;
                }
            }
            pairArray2[n] = TuplesKt.to((Object)string2, collection);
            collection2.add(MapsKt.mapOf((Pair[])pairArray));
        }
        return MapsKt.mapOf((Pair)TuplesKt.to((Object)string, (Object)((List)destination$iv$iv)));
    }
}

