/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.sdk_native_wrapper.helpers;

import android.graphics.Bitmap;
import android.net.Uri;
import io.scanbot.sdk.process.CropOperation;
import io.scanbot.sdk.process.FilterOperation;
import io.scanbot.sdk.process.ImageFilterType;
import io.scanbot.sdk.process.Operation;
import io.scanbot.sdk.sdk_native_wrapper.SBNWOperations;
import io.scanbot.sdk.sdk_native_wrapper.errors.SBNWCommonExceptions;
import io.scanbot.sdk.sdk_native_wrapper.helpers.BiMapKt;
import io.scanbot.sdk.sdk_native_wrapper.helpers.ImageFilterTypeMapped;
import io.scanbot.sdk.sdk_native_wrapper.helpers.SBNWBitmapHelper;
import io.scanbot.sdk.sdk_native_wrapper.utils.SBNWStorageUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0016\u0010\u0003\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n\u00a8\u0006\f"}, d2={"Lio/scanbot/sdk/sdk_native_wrapper/helpers/SBNWFiltersHelper;", "", "()V", "applyImageFilter", "Landroid/graphics/Bitmap;", "bitmap", "imageFilter", "Lio/scanbot/sdk/process/ImageFilterType;", "Landroid/net/Uri;", "imageFileUri", "", "filterType", "sdk-native-wrapper_release"})
public final class SBNWFiltersHelper {
    @NotNull
    public static final SBNWFiltersHelper INSTANCE = new SBNWFiltersHelper();

    private SBNWFiltersHelper() {
    }

    @NotNull
    public final Uri applyImageFilter(@NotNull String imageFileUri, @NotNull String filterType) throws SBNWCommonExceptions.SBSDKFunctionError, SBNWCommonExceptions.SBSDKInvalidJSON {
        Intrinsics.checkNotNullParameter((Object)imageFileUri, (String)"imageFileUri");
        Intrinsics.checkNotNullParameter((Object)filterType, (String)"filterType");
        Bitmap bitmap = SBNWBitmapHelper.INSTANCE.loadImage(imageFileUri);
        Bitmap result = this.applyImageFilter(bitmap, BiMapKt.getImageFilterBiMap().get(ImageFilterTypeMapped.valueOf(filterType)));
        Uri uri = Uri.fromFile((File)SBNWStorageUtils.storeImageAsFile$default(SBNWStorageUtils.INSTANCE, result, SBNWOperations.INSTANCE.getPageStorageSettings$sdk_native_wrapper_release().getImageQuality(), null, 4, null));
        if (uri == null) {
            throw new SBNWCommonExceptions.SBSDKFunctionError("Unexpected error while saving the filtered image (source: " + imageFileUri + ')');
        }
        return uri;
    }

    private final Bitmap applyImageFilter(Bitmap bitmap, ImageFilterType imageFilter) {
        Object[] objectArray = new Operation[]{(Operation)new FilterOperation(imageFilter), (Operation)new CropOperation((List)new ArrayList())};
        Bitmap bitmap2 = SBNWOperations.INSTANCE.getInternalSdk$sdk_native_wrapper_release().imageProcessor().processBitmap(bitmap, CollectionsKt.listOf((Object[])objectArray), false);
        if (bitmap2 == null) {
            throw new SBNWCommonExceptions.SBSDKFunctionError("An unexpected error occurred while trying to apply filter " + imageFilter + " to the given image");
        }
        return bitmap2;
    }
}

