/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.sdk_native_wrapper.converters;

import io.scanbot.barcodescanner.model.BarCodeFormattedResult;
import io.scanbot.barcodescanner.model.DEMedicalPlan.DEMedicalPlanDocument;
import io.scanbot.barcodescanner.model.IDCardPDF417.IDCardPDF417Document;
import io.scanbot.barcodescanner.model.MedicalCertificate.MedicalCertificateDocument;
import io.scanbot.barcodescanner.model.SEPA.SEPADocument;
import io.scanbot.barcodescanner.model.VCard.VCardDocument;
import io.scanbot.barcodescanner.model.aamva.AAMVADocument;
import io.scanbot.barcodescanner.model.boardingPass.BoardingPassDocument;
import io.scanbot.barcodescanner.model.gs1.Gs1Document;
import io.scanbot.barcodescanner.model.swissqr.SwissQRDocument;
import io.scanbot.sdk.barcode.entity.BarcodeDensity;
import io.scanbot.sdk.barcode.entity.BarcodeDocumentFormat;
import io.scanbot.sdk.barcode.entity.BarcodeFormat;
import io.scanbot.sdk.barcode.entity.BarcodeItem;
import io.scanbot.sdk.barcode.entity.BarcodeScanningResult;
import io.scanbot.sdk.barcode.entity.MSIPlesseyChecksumAlgorithm;
import io.scanbot.sdk.sdk_native_wrapper.converters.CommonExtensionsKt;
import io.scanbot.sdk.sdk_native_wrapper.converters.SBNWJsonConverters;
import io.scanbot.sdk.sdk_native_wrapper.converters.barcodedocuments.AAMVADocumentFormatKt;
import io.scanbot.sdk.sdk_native_wrapper.converters.barcodedocuments.BoardingPassDocumentFormatKt;
import io.scanbot.sdk.sdk_native_wrapper.converters.barcodedocuments.GS1DocumentFormatKt;
import io.scanbot.sdk.sdk_native_wrapper.converters.barcodedocuments.IDCardPDF417DocumentFormatKt;
import io.scanbot.sdk.sdk_native_wrapper.converters.barcodedocuments.MedicalCertificateDocumentFormatKt;
import io.scanbot.sdk.sdk_native_wrapper.converters.barcodedocuments.MedicalPlanDocumentFormatKt;
import io.scanbot.sdk.sdk_native_wrapper.converters.barcodedocuments.SEPADocumentFormatKt;
import io.scanbot.sdk.sdk_native_wrapper.converters.barcodedocuments.SwissQRDocumentFormatKt;
import io.scanbot.sdk.sdk_native_wrapper.converters.barcodedocuments.VCardDocumentFormatKt;
import io.scanbot.sdk.sdk_native_wrapper.errors.SBNWCommonExceptions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a\u001a\u0010\u0000\u001a\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0001*\u00020\u0004H\u0002\u001a\u0018\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001*\u00020\u0004H\u0000\u001a\f\u0010\u0005\u001a\u00020\u0002*\u00020\u0006H\u0000\u001a\f\u0010\u0005\u001a\u00020\u0002*\u00020\u0007H\u0000\u001a\u0018\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001*\u00020\bH\u0000\u001a\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001*\u0004\u0018\u00010\tH\u0000\u001a\f\u0010\n\u001a\u00020\u000b*\u00020\u0002H\u0000\u001a\f\u0010\f\u001a\u00020\u0006*\u00020\u0002H\u0000\u001a\u0018\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u000e*\b\u0012\u0004\u0012\u00020\u00020\u000eH\u0000\u001a\f\u0010\u000f\u001a\u00020\u0007*\u00020\u0002H\u0000\u001a\u0018\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00070\u000e*\b\u0012\u0004\u0012\u00020\u00020\u000eH\u0000\u001a\f\u0010\u0011\u001a\u00020\u0012*\u00020\u0002H\u0000\u00a8\u0006\u0013"}, d2={"parse", "", "", "", "Lio/scanbot/barcodescanner/model/BarCodeFormattedResult;", "toJson", "Lio/scanbot/sdk/barcode/entity/BarcodeDocumentFormat;", "Lio/scanbot/sdk/barcode/entity/BarcodeFormat;", "Lio/scanbot/sdk/barcode/entity/BarcodeItem;", "Lio/scanbot/sdk/barcode/entity/BarcodeScanningResult;", "toSdkBarcodeDensity", "Lio/scanbot/sdk/barcode/entity/BarcodeDensity;", "toSdkBarcodeDocumentFormat", "toSdkBarcodeDocumentFormats", "", "toSdkBarcodeFormat", "toSdkBarcodeFormats", "toSdkMsiPlesseyChecksumAlgorithm", "Lio/scanbot/sdk/barcode/entity/MSIPlesseyChecksumAlgorithm;", "sdk-native-wrapper_release"})
public final class BarcodeExtensionsKt {
    @NotNull
    public static final Map<String, Object> toJson(@NotNull BarcodeItem $this$toJson) {
        Intrinsics.checkNotNullParameter((Object)$this$toJson, (String)"<this>");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"text", (Object)$this$toJson.getText()), TuplesKt.to((Object)"textWithExtension", (Object)$this$toJson.getTextWithExtension()), TuplesKt.to((Object)"type", (Object)BarcodeExtensionsKt.toJson($this$toJson.getBarcodeFormat())), TuplesKt.to((Object)"rawBytes", (Object)CommonExtensionsKt.toJson($this$toJson.getRawBytes())), TuplesKt.to((Object)"parsedSuccessful", (Object)false)};
        Map json = MapsKt.mutableMapOf((Pair[])pairArray);
        BarCodeFormattedResult barCodeFormattedResult = $this$toJson.getFormattedResult();
        if (barCodeFormattedResult != null) {
            BarCodeFormattedResult it = barCodeFormattedResult;
            boolean bl = false;
            json.put("parsedSuccessful", true);
            json.put("formattedResult", BarcodeExtensionsKt.toJson(it));
        }
        return json;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Map<String, Object> toJson(@Nullable BarcodeScanningResult $this$toJson) {
        List list;
        BarcodeScanningResult barcodeScanningResult = $this$toJson;
        if (barcodeScanningResult == null) {
            list = null;
        } else {
            List list2 = barcodeScanningResult.getBarcodeItems();
            if (list2 == null) {
                list = null;
            } else {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = list2;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    BarcodeItem barcodeItem = (BarcodeItem)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(BarcodeExtensionsKt.toJson((BarcodeItem)it));
                }
                list = (List)destination$iv$iv;
            }
        }
        List list3 = list;
        List barcodes = list3 == null ? (List)new ArrayList() : list3;
        return MapsKt.mapOf((Pair)TuplesKt.to((Object)"barcodes", (Object)barcodes));
    }

    @NotNull
    public static final Map<String, Object> toJson(@NotNull BarCodeFormattedResult $this$toJson) {
        Intrinsics.checkNotNullParameter((Object)$this$toJson, (String)"<this>");
        BarCodeFormattedResult barCodeFormattedResult = $this$toJson;
        String documentFormat = barCodeFormattedResult instanceof AAMVADocument ? "AAMVA" : (barCodeFormattedResult instanceof IDCardPDF417Document ? "ID_CARD_PDF_417" : (barCodeFormattedResult instanceof SEPADocument ? "SEPA" : (barCodeFormattedResult instanceof MedicalCertificateDocument ? "MEDICAL_CERTIFICATE" : (barCodeFormattedResult instanceof BoardingPassDocument ? "BOARDING_PASS" : (barCodeFormattedResult instanceof DEMedicalPlanDocument ? "DE_MEDICAL_PLAN" : (barCodeFormattedResult instanceof VCardDocument ? "VCARD" : (barCodeFormattedResult instanceof SwissQRDocument ? "SWISS_QR" : (barCodeFormattedResult instanceof Gs1Document ? "GS1" : "UNKNOWN"))))))));
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"parsedSuccessful", (Object)$this$toJson.parsedSuccessful), TuplesKt.to((Object)"documentFormat", (Object)documentFormat)};
        Map result = MapsKt.mutableMapOf((Pair[])pairArray);
        Map<String, Object> map = BarcodeExtensionsKt.parse($this$toJson);
        if (map != null) {
            Map<String, Object> parsedResult = map;
            boolean bl = false;
            Iterable $this$forEach$iv = parsedResult.keySet();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Object it;
                String key = (String)element$iv;
                boolean bl2 = false;
                if (parsedResult.get(key) == null) continue;
                boolean bl3 = false;
                result.put(key, it);
            }
        }
        return result;
    }

    private static final Map<String, Object> parse(BarCodeFormattedResult $this$parse) {
        AAMVADocument aAMVADocument = $this$parse instanceof AAMVADocument ? (AAMVADocument)$this$parse : null;
        if (aAMVADocument != null) {
            AAMVADocument it = aAMVADocument;
            boolean bl = false;
            return AAMVADocumentFormatKt.toJson(it);
        }
        BoardingPassDocument boardingPassDocument = $this$parse instanceof BoardingPassDocument ? (BoardingPassDocument)$this$parse : null;
        if (boardingPassDocument != null) {
            BoardingPassDocument it = boardingPassDocument;
            boolean bl = false;
            return BoardingPassDocumentFormatKt.toJson(it);
        }
        Gs1Document gs1Document = $this$parse instanceof Gs1Document ? (Gs1Document)$this$parse : null;
        if (gs1Document != null) {
            Gs1Document it = gs1Document;
            boolean bl = false;
            return GS1DocumentFormatKt.toJson(it);
        }
        IDCardPDF417Document iDCardPDF417Document = $this$parse instanceof IDCardPDF417Document ? (IDCardPDF417Document)$this$parse : null;
        if (iDCardPDF417Document != null) {
            IDCardPDF417Document it = iDCardPDF417Document;
            boolean bl = false;
            return IDCardPDF417DocumentFormatKt.toJson(it);
        }
        MedicalCertificateDocument medicalCertificateDocument = $this$parse instanceof MedicalCertificateDocument ? (MedicalCertificateDocument)$this$parse : null;
        if (medicalCertificateDocument != null) {
            MedicalCertificateDocument it = medicalCertificateDocument;
            boolean bl = false;
            return MedicalCertificateDocumentFormatKt.toJson(it);
        }
        DEMedicalPlanDocument dEMedicalPlanDocument = $this$parse instanceof DEMedicalPlanDocument ? (DEMedicalPlanDocument)$this$parse : null;
        if (dEMedicalPlanDocument != null) {
            DEMedicalPlanDocument it = dEMedicalPlanDocument;
            boolean bl = false;
            return MedicalPlanDocumentFormatKt.toJson(it);
        }
        SEPADocument sEPADocument = $this$parse instanceof SEPADocument ? (SEPADocument)$this$parse : null;
        if (sEPADocument != null) {
            SEPADocument it = sEPADocument;
            boolean bl = false;
            return SEPADocumentFormatKt.toJson(it);
        }
        SwissQRDocument swissQRDocument = $this$parse instanceof SwissQRDocument ? (SwissQRDocument)$this$parse : null;
        if (swissQRDocument != null) {
            SwissQRDocument it = swissQRDocument;
            boolean bl = false;
            return SwissQRDocumentFormatKt.toJson(it);
        }
        VCardDocument vCardDocument = $this$parse instanceof VCardDocument ? (VCardDocument)$this$parse : null;
        if (vCardDocument != null) {
            VCardDocument it = vCardDocument;
            boolean bl = false;
            return VCardDocumentFormatKt.toJson(it);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<BarcodeFormat> toSdkBarcodeFormats(@NotNull List<String> $this$toSdkBarcodeFormats) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$toSdkBarcodeFormats, (String)"<this>");
        Iterable $this$map$iv = $this$toSdkBarcodeFormats;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(BarcodeExtensionsKt.toSdkBarcodeFormat((String)it));
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public static final String toJson(@NotNull BarcodeFormat $this$toJson) {
        Intrinsics.checkNotNullParameter((Object)$this$toJson, (String)"<this>");
        return SBNWJsonConverters.INSTANCE.getBarcodeFormat().convertToJsonValue($this$toJson);
    }

    @NotNull
    public static final BarcodeFormat toSdkBarcodeFormat(@NotNull String $this$toSdkBarcodeFormat) {
        Intrinsics.checkNotNullParameter((Object)$this$toSdkBarcodeFormat, (String)"<this>");
        return SBNWJsonConverters.INSTANCE.getBarcodeFormat().convertToSdkValue($this$toSdkBarcodeFormat);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<BarcodeDocumentFormat> toSdkBarcodeDocumentFormats(@NotNull List<String> $this$toSdkBarcodeDocumentFormats) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$toSdkBarcodeDocumentFormats, (String)"<this>");
        Iterable $this$map$iv = $this$toSdkBarcodeDocumentFormats;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(BarcodeExtensionsKt.toSdkBarcodeDocumentFormat((String)it));
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public static final String toJson(@NotNull BarcodeDocumentFormat $this$toJson) {
        Intrinsics.checkNotNullParameter((Object)$this$toJson, (String)"<this>");
        return SBNWJsonConverters.INSTANCE.getBarcodeDocumentFormat().convertToJsonValue($this$toJson);
    }

    @NotNull
    public static final BarcodeDocumentFormat toSdkBarcodeDocumentFormat(@NotNull String $this$toSdkBarcodeDocumentFormat) {
        Intrinsics.checkNotNullParameter((Object)$this$toSdkBarcodeDocumentFormat, (String)"<this>");
        return SBNWJsonConverters.INSTANCE.getBarcodeDocumentFormat().convertToSdkValue($this$toSdkBarcodeDocumentFormat);
    }

    @NotNull
    public static final MSIPlesseyChecksumAlgorithm toSdkMsiPlesseyChecksumAlgorithm(@NotNull String $this$toSdkMsiPlesseyChecksumAlgorithm) {
        MSIPlesseyChecksumAlgorithm mSIPlesseyChecksumAlgorithm;
        Intrinsics.checkNotNullParameter((Object)$this$toSdkMsiPlesseyChecksumAlgorithm, (String)"<this>");
        switch ($this$toSdkMsiPlesseyChecksumAlgorithm) {
            case "None": {
                mSIPlesseyChecksumAlgorithm = MSIPlesseyChecksumAlgorithm.None;
                break;
            }
            case "Mod10": {
                mSIPlesseyChecksumAlgorithm = MSIPlesseyChecksumAlgorithm.Mod10;
                break;
            }
            case "Mod11IBM": {
                mSIPlesseyChecksumAlgorithm = MSIPlesseyChecksumAlgorithm.Mod11IBM;
                break;
            }
            case "Mod11NCR": {
                mSIPlesseyChecksumAlgorithm = MSIPlesseyChecksumAlgorithm.Mod11NCR;
                break;
            }
            case "Mod1010": {
                mSIPlesseyChecksumAlgorithm = MSIPlesseyChecksumAlgorithm.Mod1010;
                break;
            }
            case "Mod1110IBM": {
                mSIPlesseyChecksumAlgorithm = MSIPlesseyChecksumAlgorithm.Mod1110IBM;
                break;
            }
            case "Mod1110NCR": {
                mSIPlesseyChecksumAlgorithm = MSIPlesseyChecksumAlgorithm.Mod1110NCR;
                break;
            }
            default: {
                throw new SBNWCommonExceptions.SBSDKOptionNotHandled($this$toSdkMsiPlesseyChecksumAlgorithm);
            }
        }
        return mSIPlesseyChecksumAlgorithm;
    }

    @NotNull
    public static final BarcodeDensity toSdkBarcodeDensity(@NotNull String $this$toSdkBarcodeDensity) {
        BarcodeDensity barcodeDensity;
        Intrinsics.checkNotNullParameter((Object)$this$toSdkBarcodeDensity, (String)"<this>");
        String string = $this$toSdkBarcodeDensity;
        if (Intrinsics.areEqual((Object)string, (Object)"LOW")) {
            barcodeDensity = BarcodeDensity.LOW;
        } else if (Intrinsics.areEqual((Object)string, (Object)"HIGH")) {
            barcodeDensity = BarcodeDensity.HIGH;
        } else {
            throw new SBNWCommonExceptions.SBSDKOptionNotHandled($this$toSdkBarcodeDensity);
        }
        return barcodeDensity;
    }
}

