/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.sdk_native_wrapper.wrapper.operations;

import android.content.Context;
import android.graphics.Bitmap;
import android.net.Uri;
import io.scanbot.sdk.process.DocumentQualityAnalyzer;
import io.scanbot.sdk.process.model.DocumentQualityResult;
import io.scanbot.sdk.sdk_native_wrapper.SBNWOperations;
import io.scanbot.sdk.sdk_native_wrapper.errors.SBNWCommonExceptions;
import io.scanbot.sdk.sdk_native_wrapper.extensions.UriExtensionsKt;
import io.scanbot.sdk.sdk_native_wrapper.helpers.SBNWBitmapHelper;
import io.scanbot.sdk.sdk_native_wrapper.helpers.SBNWJsonMap;
import io.scanbot.sdk.sdk_native_wrapper.utils.SBNWStorageUtils;
import java.io.File;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u00042\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u0004J&\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u00042\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u0004J&\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u00042\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u0004\u00a8\u0006\t"}, d2={"Lio/scanbot/sdk/sdk_native_wrapper/wrapper/operations/SBNWImageOperations;", "", "()V", "documentQualityAnalyzer", "", "", "options", "getBase64ImageData", "rotateImage", "sdk-native-wrapper_release"})
public final class SBNWImageOperations {
    @NotNull
    public static final SBNWImageOperations INSTANCE = new SBNWImageOperations();

    private SBNWImageOperations() {
    }

    @NotNull
    public final Map<String, Object> documentQualityAnalyzer(@NotNull Map<String, ? extends Object> options) throws SBNWCommonExceptions.SBSDKResultError {
        Intrinsics.checkNotNullParameter(options, (String)"options");
        String imageFileUri = new SBNWJsonMap(options).getStringOrThrow("imageFileUri");
        Bitmap bitmap = SBNWBitmapHelper.INSTANCE.loadImage(imageFileUri);
        DocumentQualityAnalyzer dqa = SBNWOperations.INSTANCE.getInternalSdk$sdk_native_wrapper_release().createDocumentQualityAnalyzer();
        DocumentQualityResult qualityResult = dqa.analyzeInBitmap(bitmap, 0);
        if (qualityResult != null) {
            return MapsKt.mapOf((Pair)TuplesKt.to((Object)"result", (Object)qualityResult.name()));
        }
        throw new SBNWCommonExceptions.SBSDKResultError(null, 1, null);
    }

    @NotNull
    public final Map<String, Object> getBase64ImageData(@NotNull Map<String, ? extends Object> options) {
        Intrinsics.checkNotNullParameter(options, (String)"options");
        String imageUri = new SBNWJsonMap(options).getStringOrThrow("imageFileUri");
        String base64Data = SBNWBitmapHelper.INSTANCE.getBase64Data(imageUri);
        return MapsKt.mapOf((Pair)TuplesKt.to((Object)"base64ImageData", (Object)base64Data));
    }

    @NotNull
    public final Map<String, Object> rotateImage(@NotNull Map<String, ? extends Object> options) {
        File resultImageUri;
        Intrinsics.checkNotNullParameter(options, (String)"options");
        SBNWJsonMap jsonMap = new SBNWJsonMap(options);
        String imageUri = jsonMap.getStringOrThrow("imageFileUri");
        double degrees = jsonMap.getNumberAsDoubleOrThrow("degrees");
        Bitmap bitmap = SBNWBitmapHelper.INSTANCE.loadImage(imageUri);
        Bitmap rotatedBitmap = SBNWBitmapHelper.INSTANCE.rotateImage(bitmap, -((float)degrees));
        File file = resultImageUri = SBNWStorageUtils.INSTANCE.storeImageAsFile(rotatedBitmap, SBNWOperations.INSTANCE.getPageStorageSettings$sdk_native_wrapper_release().getImageQuality(), (Context)SBNWOperations.INSTANCE.getWrapper$sdk_native_wrapper_release().getApplication());
        if (file != null) {
            File $this$toUri$iv = file;
            boolean $i$f$toUri = false;
            Uri uri = Uri.fromFile((File)$this$toUri$iv);
            Intrinsics.checkExpressionValueIsNotNull((Object)uri, (String)"Uri.fromFile(this)");
            if (uri != null) {
                String string = UriExtensionsKt.toFilePath(uri);
                if (string != null) {
                    String it = string;
                    boolean bl = false;
                    return MapsKt.mapOf((Pair)TuplesKt.to((Object)"imageFileUri", (Object)it));
                }
            }
        }
        throw new SBNWCommonExceptions.SBSDKFunctionError("Unexpected error while rotating the given image");
    }
}

