/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.sdk_native_wrapper.helpers;

import android.graphics.Bitmap;
import android.util.Log;
import io.scanbot.sdk.core.contourdetector.ContourDetector;
import io.scanbot.sdk.core.contourdetector.DetectionResult;
import io.scanbot.sdk.persistence.Page;
import io.scanbot.sdk.persistence.PageFileStorage;
import io.scanbot.sdk.process.CropOperation;
import io.scanbot.sdk.sdk_native_wrapper.SBNWOperations;
import io.scanbot.sdk.sdk_native_wrapper.helpers.SBNWBitmapHelper;
import io.scanbot.sdk.sdk_native_wrapper.models.SBNWDocumentDetectionResult;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bJ\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\f"}, d2={"Lio/scanbot/sdk/sdk_native_wrapper/helpers/SBNWDocumentHelper;", "", "()V", "detectDocument", "Lio/scanbot/sdk/sdk_native_wrapper/models/SBNWDocumentDetectionResult;", "imageUri", "", "detectDocumentOnPage", "Lio/scanbot/sdk/persistence/Page;", "page", "setDocumentImage", "", "sdk-native-wrapper_release"})
public final class SBNWDocumentHelper {
    @NotNull
    public static final SBNWDocumentHelper INSTANCE = new SBNWDocumentHelper();

    private SBNWDocumentHelper() {
    }

    @Nullable
    public final SBNWDocumentDetectionResult detectDocument(@NotNull String imageUri) {
        Intrinsics.checkNotNullParameter((Object)imageUri, (String)"imageUri");
        Bitmap bitmap = SBNWBitmapHelper.INSTANCE.loadImage(imageUri);
        ContourDetector contourDetector = SBNWOperations.INSTANCE.getWrapper$sdk_native_wrapper_release().getContourDetector();
        DetectionResult detectionResult = contourDetector.detect(bitmap);
        if (detectionResult == null) {
            return null;
        }
        DetectionResult sdkDetectionResult = detectionResult;
        Bitmap documentImage = SBNWOperations.INSTANCE.getWrapper$sdk_native_wrapper_release().getImageProcessor().processBitmap(bitmap, CollectionsKt.listOf((Object)new CropOperation(sdkDetectionResult.getPolygonF())));
        if (documentImage == null) {
            Log.w((String)"ScanbotSDK", (String)"SBNW_ERROR: Unable to process bitmap in detectDocument; the document image will be NULL in the result");
        }
        return new SBNWDocumentDetectionResult(sdkDetectionResult, sdkDetectionResult.getPolygonF(), documentImage);
    }

    @NotNull
    public final Page detectDocumentOnPage(@NotNull Page page) {
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        return SBNWOperations.INSTANCE.getInternalSdk$sdk_native_wrapper_release().createPageProcessor().detectDocument(page);
    }

    public final void setDocumentImage(@NotNull Page page, @NotNull String imageUri) {
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        Intrinsics.checkNotNullParameter((Object)imageUri, (String)"imageUri");
        Bitmap bitmap = SBNWBitmapHelper.INSTANCE.loadImage(imageUri);
        PageFileStorage storage = SBNWOperations.INSTANCE.getInternalSdk$sdk_native_wrapper_release().createPageFileStorage();
        storage.setImageForId(bitmap, page.getPageId(), PageFileStorage.PageFileType.DOCUMENT);
    }
}

