/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.sdk_native_wrapper.helpers;

import android.app.Application;
import android.content.Context;
import android.graphics.Bitmap;
import android.net.Uri;
import androidx.core.net.UriKt;
import io.scanbot.imagefilters.ParametricFilter;
import io.scanbot.sdk.docprocessing.PdfPagesExtractor;
import io.scanbot.sdk.persistence.PageFileStorage;
import io.scanbot.sdk.sdk_native_wrapper.SBNWOperations;
import io.scanbot.sdk.sdk_native_wrapper.errors.SBNWCommonExceptions;
import io.scanbot.sdk.sdk_native_wrapper.extensions.UriExtensionsKt;
import io.scanbot.sdk.sdk_native_wrapper.utils.SBNWStorageUtils;
import io.scanbot.sdk.tiff.TIFFWriter;
import io.scanbot.sdk.tiff.model.TIFFImageWriterCompressionOptions;
import io.scanbot.sdk.tiff.model.TIFFImageWriterParameters;
import io.scanbot.sdk.tiff.model.TIFFImageWriterUserDefinedField;
import io.scanbot.sdk_wrapper.extensions.SBWrapperStringExtensionKt;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J<\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0006J\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u00062\u0006\u0010\u0010\u001a\u00020\u0004\u00a8\u0006\u0011"}, d2={"Lio/scanbot/sdk/sdk_native_wrapper/helpers/SBNWPdfHelper;", "", "()V", "createTIFF", "", "imageFileUris", "", "filter", "Lio/scanbot/imagefilters/ParametricFilter;", "dpi", "", "compressionOptions", "Lio/scanbot/sdk/tiff/model/TIFFImageWriterCompressionOptions;", "userDefinedFields", "Lio/scanbot/sdk/tiff/model/TIFFImageWriterUserDefinedField;", "extractImagesFromPdf", "pdfFilePath", "sdk-native-wrapper_release"})
@SourceDebugExtension(value={"SMAP\nSBNWPdfHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SBNWPdfHelper.kt\nio/scanbot/sdk/sdk_native_wrapper/helpers/SBNWPdfHelper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Uri.kt\nandroidx/core/net/UriKt\n*L\n1#1,90:1\n1549#2:91\n1620#2,3:92\n1603#2,9:95\n1855#2:104\n1856#2:106\n1612#2:107\n1#3:105\n36#4:108\n*S KotlinDebug\n*F\n+ 1 SBNWPdfHelper.kt\nio/scanbot/sdk/sdk_native_wrapper/helpers/SBNWPdfHelper\n*L\n45#1:91\n45#1:92,3\n60#1:95,9\n60#1:104\n60#1:106\n60#1:107\n60#1:105\n84#1:108\n*E\n"})
public final class SBNWPdfHelper {
    @NotNull
    public static final SBNWPdfHelper INSTANCE = new SBNWPdfHelper();

    private SBNWPdfHelper() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> extractImagesFromPdf(@NotNull String pdfFilePath) throws IOException {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)pdfFilePath, (String)"pdfFilePath");
        float kScaling = 2.0f;
        Bitmap.Config kBitmapConfig = Bitmap.Config.ARGB_8888;
        Application context = SBNWOperations.INSTANCE.getWrapper$sdk_native_wrapper_release().getApplication();
        File file = StringsKt.startsWith$default((String)pdfFilePath, (String)"content:/", (boolean)false, (int)2, null) ? SBNWStorageUtils.INSTANCE.loadContentFileByCopy(pdfFilePath, "pdf", (Context)context) : SBNWStorageUtils.INSTANCE.loadFileFromUri(pdfFilePath);
        if (file == null) {
            throw new SBNWCommonExceptions.SBSDKFunctionError("Cannot process given PDF");
        }
        File sourceFile = file;
        PageFileStorage pageFileStorage = SBNWOperations.INSTANCE.getInternalSdk$sdk_native_wrapper_release().createPageFileStorage();
        PdfPagesExtractor extractor = SBNWOperations.INSTANCE.getInternalSdk$sdk_native_wrapper_release().createPdfPagesExtractor();
        List pageIds = extractor.pagesFromPdf(sourceFile, kScaling, kBitmapConfig, null, null);
        Iterable $this$map$iv = pageIds;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(UriExtensionsKt.toFilePath(pageFileStorage.getImageURI((String)it, PageFileStorage.PageFileType.ORIGINAL)));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String createTIFF(@NotNull List<String> imageFileUris2, @Nullable ParametricFilter filter, int dpi, @NotNull TIFFImageWriterCompressionOptions compressionOptions, @NotNull List<TIFFImageWriterUserDefinedField> userDefinedFields2) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(imageFileUris2, (String)"imageFileUris");
        Intrinsics.checkNotNullParameter((Object)compressionOptions, (String)"compressionOptions");
        Intrinsics.checkNotNullParameter(userDefinedFields2, (String)"userDefinedFields");
        Iterable $this$mapNotNull$iv = imageFileUris2;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            File it$iv$iv;
            File file;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String fileUri = (String)element$iv$iv;
            boolean bl2 = false;
            Uri uri = SBWrapperStringExtensionKt.toValidUriOrNull(fileUri);
            File file2 = file = uri != null ? UriKt.toFile((Uri)uri) : null;
            if (!(file2 != null ? file2.exists() : false)) {
                throw new SBNWCommonExceptions.SBSDKUriParsingError("File not found: " + fileUri);
            }
            if (file == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List files = (List)destination$iv$iv;
        File tiffOutputFile = SBNWStorageUtils.INSTANCE.generateRandomPluginStorageFile("tiff", (Context)SBNWOperations.INSTANCE.getWrapper$sdk_native_wrapper_release().getApplication());
        TIFFWriter tiffWriter = SBNWOperations.INSTANCE.getInternalSdk$sdk_native_wrapper_release().createTiffWriter();
        boolean success = tiffWriter.writeTIFFFromFiles(files, SBNWOperations.INSTANCE.isEncryptionEnabled(), tiffOutputFile, new TIFFImageWriterParameters(filter, dpi, compressionOptions, userDefinedFields2));
        if (!success) {
            throw new SBNWCommonExceptions.SBSDKFunctionError("TIFF creation failed");
        }
        File $this$toUri$iv = tiffOutputFile;
        boolean $i$f$toUri = false;
        Uri uri = Uri.fromFile((File)$this$toUri$iv);
        Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"fromFile(this)");
        String string = uri.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"{\n            tiffOutput\u2026ri().toString()\n        }");
        return string;
    }
}

