/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk_wrapper.results;

import androidx.annotation.Keep;
import io.scanbot.sap.SdkLicenseInfo;
import io.scanbot.sap.Status;
import java.util.Date;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u001a\n\u0002\u0010\b\n\u0002\b\u0003\b\u0081\b\u0018\u0000 &2\u00020\u0001:\u0001&B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\t\u0010\u001b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u001d\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J\u0010\u0010\u001e\u001a\u0004\u0018\u00010\tH\u00c6\u0003\u00a2\u0006\u0002\u0010\u000fJ:\u0010\u001f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\tH\u00c6\u0001\u00a2\u0006\u0002\u0010 J\u0013\u0010!\u001a\u00020\u00032\b\u0010\"\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010#\u001a\u00020$H\u00d6\u0001J\t\u0010%\u001a\u00020\u0007H\u00d6\u0001R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0002\u0010\u000b\"\u0004\b\f\u0010\rR\u001e\u0010\b\u001a\u0004\u0018\u00010\tX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0012\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001a\u00a8\u0006'"}, d2={"Lio/scanbot/sdk_wrapper/results/SBWrapperLicenseInfoResult;", "", "isLicenseValid", "", "licenseStatus", "Lio/scanbot/sap/Status;", "licenseStatusMessage", "", "licenseExpirationDate", "", "(ZLio/scanbot/sap/Status;Ljava/lang/String;Ljava/lang/Long;)V", "()Z", "setLicenseValid", "(Z)V", "getLicenseExpirationDate", "()Ljava/lang/Long;", "setLicenseExpirationDate", "(Ljava/lang/Long;)V", "Ljava/lang/Long;", "getLicenseStatus", "()Lio/scanbot/sap/Status;", "setLicenseStatus", "(Lio/scanbot/sap/Status;)V", "getLicenseStatusMessage", "()Ljava/lang/String;", "setLicenseStatusMessage", "(Ljava/lang/String;)V", "component1", "component2", "component3", "component4", "copy", "(ZLio/scanbot/sap/Status;Ljava/lang/String;Ljava/lang/Long;)Lio/scanbot/sdk_wrapper/results/SBWrapperLicenseInfoResult;", "equals", "other", "hashCode", "", "toString", "Companion", "sdk-native-wrapper_release"})
@Keep
public final class SBWrapperLicenseInfoResult {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean isLicenseValid;
    @NotNull
    private Status licenseStatus;
    @Nullable
    private String licenseStatusMessage;
    @Nullable
    private Long licenseExpirationDate;

    public SBWrapperLicenseInfoResult(boolean isLicenseValid, @NotNull Status licenseStatus, @Nullable String licenseStatusMessage, @Nullable Long licenseExpirationDate) {
        Intrinsics.checkNotNullParameter((Object)licenseStatus, (String)"licenseStatus");
        this.isLicenseValid = isLicenseValid;
        this.licenseStatus = licenseStatus;
        this.licenseStatusMessage = licenseStatusMessage;
        this.licenseExpirationDate = licenseExpirationDate;
    }

    public final boolean isLicenseValid() {
        return this.isLicenseValid;
    }

    public final void setLicenseValid(boolean bl) {
        this.isLicenseValid = bl;
    }

    @NotNull
    public final Status getLicenseStatus() {
        return this.licenseStatus;
    }

    public final void setLicenseStatus(@NotNull Status status) {
        Intrinsics.checkNotNullParameter((Object)status, (String)"<set-?>");
        this.licenseStatus = status;
    }

    @Nullable
    public final String getLicenseStatusMessage() {
        return this.licenseStatusMessage;
    }

    public final void setLicenseStatusMessage(@Nullable String string) {
        this.licenseStatusMessage = string;
    }

    @Nullable
    public final Long getLicenseExpirationDate() {
        return this.licenseExpirationDate;
    }

    public final void setLicenseExpirationDate(@Nullable Long l) {
        this.licenseExpirationDate = l;
    }

    public final boolean component1() {
        return this.isLicenseValid;
    }

    @NotNull
    public final Status component2() {
        return this.licenseStatus;
    }

    @Nullable
    public final String component3() {
        return this.licenseStatusMessage;
    }

    @Nullable
    public final Long component4() {
        return this.licenseExpirationDate;
    }

    @NotNull
    public final SBWrapperLicenseInfoResult copy(boolean isLicenseValid, @NotNull Status licenseStatus, @Nullable String licenseStatusMessage, @Nullable Long licenseExpirationDate) {
        Intrinsics.checkNotNullParameter((Object)licenseStatus, (String)"licenseStatus");
        return new SBWrapperLicenseInfoResult(isLicenseValid, licenseStatus, licenseStatusMessage, licenseExpirationDate);
    }

    public static /* synthetic */ SBWrapperLicenseInfoResult copy$default(SBWrapperLicenseInfoResult sBWrapperLicenseInfoResult, boolean bl, Status status, String string, Long l, int n, Object object) {
        if ((n & 1) != 0) {
            bl = sBWrapperLicenseInfoResult.isLicenseValid;
        }
        if ((n & 2) != 0) {
            status = sBWrapperLicenseInfoResult.licenseStatus;
        }
        if ((n & 4) != 0) {
            string = sBWrapperLicenseInfoResult.licenseStatusMessage;
        }
        if ((n & 8) != 0) {
            l = sBWrapperLicenseInfoResult.licenseExpirationDate;
        }
        return sBWrapperLicenseInfoResult.copy(bl, status, string, l);
    }

    @NotNull
    public String toString() {
        return "SBWrapperLicenseInfoResult(isLicenseValid=" + this.isLicenseValid + ", licenseStatus=" + this.licenseStatus + ", licenseStatusMessage=" + this.licenseStatusMessage + ", licenseExpirationDate=" + this.licenseExpirationDate + ")";
    }

    public int hashCode() {
        int n = this.isLicenseValid ? 1 : 0;
        if (n != 0) {
            n = 1;
        }
        int result = n;
        result = result * 31 + this.licenseStatus.hashCode();
        result = result * 31 + (this.licenseStatusMessage == null ? 0 : this.licenseStatusMessage.hashCode());
        result = result * 31 + (this.licenseExpirationDate == null ? 0 : ((Object)this.licenseExpirationDate).hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SBWrapperLicenseInfoResult)) {
            return false;
        }
        SBWrapperLicenseInfoResult sBWrapperLicenseInfoResult = (SBWrapperLicenseInfoResult)other;
        if (this.isLicenseValid != sBWrapperLicenseInfoResult.isLicenseValid) {
            return false;
        }
        if (this.licenseStatus != sBWrapperLicenseInfoResult.licenseStatus) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.licenseStatusMessage, (Object)sBWrapperLicenseInfoResult.licenseStatusMessage)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.licenseExpirationDate, (Object)sBWrapperLicenseInfoResult.licenseExpirationDate);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0002J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f\u00a8\u0006\r"}, d2={"Lio/scanbot/sdk_wrapper/results/SBWrapperLicenseInfoResult$Companion;", "", "()V", "descriptionFromLicenseStatus", "", "status", "Lio/scanbot/sap/Status;", "expirationDate", "Ljava/util/Date;", "fromNativeLicenseInfo", "Lio/scanbot/sdk_wrapper/results/SBWrapperLicenseInfoResult;", "licenseInfo", "Lio/scanbot/sap/SdkLicenseInfo;", "sdk-native-wrapper_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SBWrapperLicenseInfoResult fromNativeLicenseInfo(@NotNull SdkLicenseInfo licenseInfo) {
            Intrinsics.checkNotNullParameter((Object)licenseInfo, (String)"licenseInfo");
            String statusMessage = licenseInfo.getLicenseStatusMessage();
            CharSequence charSequence = statusMessage;
            if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                statusMessage = this.descriptionFromLicenseStatus(licenseInfo.getStatus(), licenseInfo.getExpirationDate());
            }
            Date date = licenseInfo.getExpirationDate();
            return new SBWrapperLicenseInfoResult(licenseInfo.isValid(), licenseInfo.getStatus(), statusMessage, date != null ? Long.valueOf(date.getTime()) : null);
        }

        private final String descriptionFromLicenseStatus(Status status, Date expirationDate) {
            Object object;
            switch (WhenMappings.$EnumSwitchMapping$0[status.ordinal()]) {
                case 1: {
                    object = "License is valid.";
                    break;
                }
                case 2: {
                    object = "Trial license is active.";
                    break;
                }
                case 3: {
                    object = "Trial period ended: provide a valid license to continue using ScanbotSDK.";
                    break;
                }
                case 4: {
                    object = "Corrupted license: your Scanbot SDK license seems to be corrupted.";
                    break;
                }
                case 5: {
                    object = "Application ID mismatch: your ScanbotSDK license is not permitted to run with this app.";
                    break;
                }
                case 6: {
                    object = "Operating system mismatch: your ScanbotSDK license is not permitted to run on this operating system.";
                    break;
                }
                case 7: {
                    Object object2 = expirationDate;
                    if (object2 == null || (object2 = ((Date)object2).toString()) == null) {
                        object2 = "";
                    }
                    object = "License expired: your ScanbotSDK license has expired " + (String)object2 + ". Please contact Scanbot for renewal.";
                    break;
                }
                default: {
                    return "Unknown license status.";
                }
            }
            return object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 8, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[Status.values().length];
                try {
                    nArray[Status.StatusOkay.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Status.StatusTrial.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Status.StatusFailureNotSet.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Status.StatusFailureCorrupted.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Status.StatusFailureAppIDMismatch.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Status.StatusFailureWrongOS.ordinal()] = 6;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Status.StatusFailureExpired.ordinal()] = 7;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

