/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.sdk_native_wrapper.wrapper.operations;

import android.content.Context;
import android.graphics.Bitmap;
import android.net.Uri;
import io.scanbot.pdf.model.PdfConfig;
import io.scanbot.sdk.ocr.OpticalCharacterRecognizer;
import io.scanbot.sdk.persistence.Page;
import io.scanbot.sdk.persistence.PageFileStorage;
import io.scanbot.sdk.sdk_native_wrapper.SBNWOperations;
import io.scanbot.sdk.sdk_native_wrapper.configurations.SBDWrapperCreatePdfArgs;
import io.scanbot.sdk.sdk_native_wrapper.configurations.SBDWrapperOcrConfiguration;
import io.scanbot.sdk.sdk_native_wrapper.configurations.SBDWrapperWriteTiffArgs;
import io.scanbot.sdk.sdk_native_wrapper.converters.PageExtensionsKt;
import io.scanbot.sdk.sdk_native_wrapper.errors.SBNWCommonExceptions;
import io.scanbot.sdk.sdk_native_wrapper.helpers.SBNWPageHelper;
import io.scanbot.sdk.sdk_native_wrapper.helpers.SBNWPdfHelper;
import io.scanbot.sdk.sdk_native_wrapper.utils.SBNWStorageUtils;
import io.scanbot.sdk.sdk_native_wrapper.wrapper.operations.SBNWPdfOperations;
import io.scanbot.sdk.util.log.LoggerProvider;
import io.scanbot.sdk_wrapper.SBWrapper;
import io.scanbot.sdk_wrapper.exceptions.SBWrapperExceptions;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.json.JSONObject;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u00042\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u0004J\u001a\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0012\u0010\r\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000e\u001a\u00020\nH\u0002J&\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u00042\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u0004J.\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u00042\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u00042\u0006\u0010\u0011\u001a\u00020\u0012J&\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u00042\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u0004\u00a8\u0006\u0015"}, d2={"Lio/scanbot/sdk/sdk_native_wrapper/wrapper/operations/SBNWPdfOperations;", "", "()V", "createPDF", "", "", "options", "createSandwichedPDF", "Ljava/io/File;", "sandwichedPDFArgs", "Lio/scanbot/sdk/sdk_native_wrapper/configurations/SBDWrapperCreatePdfArgs;", "ocrConfiguration", "Lio/scanbot/sdk/sdk_native_wrapper/configurations/SBDWrapperOcrConfiguration;", "createSimplePDF", "simplePDFArgs", "extractImagesFromPdf", "extractPagesFromPdf", "context", "Landroid/content/Context;", "writeTiff", "configuration", "sdk-native-wrapper_release"})
@SourceDebugExtension(value={"SMAP\nSBNWPdfOperations.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SBNWPdfOperations.kt\nio/scanbot/sdk/sdk_native_wrapper/wrapper/operations/SBNWPdfOperations\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Uri.kt\nandroidx/core/net/UriKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,195:1\n1#2:196\n36#3:197\n1549#4:198\n1620#4,3:199\n*S KotlinDebug\n*F\n+ 1 SBNWPdfOperations.kt\nio/scanbot/sdk/sdk_native_wrapper/wrapper/operations/SBNWPdfOperations\n*L\n61#1:197\n126#1:198\n126#1:199,3\n*E\n"})
public final class SBNWPdfOperations {
    @NotNull
    public static final SBNWPdfOperations INSTANCE = new SBNWPdfOperations();

    private SBNWPdfOperations() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Map<String, Object> createPDF(@NotNull Map<String, ? extends Object> options) throws SBWrapperExceptions.SBWrapperBaseRuntimeException {
        Object tempPdfFile;
        block28: {
            Object object;
            Object object2;
            block30: {
                SBDWrapperCreatePdfArgs wrapperArgs;
                block29: {
                    Intrinsics.checkNotNullParameter(options, (String)"options");
                    tempPdfFile = null;
                    Object object3 = SBWrapper.getGson().fromJson(new JSONObject(options).toString(), SBDWrapperCreatePdfArgs.class);
                    SBDWrapperCreatePdfArgs args = (SBDWrapperCreatePdfArgs)object3;
                    boolean bl = false;
                    if (args.getImageUris().isEmpty()) {
                        throw new SBWrapperExceptions.SBWrapperBaseRuntimeException("Please set at least one image URI");
                    }
                    if (args.getOptions().getOcrConfiguration() != null && args.getOptions().getOcrConfiguration().invalidLanguageList()) {
                        throw new SBWrapperExceptions.SBWrapperBaseRuntimeException("Invalid language list");
                    }
                    Object object4 = object3;
                    Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"gson.fromJson(\n         \u2026          }\n            }");
                    wrapperArgs = (SBDWrapperCreatePdfArgs)object4;
                    object2 = wrapperArgs.getOptions().getOcrConfiguration();
                    if (object2 == null) break block29;
                    SBDWrapperOcrConfiguration it = object2;
                    boolean bl2 = false;
                    File file = INSTANCE.createSandwichedPDF(wrapperArgs, it);
                    object2 = file;
                    if (file != null) break block30;
                }
                object2 = this.createSimplePDF(wrapperArgs);
            }
            if ((object = (tempPdfFile = object2)) == null) break block28;
            Object it = object;
            boolean bl = false;
            File pdfOutputFile = SBNWStorageUtils.INSTANCE.generateRandomPluginStorageFile("pdf", (Context)SBNWOperations.INSTANCE.getWrapper$sdk_native_wrapper_release().getApplication());
            SBNWStorageUtils.INSTANCE.copyFile((File)it, pdfOutputFile);
            File $this$toUri$iv = pdfOutputFile;
            boolean $i$f$toUri = false;
            Uri uri = Uri.fromFile((File)$this$toUri$iv);
            Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"fromFile(this)");
            Map map = MapsKt.mapOf((Pair)TuplesKt.to((Object)"pdfFileUri", (Object)uri.toString()));
            Object object5 = tempPdfFile;
            if (object5 != null) {
                String string;
                File file;
                Object it2 = object5;
                boolean bl3 = false;
                File file2 = file = ((File)it2).getParentFile();
                if (file2 != null) {
                    Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"parentFile");
                    string = FilesKt.getNameWithoutExtension((File)file);
                } else {
                    string = null;
                }
                if (Intrinsics.areEqual((Object)string, (Object)FilesKt.getNameWithoutExtension((File)it2))) {
                    File file3 = file = ((File)it2).getParentFile();
                    if (file3 != null) {
                        Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"parentFile");
                        FilesKt.deleteRecursively((File)file);
                    }
                } else {
                    ((File)it2).delete();
                }
            }
            return map;
        }
        try {
            try {
                throw new SBNWCommonExceptions.SBSDKFunctionError("PDF file is not generated");
            }
            catch (Exception err) {
                throw new SBNWCommonExceptions.SBSDKFunctionError("Error while creating PDF: " + err);
            }
        }
        catch (Throwable throwable) {
            try {
                File file = tempPdfFile;
                if (file != null) {
                    String string;
                    File file4;
                    File it = file;
                    boolean bl = false;
                    File file5 = file4 = it.getParentFile();
                    if (file5 != null) {
                        Intrinsics.checkNotNullExpressionValue((Object)file5, (String)"parentFile");
                        string = FilesKt.getNameWithoutExtension((File)file4);
                    } else {
                        string = null;
                    }
                    if (Intrinsics.areEqual((Object)string, (Object)FilesKt.getNameWithoutExtension((File)it))) {
                        File file6 = file4 = it.getParentFile();
                        if (file6 != null) {
                            Intrinsics.checkNotNullExpressionValue((Object)file6, (String)"parentFile");
                            FilesKt.deleteRecursively((File)file4);
                        }
                    } else {
                        it.delete();
                    }
                }
            }
            catch (Exception ex) {
                LoggerProvider.getLogger().e(SBWrapper.INSTANCE.getLoggerTag$sdk_native_wrapper_release(), ex.getMessage());
            }
            throw throwable;
        }
    }

    private final File createSimplePDF(SBDWrapperCreatePdfArgs simplePDFArgs) {
        return SBNWOperations.INSTANCE.getInternalSdk$sdk_native_wrapper_release().createPdfRenderer().renderDocumentFromImages(simplePDFArgs.getImageUris(), SBNWOperations.INSTANCE.isEncryptionEnabled(), simplePDFArgs.getOptions().toNativePdfConfig());
    }

    private final File createSandwichedPDF(SBDWrapperCreatePdfArgs sandwichedPDFArgs, SBDWrapperOcrConfiguration ocrConfiguration) {
        OpticalCharacterRecognizer opticalCharacterRecognizer;
        OpticalCharacterRecognizer $this$createSandwichedPDF_u24lambda_u244 = opticalCharacterRecognizer = SBNWOperations.INSTANCE.getInternalSdk$sdk_native_wrapper_release().createOcrRecognizer();
        boolean bl = false;
        $this$createSandwichedPDF_u24lambda_u244.setOcrConfig(new OpticalCharacterRecognizer.OcrConfig(ocrConfiguration.getEngineMode(), CollectionsKt.toSet((Iterable)ocrConfiguration.getLanguages())));
        return opticalCharacterRecognizer.recognizeTextWithPdfFromUris(sandwichedPDFArgs.getImageUris(), (boolean)SBNWOperations.INSTANCE.isEncryptionEnabled(), (PdfConfig)sandwichedPDFArgs.getOptions().toNativePdfConfig()).sandwichedPdfDocumentFile;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, Object> extractPagesFromPdf(@NotNull Map<String, ? extends Object> options, @NotNull Context context) throws SBNWCommonExceptions.SBSDKFunctionError {
        Intrinsics.checkNotNullParameter(options, (String)"options");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = options.get("pdfFilePath");
        if ((object instanceof String ? (String)object : null) == null) {
            throw new SBNWCommonExceptions.SBSDKInvalidJSON("Missing or invalid required 'pdfFilePath' parameter in extractPagesFromPdf options");
        }
        List jsonPages = null;
        try {
            void $this$mapTo$iv$iv;
            Object object2 = this.extractImagesFromPdf(options).get("imageFilesUrls");
            List list = object2 instanceof List ? (List)object2 : null;
            if (list == null) {
                throw new SBNWCommonExceptions.SBSDKFunctionError("Unexpected error while extracting pages from given PDF");
            }
            List imageFileUrls = list;
            Iterable $this$map$iv = imageFileUrls;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                void it;
                Object item$iv$iv;
                Object t = item$iv$iv = iterator.next();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Page page = SBNWPageHelper.INSTANCE.createPageWithImage(String.valueOf(it), context);
                PageFileStorage pageStorage = SBNWOperations.INSTANCE.getInternalSdk$sdk_native_wrapper_release().createPageFileStorage();
                Bitmap bitmap = pageStorage.getImage(page.getPageId(), PageFileStorage.PageFileType.ORIGINAL, null);
                if (bitmap != null) {
                    Bitmap image = bitmap;
                    boolean bl2 = false;
                    pageStorage.setImageForId(image, page.getPageId(), PageFileStorage.PageFileType.UNFILTERED_DOCUMENT);
                    pageStorage.setImageForId(image, page.getPageId(), PageFileStorage.PageFileType.DOCUMENT);
                }
                collection.add(PageExtensionsKt.toJson(page));
            }
            jsonPages = (List)destination$iv$iv;
        }
        catch (IOException ioe) {
            throw new SBNWCommonExceptions.SBSDKFunctionError("There was a problem when processing the given PDF file: " + ioe.getMessage());
        }
        if (!(!((Collection)jsonPages).isEmpty())) {
            throw new SBNWCommonExceptions.SBSDKFunctionError("Cannot extract pages from given PDF");
        }
        return MapsKt.mapOf((Pair)TuplesKt.to((Object)"pages", (Object)jsonPages));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, Object> extractImagesFromPdf(@NotNull Map<String, ? extends Object> options) throws IOException {
        void it;
        Intrinsics.checkNotNullParameter(options, (String)"options");
        Function1 error2 = extractImagesFromPdf.error.1.INSTANCE;
        String string = "pdfFilePath";
        SBNWPdfHelper sBNWPdfHelper = SBNWPdfHelper.INSTANCE;
        String string2 = "imageFilesUrls";
        boolean bl = false;
        Object object = options.get(it);
        String string3 = object instanceof String ? (String)object : null;
        if (string3 == null) {
            throw (Throwable)error2.invoke((Object)it);
        }
        String string4 = string3;
        return MapsKt.mapOf((Pair)TuplesKt.to((Object)string2, sBNWPdfHelper.extractImagesFromPdf(string4)));
    }

    @NotNull
    public final Map<String, Object> writeTiff(@NotNull Map<String, ? extends Object> configuration) {
        Intrinsics.checkNotNullParameter(configuration, (String)"configuration");
        SBDWrapperWriteTiffArgs wrapperTiffConfig = (SBDWrapperWriteTiffArgs)SBWrapper.getGson().fromJson(new JSONObject(configuration).toString(), SBDWrapperWriteTiffArgs.class);
        return MapsKt.mapOf((Pair)TuplesKt.to((Object)"tiffFileUri", (Object)SBNWPdfHelper.INSTANCE.createTIFF(wrapperTiffConfig.getImageFileUris(), wrapperTiffConfig.getOptions().getBinarizationFilter(), wrapperTiffConfig.getOptions().getDpi(), wrapperTiffConfig.getOptions().getCompression(), wrapperTiffConfig.getOptions().getUserDefinedFields())));
    }
}

