/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.sdk_native_wrapper.helpers;

import android.app.Application;
import android.content.ContentResolver;
import android.graphics.Bitmap;
import android.net.Uri;
import io.scanbot.mrzscanner.model.MRZGenericDocument;
import io.scanbot.sdk.sdk_native_wrapper.SBNWOperations;
import io.scanbot.sdk.sdk_native_wrapper.errors.SBNWCommonExceptions;
import io.scanbot.sdk_wrapper.SBWrapper;
import io.scanbot.sdk_wrapper.exceptions.SBWrapperExceptions;
import io.scanbot.sdk_wrapper.extensions.SBWrapperStringExtensionKt;
import io.scanbot.sdk_wrapper.extensions.SBWrapperUriExtensionKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lio/scanbot/sdk/sdk_native_wrapper/helpers/SBNWMrzHelper;", "", "()V", "recognizeMrzOnImage", "Lio/scanbot/mrzscanner/model/MRZGenericDocument;", "imageFileUri", "", "sdk-native-wrapper_release"})
public final class SBNWMrzHelper {
    @NotNull
    public static final SBNWMrzHelper INSTANCE = new SBNWMrzHelper();

    private SBNWMrzHelper() {
    }

    @NotNull
    public final MRZGenericDocument recognizeMrzOnImage(@NotNull String imageFileUri) {
        Uri uri;
        block5: {
            block4: {
                Intrinsics.checkNotNullParameter((Object)imageFileUri, (String)"imageFileUri");
                uri = SBWrapperStringExtensionKt.toValidUriOrNull(imageFileUri);
                if (uri == null) break block4;
                Application application = SBWrapper.INSTANCE.getApplication$sdk_native_wrapper_release();
                Intrinsics.checkNotNull((Object)application);
                ContentResolver contentResolver = application.getContentResolver();
                Intrinsics.checkNotNullExpressionValue((Object)contentResolver, (String)"SBWrapper.application!!.contentResolver");
                if ((uri = SBWrapperUriExtensionKt.toBitmap(uri, contentResolver)) == null) break block4;
                Uri it = uri;
                boolean bl = false;
                MRZGenericDocument mRZGenericDocument = SBNWOperations.INSTANCE.getInternalSdk$sdk_native_wrapper_release().createMrzScanner().recognizeMRZBitmap((Bitmap)it, 0);
                if (mRZGenericDocument == null) {
                    throw new SBNWCommonExceptions.SBSDKFunctionError("Unexpected error during MRZ Recognition on image: " + imageFileUri);
                }
                uri = mRZGenericDocument;
                if (mRZGenericDocument != null) break block5;
            }
            throw new SBWrapperExceptions.SBWrapperUriParsingError(null, 1, null);
        }
        return uri;
    }
}

