/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.sdk_native_wrapper.wrapper.operations;

import android.content.Context;
import io.scanbot.sdk.persistence.Page;
import io.scanbot.sdk.sdk_native_wrapper.SBNWOperations;
import io.scanbot.sdk.sdk_native_wrapper.converters.DocumentExtensionsKt;
import io.scanbot.sdk.sdk_native_wrapper.converters.PageExtensionsKt;
import io.scanbot.sdk.sdk_native_wrapper.errors.SBNWCommonExceptions;
import io.scanbot.sdk.sdk_native_wrapper.helpers.SBNWDocumentHelper;
import io.scanbot.sdk.sdk_native_wrapper.helpers.SBNWJsonMap;
import io.scanbot.sdk.sdk_native_wrapper.results.SBNWDocumentDetectionResult;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u00042\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u0004J&\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u00042\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u0004J&\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u00042\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u0004\u00a8\u0006\n"}, d2={"Lio/scanbot/sdk/sdk_native_wrapper/wrapper/operations/SBNWDocumentOperations;", "", "()V", "detectDocumentOnImage", "", "", "options", "detectDocumentOnPage", "jsonPage", "setDocumentImage", "sdk-native-wrapper_release"})
public final class SBNWDocumentOperations {
    @NotNull
    public static final SBNWDocumentOperations INSTANCE = new SBNWDocumentOperations();

    private SBNWDocumentOperations() {
    }

    @NotNull
    public final Map<String, Object> detectDocumentOnImage(@NotNull Map<String, ? extends Object> options) {
        Object object;
        SBNWDocumentDetectionResult result;
        Intrinsics.checkNotNullParameter(options, (String)"options");
        String imageUri = new SBNWJsonMap(options).getStringOrThrow("imageFileUri");
        SBNWDocumentDetectionResult sBNWDocumentDetectionResult = result = SBNWDocumentHelper.INSTANCE.detectDocument(imageUri);
        if (sBNWDocumentDetectionResult != null) {
            sBNWDocumentDetectionResult.applyExifRotationAndStoreUri((Context)SBNWOperations.INSTANCE.getWrapper$sdk_native_wrapper_release().getApplication(), imageUri);
        }
        if ((object = result) == null || (object = DocumentExtensionsKt.toJson((SBNWDocumentDetectionResult)object)) == null) {
            throw new SBNWCommonExceptions.SBSDKFunctionError("Cannot detect document on the image: " + imageUri);
        }
        return object;
    }

    @NotNull
    public final Map<String, Object> detectDocumentOnPage(@NotNull Map<String, ? extends Object> jsonPage) {
        Intrinsics.checkNotNullParameter(jsonPage, (String)"jsonPage");
        return PageExtensionsKt.toJson(SBNWDocumentHelper.INSTANCE.detectDocumentOnPage(PageExtensionsKt.toSdkPage(jsonPage)));
    }

    @NotNull
    public final Map<String, Object> setDocumentImage(@NotNull Map<String, ? extends Object> options) {
        Intrinsics.checkNotNullParameter(options, (String)"options");
        SBNWJsonMap jsonMap = new SBNWJsonMap(options);
        SBNWJsonMap page = jsonMap.getMapOrThrow("page");
        String imageFileUri = jsonMap.getStringOrThrow("imageFileUri");
        Page sdkPage = PageExtensionsKt.toSdkPage(page.toBoringNormalMap());
        SBNWDocumentHelper.INSTANCE.setDocumentImage(sdkPage, imageFileUri);
        return PageExtensionsKt.toJson(sdkPage);
    }
}

