/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.sdk_native_wrapper.helpers;

import android.app.Application;
import android.content.Context;
import android.graphics.Bitmap;
import android.net.Uri;
import io.scanbot.imagefilters.ParametricFilter;
import io.scanbot.sdk.docprocessing.PdfPagesExtractor;
import io.scanbot.sdk.persistence.PageFileStorage;
import io.scanbot.sdk.sdk_native_wrapper.SBNWOperations;
import io.scanbot.sdk.sdk_native_wrapper.errors.SBNWCommonExceptions;
import io.scanbot.sdk.sdk_native_wrapper.extensions.UriExtensionsKt;
import io.scanbot.sdk.sdk_native_wrapper.utils.SBNWStorageUtils;
import io.scanbot.sdk.tiff.TIFFWriter;
import io.scanbot.sdk.tiff.model.TIFFImageWriterCompressionOptions;
import io.scanbot.sdk.tiff.model.TIFFImageWriterParameters;
import io.scanbot.sdk.tiff.model.TIFFImageWriterUserDefinedField;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JA\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\u0002\u0010\u0011J\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00040\u000f2\u0006\u0010\u0013\u001a\u00020\u0004\u00a8\u0006\u0014"}, d2={"Lio/scanbot/sdk/sdk_native_wrapper/helpers/SBNWPdfHelper;", "", "()V", "createTIFF", "", "sourceBitmaps", "", "Landroid/graphics/Bitmap;", "filter", "Lio/scanbot/imagefilters/ParametricFilter;", "dpi", "", "compressionOptions", "Lio/scanbot/sdk/tiff/model/TIFFImageWriterCompressionOptions;", "userDefinedFields", "", "Lio/scanbot/sdk/tiff/model/TIFFImageWriterUserDefinedField;", "([Landroid/graphics/Bitmap;Lio/scanbot/imagefilters/ParametricFilter;ILio/scanbot/sdk/tiff/model/TIFFImageWriterCompressionOptions;Ljava/util/List;)Ljava/lang/String;", "extractImagesFromPdf", "pdfFilePath", "sdk-native-wrapper_release"})
@SourceDebugExtension(value={"SMAP\nSBNWPdfHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SBNWPdfHelper.kt\nio/scanbot/sdk/sdk_native_wrapper/helpers/SBNWPdfHelper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Uri.kt\nandroidx/core/net/UriKt\n*L\n1#1,76:1\n1549#2:77\n1620#2,3:78\n36#3:81\n*S KotlinDebug\n*F\n+ 1 SBNWPdfHelper.kt\nio/scanbot/sdk/sdk_native_wrapper/helpers/SBNWPdfHelper\n*L\n42#1:77\n42#1:78,3\n70#1:81\n*E\n"})
public final class SBNWPdfHelper {
    @NotNull
    public static final SBNWPdfHelper INSTANCE = new SBNWPdfHelper();

    private SBNWPdfHelper() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> extractImagesFromPdf(@NotNull String pdfFilePath) throws IOException {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)pdfFilePath, (String)"pdfFilePath");
        float kScaling = 2.0f;
        Bitmap.Config kBitmapConfig = Bitmap.Config.ARGB_8888;
        Application context = SBNWOperations.INSTANCE.getWrapper$sdk_native_wrapper_release().getApplication();
        File file = StringsKt.startsWith$default((String)pdfFilePath, (String)"content:/", (boolean)false, (int)2, null) ? SBNWStorageUtils.INSTANCE.loadContentFileByCopy(pdfFilePath, "pdf", (Context)context) : SBNWStorageUtils.INSTANCE.loadFileFromUri(pdfFilePath);
        if (file == null) {
            throw new SBNWCommonExceptions.SBSDKFunctionError("Cannot process given PDF");
        }
        File sourceFile = file;
        PageFileStorage pageFileStorage = SBNWOperations.INSTANCE.getInternalSdk$sdk_native_wrapper_release().createPageFileStorage();
        PdfPagesExtractor extractor = SBNWOperations.INSTANCE.getInternalSdk$sdk_native_wrapper_release().createPdfPagesExtractor();
        List pageIds = extractor.pagesFromPdf(sourceFile, kScaling, kBitmapConfig, null, null);
        Iterable $this$map$iv = pageIds;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(UriExtensionsKt.toFilePath(pageFileStorage.getImageURI((String)it, PageFileStorage.PageFileType.ORIGINAL)));
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final String createTIFF(@NotNull Bitmap[] sourceBitmaps, @Nullable ParametricFilter filter, int dpi, @NotNull TIFFImageWriterCompressionOptions compressionOptions, @NotNull List<TIFFImageWriterUserDefinedField> userDefinedFields2) {
        Intrinsics.checkNotNullParameter((Object)sourceBitmaps, (String)"sourceBitmaps");
        Intrinsics.checkNotNullParameter((Object)compressionOptions, (String)"compressionOptions");
        Intrinsics.checkNotNullParameter(userDefinedFields2, (String)"userDefinedFields");
        File tiffOutputFile = SBNWStorageUtils.INSTANCE.generateRandomPluginStorageFile("tiff", (Context)SBNWOperations.INSTANCE.getWrapper$sdk_native_wrapper_release().getApplication());
        TIFFWriter tiffWriter = SBNWOperations.INSTANCE.getInternalSdk$sdk_native_wrapper_release().createTiffWriter();
        boolean success = tiffWriter.writeTIFFFromImages(sourceBitmaps, tiffOutputFile, new TIFFImageWriterParameters(filter, dpi, compressionOptions, userDefinedFields2));
        if (!success) {
            throw new SBNWCommonExceptions.SBSDKFunctionError("TIFF creation failed");
        }
        File $this$toUri$iv = tiffOutputFile;
        boolean $i$f$toUri = false;
        Uri uri = Uri.fromFile((File)$this$toUri$iv);
        Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"fromFile(this)");
        String string = uri.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"{\n            tiffOutput\u2026ri().toString()\n        }");
        return string;
    }
}

