/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk_wrapper.extensions;

import android.content.ContentResolver;
import android.graphics.Bitmap;
import android.graphics.ImageDecoder;
import android.graphics.Matrix;
import android.media.ExifInterface;
import android.net.Uri;
import android.os.Build;
import android.provider.MediaStore;
import android.webkit.MimeTypeMap;
import io.scanbot.sdk.sdk_native_wrapper.SBNWOperations;
import io.scanbot.sdk_wrapper.exceptions.SBWrapperExceptions;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0002\u001a\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\u0014\u0010\t\u001a\u00020\u0004*\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u001a\u001c\u0010\n\u001a\u00020\u000b*\u00020\b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u00a8\u0006\r"}, d2={"exifToGrad", "", "exifOrientation", "imageUriToBitmapDeprecated", "Landroid/graphics/Bitmap;", "contentResolver", "Landroid/content/ContentResolver;", "imageUri", "Landroid/net/Uri;", "toBitmap", "toFileInDirectory", "Ljava/io/File;", "directory", "sdk-native-wrapper_release"})
@SourceDebugExtension(value={"SMAP\nSBWrapperUriExtension.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SBWrapperUriExtension.kt\nio/scanbot/sdk_wrapper/extensions/SBWrapperUriExtensionKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,118:1\n1#2:119\n*E\n"})
public final class SBWrapperUriExtensionKt {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final File toFileInDirectory(@NotNull Uri $this$toFileInDirectory, @NotNull File directory, @NotNull ContentResolver contentResolver) throws Exception {
        File file;
        Intrinsics.checkNotNullParameter((Object)$this$toFileInDirectory, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        Intrinsics.checkNotNullParameter((Object)contentResolver, (String)"contentResolver");
        InputStream inputStream = contentResolver.openInputStream($this$toFileInDirectory);
        if (inputStream != null) {
            Closeable closeable = inputStream;
            Throwable throwable = null;
            try {
                InputStream inputStream2 = (InputStream)closeable;
                boolean bl = false;
                String extension = MimeTypeMap.getSingleton().getExtensionFromMimeType(contentResolver.getType($this$toFileInDirectory));
                File outputFile = new File(directory, UUID.randomUUID().toString() + "." + extension);
                Closeable closeable2 = new FileOutputStream(outputFile);
                Throwable throwable2 = null;
                try {
                    FileOutputStream outputStream = (FileOutputStream)closeable2;
                    boolean bl2 = false;
                    byte[] buffer = new byte[4096];
                    int length = 0;
                    while (true) {
                        int n;
                        int it = n = inputStream2.read(buffer);
                        boolean bl3 = false;
                        length = it;
                        if (n <= 0) break;
                        outputStream.write(buffer, 0, length);
                    }
                    outputStream.flush();
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                }
                file = outputFile;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        throw new SBWrapperExceptions.SBWrapperFileProcessError($this$toFileInDirectory.getPath());
        return file;
    }

    @NotNull
    public static final Bitmap toBitmap(@NotNull Uri $this$toBitmap, @NotNull ContentResolver contentResolver) throws Exception {
        Bitmap bitmap;
        Intrinsics.checkNotNullParameter((Object)$this$toBitmap, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)contentResolver, (String)"contentResolver");
        try {
            Bitmap bitmap2;
            if (Build.VERSION.SDK_INT >= 28) {
                ImageDecoder.Source source = ImageDecoder.createSource((ContentResolver)contentResolver, (Uri)$this$toBitmap);
                Intrinsics.checkNotNullExpressionValue((Object)source, (String)"createSource(contentResolver, this)");
                ImageDecoder.Source source2 = source;
                bitmap2 = ImageDecoder.decodeBitmap((ImageDecoder.Source)source2, SBWrapperUriExtensionKt::toBitmap$lambda$3);
            } else {
                bitmap2 = SBWrapperUriExtensionKt.imageUriToBitmapDeprecated(contentResolver, $this$toBitmap);
            }
            bitmap = bitmap2;
            Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"{\n        if (Build.VERS\u2026er, this)\n        }\n    }");
        }
        catch (Exception ex) {
            Bitmap bitmap3;
            if (Intrinsics.areEqual((Object)$this$toBitmap.getScheme(), (Object)"file")) {
                bitmap3 = SBNWOperations.INSTANCE.getInternalSdk$sdk_native_wrapper_release().fileIOProcessor().readImage($this$toBitmap, null);
                if (bitmap3 == null) {
                    throw ex;
                }
            } else {
                throw ex;
            }
            bitmap = bitmap3;
        }
        return bitmap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Bitmap imageUriToBitmapDeprecated(ContentResolver contentResolver, Uri imageUri) {
        Object object;
        int maxImageSideSize = 4096;
        int orientation = 0;
        if (Build.VERSION.SDK_INT >= 24) {
            InputStream inputStream = contentResolver.openInputStream(imageUri);
            if (inputStream != null) {
                Closeable closeable = inputStream;
                object = null;
                try {
                    ExifInterface exifInterface;
                    InputStream input = (InputStream)closeable;
                    boolean bl = false;
                    ExifInterface $this$imageUriToBitmapDeprecated_u24lambda_u245_u24lambda_u244 = exifInterface = new ExifInterface(input);
                    boolean bl2 = false;
                    orientation = SBWrapperUriExtensionKt.exifToGrad($this$imageUriToBitmapDeprecated_u24lambda_u245_u24lambda_u244.getAttributeInt("Orientation", 0));
                    input = exifInterface;
                }
                catch (Throwable input) {
                    object = input;
                    throw input;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
                }
            }
        }
        Bitmap bitmapToProcess = null;
        bitmapToProcess = MediaStore.Images.Media.getBitmap((ContentResolver)contentResolver, (Uri)imageUri);
        if (orientation != 0 || bitmapToProcess.getWidth() > maxImageSideSize || bitmapToProcess.getHeight() > maxImageSideSize) {
            Matrix $this$imageUriToBitmapDeprecated_u24lambda_u246 = object = new Matrix();
            boolean bl = false;
            if (orientation != 0) {
                $this$imageUriToBitmapDeprecated_u24lambda_u246.setRotate((float)orientation, (float)bitmapToProcess.getWidth() / 2.0f, (float)bitmapToProcess.getHeight() / 2.0f);
            }
            Object matrix = object;
            if (bitmapToProcess.getWidth() > maxImageSideSize || bitmapToProcess.getHeight() > maxImageSideSize) {
                float scale = bitmapToProcess.getWidth() > bitmapToProcess.getHeight() ? (float)maxImageSideSize / (float)bitmapToProcess.getWidth() : (float)maxImageSideSize / (float)bitmapToProcess.getHeight();
                matrix.postScale(scale, scale);
            }
            bitmapToProcess = Bitmap.createBitmap((Bitmap)bitmapToProcess, (int)0, (int)0, (int)bitmapToProcess.getWidth(), (int)bitmapToProcess.getHeight(), (Matrix)matrix, (boolean)false);
        }
        Bitmap bitmap = bitmapToProcess;
        Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"bitmapToProcess");
        return bitmap;
    }

    private static final int exifToGrad(int exifOrientation) {
        int n;
        switch (exifOrientation) {
            case 6: {
                n = 90;
                break;
            }
            case 3: {
                n = 180;
                break;
            }
            case 8: {
                n = 270;
                break;
            }
            default: {
                n = 0;
            }
        }
        return n;
    }

    private static final void toBitmap$lambda$3(ImageDecoder decoder, ImageDecoder.ImageInfo imageInfo, ImageDecoder.Source source) {
        Intrinsics.checkNotNullParameter((Object)decoder, (String)"decoder");
        Intrinsics.checkNotNullParameter((Object)imageInfo, (String)"<anonymous parameter 1>");
        Intrinsics.checkNotNullParameter((Object)source, (String)"<anonymous parameter 2>");
        decoder.setMutableRequired(true);
    }
}

