/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk_wrapper.document.operations.image_operations;

import android.app.Application;
import android.content.ContentResolver;
import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.net.Uri;
import android.util.Base64;
import androidx.core.net.UriKt;
import io.scanbot.sap.SdkLicenseInfo;
import io.scanbot.sdk_wrapper.SBWrapper;
import io.scanbot.sdk_wrapper.document.SBDWrapper;
import io.scanbot.sdk_wrapper.document.extensions.SBDBitmapExtensionKt;
import io.scanbot.sdk_wrapper.document.extensions.SBDUriExtensionKt;
import io.scanbot.sdk_wrapper.document.operations.image_operations.results.SBDImageDataResult;
import io.scanbot.sdk_wrapper.document.operations.image_operations.results.SBDRotatedImageResult;
import io.scanbot.sdk_wrapper.exceptions.SBExceptions;
import io.scanbot.sdk_wrapper.extensions.SBGsonExtensionKt;
import io.scanbot.sdk_wrapper.extensions.SBStringExtensionKt;
import io.scanbot.sdk_wrapper.extensions.SBUriExtensionKt;
import io.scanbot.sdk_wrapper.interfaces.SBResultDelegate;
import io.scanbot.sdk_wrapper.utils.SBStorageUtils;
import java.io.File;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.json.JSONObject;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J \u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\bH\u0007\u00a8\u0006\f"}, d2={"Lio/scanbot/sdk_wrapper/document/operations/image_operations/SBDImageOperations;", "", "()V", "getImageData", "", "imageFileUri", "", "resultDelegate", "Lio/scanbot/sdk_wrapper/interfaces/SBResultDelegate;", "rotateImage", "degrees", "", "document-sdk-wrapper_release"})
public final class SBDImageOperations {
    @NotNull
    public static final SBDImageOperations INSTANCE = new SBDImageOperations();

    private SBDImageOperations() {
    }

    @JvmStatic
    public static final void getImageData(final @NotNull String string, final @NotNull SBResultDelegate sBResultDelegate) {
        Function0 function0;
        Intrinsics.checkNotNullParameter((Object)string, (String)"imageFileUri");
        Intrinsics.checkNotNullParameter((Object)sBResultDelegate, (String)"resultDelegate");
        Object object = SBDWrapper.INSTANCE.getLicenseInfoOrReject$document_sdk_wrapper_release(sBResultDelegate);
        if (object == null) {
            return;
        }
        SdkLicenseInfo sdkLicenseInfo = object;
        object = function0;
        function0 = new Function0(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Loose catch block
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public final void a() {
                Throwable throwable2;
                Object object;
                boolean bl;
                block11: {
                    SBDImageDataResult sBDImageDataResult;
                    Object object2;
                    block10: {
                        bl = false;
                        object = SBStringExtensionKt.toValidUriOrNull(string);
                        if (object == null) throw new SBExceptions.SBWrapperUriParsingError(null, 1, null);
                        if (Intrinsics.areEqual((Object)object.getScheme(), (Object)"file")) {
                            object = UriKt.toFile((Uri)object);
                        } else {
                            bl = true;
                            Application application = SBWrapper.INSTANCE.getApplication$document_sdk_wrapper_release();
                            Intrinsics.checkNotNull((Object)application);
                            ContentResolver contentResolver = application.getContentResolver();
                            Intrinsics.checkNotNullExpressionValue((Object)contentResolver, (String)"getContentResolver(...)");
                            object = SBUriExtensionKt.contentToFile((Uri)object, contentResolver);
                        }
                        if (object == null) throw new SBExceptions.SBWrapperUriParsingError(null, 1, null);
                        object2 = SBDWrapper.INSTANCE.getFileIOProcessor$document_sdk_wrapper_release().read((File)object);
                        if (!bl) break block10;
                        {
                            catch (Throwable throwable2) {
                                break block11;
                            }
                            catch (Exception exception) {}
                            {
                                object2 = FilesKt.readBytes((File)object);
                                if (!bl) break block10;
                            }
                        }
                        try {
                            ((File)object).delete();
                        }
                        catch (Exception exception) {}
                    }
                    object2 = Base64.encodeToString((byte[])object2, (int)0);
                    object = sBDImageDataResult;
                    Intrinsics.checkNotNull((Object)object2);
                    sBDImageDataResult = new SBDImageDataResult((String)object2);
                    object2 = SBGsonExtensionKt.toJSONObject(SBWrapper.gson, object);
                    SBResultDelegate.Companion.sendSuccessOnMainThread$document_sdk_wrapper_release(sBResultDelegate, (JSONObject)object2);
                    return;
                }
                if (!bl) throw throwable2;
                try {
                    ((File)object).delete();
                }
                catch (Exception exception) {}
                throw throwable2;
                throw throwable2;
            }
        };
        SBWrapper.runFunction$document_sdk_wrapper_release$default(SBWrapper.INSTANCE, sdkLicenseInfo, sBResultDelegate, false, false, (Function0)object, 12, null);
    }

    @JvmStatic
    public static final void rotateImage(final @NotNull String string, final double d2, final @NotNull SBResultDelegate sBResultDelegate) {
        Function0 function0;
        Intrinsics.checkNotNullParameter((Object)string, (String)"imageFileUri");
        Intrinsics.checkNotNullParameter((Object)sBResultDelegate, (String)"resultDelegate");
        Object object = SBDWrapper.INSTANCE.getLicenseInfoOrReject$document_sdk_wrapper_release(sBResultDelegate);
        if (object == null) {
            return;
        }
        SdkLicenseInfo sdkLicenseInfo = object;
        object = function0;
        function0 = new Function0(){

            public final void a() {
                Uri uri = SBStringExtensionKt.toValidUriOrNull(string);
                if (uri != null) {
                    Application application = SBWrapper.INSTANCE.getApplication$document_sdk_wrapper_release();
                    Intrinsics.checkNotNull((Object)application);
                    ContentResolver contentResolver = application.getContentResolver();
                    Intrinsics.checkNotNullExpressionValue((Object)contentResolver, (String)"getContentResolver(...)");
                    uri = SBDUriExtensionKt.toBitmapWithDecoding(uri, contentResolver);
                    if (uri != null) {
                        SBDRotatedImageResult sBDRotatedImageResult;
                        Matrix matrix;
                        Uri uri2 = uri;
                        uri = matrix;
                        uri();
                        matrix.postRotate(-((float)d2));
                        int n2 = uri2.getWidth();
                        int n3 = uri2.getHeight();
                        Bitmap bitmap = Bitmap.createBitmap((Bitmap)uri2, (int)0, (int)0, (int)n2, (int)n3, (Matrix)uri, (boolean)true);
                        Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"let(...)");
                        uri = SBDBitmapExtensionKt.storeAsFile(bitmap, SBStorageUtils.INSTANCE.getRotatedImagesDirectory());
                        SBDRotatedImageResult sBDRotatedImageResult2 = sBDRotatedImageResult;
                        String string2 = uri.toString();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
                        sBDRotatedImageResult = new SBDRotatedImageResult(string2);
                        uri = SBGsonExtensionKt.toJSONObject(SBWrapper.gson, sBDRotatedImageResult2);
                        uri2.recycle();
                        SBResultDelegate.Companion.sendSuccessOnMainThread$document_sdk_wrapper_release(sBResultDelegate, (JSONObject)uri);
                        return;
                    }
                }
                throw new SBExceptions.SBWrapperUriParsingError(null, 1, null);
            }
        };
        SBWrapper.runFunction$document_sdk_wrapper_release$default(SBWrapper.INSTANCE, sdkLicenseInfo, sBResultDelegate, false, false, (Function0)object, 12, null);
    }
}

