/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.blob;

import android.app.DownloadManager;
import android.content.SharedPreferences;
import android.content.res.AssetManager;
import android.database.Cursor;
import android.net.Uri;
import android.text.TextUtils;
import com.google.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import net.doo.snap.blob.BlobFactory;
import net.doo.snap.entity.Blob;
import net.doo.snap.entity.Language;
import net.doo.snap.persistence.BlobStoreStrategy;
import net.doo.snap.util.CursorUtil;
import net.doo.snap.util.log.DebugLog;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.jetbrains.annotations.NotNull;

public class BlobManager {
    private final BlobStoreStrategy blobStoreStrategy;
    private final DownloadManager downloadManager;
    private final SharedPreferences sharedPreferences;
    private final AssetManager assetManager;
    private final BlobFactory blobFactory;

    @Inject
    public BlobManager(BlobStoreStrategy blobStoreStrategy, DownloadManager downloadManager, SharedPreferences sharedPreferences, AssetManager assetManager, BlobFactory blobFactory) {
        this.blobStoreStrategy = blobStoreStrategy;
        this.downloadManager = downloadManager;
        this.sharedPreferences = sharedPreferences;
        this.assetManager = assetManager;
        this.blobFactory = blobFactory;
    }

    public boolean allBlobsAvailable(@NotNull Collection<Blob> blobs) {
        for (Blob blob : blobs) {
            if (this.isBlobAvailable(blob)) continue;
            return false;
        }
        return true;
    }

    public boolean isBlobAvailable(@NotNull Blob blob) {
        File file = new File(blob.getLocalPath());
        return file.exists();
    }

    @NotNull
    public Set<Language> getAllLanguagesWithAvailableOcrBlobs() throws IOException {
        EnumSet<Language> languageSet = EnumSet.noneOf(Language.class);
        File ocrDataDirectory = this.blobStoreStrategy.getOCRDataDirectory();
        File[] files = ocrDataDirectory.listFiles();
        if (files == null) {
            return languageSet;
        }
        for (File file : files) {
            String filename;
            String isoCode;
            Language language;
            if (file.isDirectory() || (language = Language.languageByIso((String)(isoCode = FilenameUtils.removeExtension((String)(filename = file.getName()))))) == null || !this.allBlobsAvailable(this.blobFactory.ocrLanguageBlobs(language))) continue;
            languageSet.add(language);
        }
        return languageSet;
    }

    public long fetch(@NotNull Blob blob, boolean allowMeteredNetwork) throws IOException {
        if (this.isBlobAvailable(blob)) {
            return -1L;
        }
        this.ensureDirectoryCreated(blob);
        Uri blobUri = Uri.parse((String)blob.getRemotePath());
        if (TextUtils.isEmpty((CharSequence)blobUri.getScheme())) {
            return this.copyFromAssets(blob, blobUri);
        }
        return this.download(blob, blobUri, allowMeteredNetwork);
    }

    private long copyFromAssets(Blob blob, Uri blobUri) throws IOException {
        FileUtils.copyInputStreamToFile((InputStream)this.assetManager.open(blobUri.getPath()), (File)new File(blob.getLocalPath()));
        return -1L;
    }

    private long download(Blob blob, Uri blobUri, boolean allowMeteredNetwork) throws IOException {
        int allowedNetworks = 2;
        if (allowMeteredNetwork) {
            allowedNetworks |= 1;
        }
        DownloadManager.Request request = new DownloadManager.Request(blobUri).setAllowedNetworkTypes(allowedNetworks).setDestinationUri(Uri.fromFile((File)new File(blob.getLocalPath())));
        long downloadId = this.downloadManager.enqueue(request);
        this.saveDownloadId(downloadId);
        return downloadId;
    }

    private void ensureDirectoryCreated(Blob blob) throws IOException {
        File dir = new File(blob.getLocalPath()).getParentFile();
        if (!dir.exists() && !dir.mkdirs()) {
            throw new IOException("Can't create destination directory");
        }
    }

    private void saveDownloadId(long downloadId) {
        HashSet<String> startedDownloads = new HashSet<String>(this.sharedPreferences.getStringSet("STARTED_BLOB_DOWNLOADS", Collections.EMPTY_SET));
        startedDownloads.add(String.valueOf(downloadId));
        this.sharedPreferences.edit().putStringSet("STARTED_BLOB_DOWNLOADS", startedDownloads).apply();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasActiveDownloads() {
        HashSet startedDownloads = new HashSet(this.sharedPreferences.getStringSet("STARTED_BLOB_DOWNLOADS", Collections.EMPTY_SET));
        if (startedDownloads.isEmpty()) {
            return false;
        }
        long[] ids = new long[startedDownloads.size()];
        int counter = 0;
        for (String stringId : startedDownloads) {
            ids[counter] = Long.parseLong(stringId);
            ++counter;
        }
        DownloadManager.Query query = new DownloadManager.Query();
        query.setFilterById(ids);
        query.setFilterByStatus(7);
        Cursor cursor = this.downloadManager.query(query);
        try {
            boolean bl = CursorUtil.hasElements((Cursor)cursor);
            return bl;
        }
        finally {
            CursorUtil.closeQuietly((Cursor)cursor);
        }
    }

    public HashSet<Blob> blobsToDownload(Collection<Language> languages) {
        HashSet<Blob> blobsToDownload = new HashSet<Blob>();
        try {
            blobsToDownload.addAll(this.blobFactory.languageDetectorBlobs());
            for (Language language : languages) {
                blobsToDownload.addAll(this.blobFactory.ocrLanguageBlobs(language));
                blobsToDownload.addAll(this.blobFactory.documentClassifierBlobs(language));
            }
        }
        catch (IOException e) {
            DebugLog.logException((Throwable)e);
        }
        return blobsToDownload;
    }
}

