/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.intelligence.source;

import android.content.Context;
import android.view.inputmethod.InputMethodInfo;
import android.view.inputmethod.InputMethodManager;
import android.view.inputmethod.InputMethodSubtype;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Set;
import net.doo.snap.entity.Language;
import net.doo.snap.intelligence.UserLanguageDetector;
import net.doo.snap.util.log.Logger;
import net.doo.snap.util.log.LoggerProvider;

public class KeyboardLanguageSource
implements UserLanguageDetector.LanguageSource {
    private static final String IME_SUBTYPE_MODE_KEYBOARD = "keyboard";
    private static final String CHINESE_SIMPLIFIED = "zh_cn";
    private static final String CHINISE_TRADITIONAL = "zh_tw";
    private final Context context;
    private final Logger logger = LoggerProvider.getLogger();

    public KeyboardLanguageSource(Context context) {
        this.context = context;
    }

    private Set<Language> getKeyboardLanguages() {
        HashSet<Language> languages = new HashSet<Language>();
        InputMethodManager imm = (InputMethodManager)this.context.getSystemService("input_method");
        List inputMethodInfoList = imm.getEnabledInputMethodList();
        for (InputMethodInfo inputMethodInfo : inputMethodInfoList) {
            for (InputMethodSubtype subtypeInfo : imm.getEnabledInputMethodSubtypeList(inputMethodInfo, true)) {
                if (!subtypeInfo.getMode().equals(IME_SUBTYPE_MODE_KEYBOARD)) continue;
                try {
                    String subtypeInfoLocale = subtypeInfo.getLocale();
                    Language language = Language.languageByIso((String)new Locale(subtypeInfoLocale).getISO3Language());
                    if (language != null) {
                        languages.add(language);
                    }
                    if (!subtypeInfoLocale.equalsIgnoreCase(CHINESE_SIMPLIFIED) && !subtypeInfoLocale.equalsIgnoreCase(CHINISE_TRADITIONAL)) continue;
                    languages.add(Language.CHS);
                    languages.add(Language.CHT);
                }
                catch (MissingResourceException e) {
                    this.logger.logException((Throwable)e);
                }
            }
        }
        return languages;
    }

    @Override
    public Collection<Language> getLanguages() {
        return this.getKeyboardLanguages();
    }
}

