/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.intelligence;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.text.TextUtils;
import com.google.inject.Inject;
import com.googlecode.leptonica.android.Pix;
import com.googlecode.leptonica.android.ReadFile;
import com.googlecode.tesseract.android.TessBaseAPI;
import com.googlecode.tesseract.android.TessPdfRenderer;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.doo.snap.entity.Document;
import net.doo.snap.entity.Language;
import net.doo.snap.entity.Page;
import net.doo.snap.persistence.BlobStoreStrategy;
import net.doo.snap.persistence.DocumentStoreStrategy;
import net.doo.snap.persistence.PageStoreStrategy;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;

public class OcrPdfRenderer {
    private static final String ROTATED_TEMP_FILE_SUFFIX = "_rotated";
    private final Context context;
    private final DocumentStoreStrategy documentStoreStrategy;
    private final PageStoreStrategy pageStoreStrategy;
    private final BlobStoreStrategy blobStoreStrategy;

    @Inject
    public OcrPdfRenderer(Context context, DocumentStoreStrategy documentStoreStrategy, PageStoreStrategy pageStoreStrategy, BlobStoreStrategy blobStoreStrategy) {
        this.context = context;
        this.documentStoreStrategy = documentStoreStrategy;
        this.pageStoreStrategy = pageStoreStrategy;
        this.blobStoreStrategy = blobStoreStrategy;
    }

    public RenderIterator startRender(@NotNull Document document, @NotNull Page[] pages, @NotNull Collection<Language> languages) throws IOException {
        return new RenderIteratorImpl(document, pages, languages);
    }

    private class RenderIteratorImpl
    implements RenderIterator {
        private final TessBaseAPI tessBaseAPI;
        private final TessPdfRenderer tessPdfRenderer;
        private final StringBuilder detectedText = new StringBuilder();
        private final Page[] pages;
        private final List<File> tempRotatedFiles = new ArrayList<File>();
        private int currentPosition = 0;

        private RenderIteratorImpl(Document document, Page[] pages, Collection<Language> languages) throws IOException {
            this.pages = pages;
            OcrPdfRenderer.this.documentStoreStrategy.getDocumentDir(document.getId()).mkdirs();
            File documentFile = OcrPdfRenderer.this.documentStoreStrategy.getDocumentFile(document.getId(), document.getName());
            this.tessBaseAPI = this.initTessApi(Language.languageCodes(languages));
            this.tessPdfRenderer = new TessPdfRenderer(this.tessBaseAPI, FilenameUtils.removeExtension((String)documentFile.getPath()));
        }

        private TessBaseAPI initTessApi(String ... languageCodes) throws IOException {
            TessBaseAPI tessBaseAPI = new TessBaseAPI();
            tessBaseAPI.init(OcrPdfRenderer.this.blobStoreStrategy.getOCRDataDirectory().getParent() + File.separator, TextUtils.join((CharSequence)"+", (Object[])languageCodes));
            tessBaseAPI.setPageSegMode(1);
            return tessBaseAPI;
        }

        @Override
        public boolean renderNextPage() throws IOException {
            if (this.currentPosition == 0) {
                this.tessBaseAPI.beginDocument(this.tessPdfRenderer);
            }
            if (this.currentPosition >= this.pages.length || this.pages[this.currentPosition] == null) {
                return false;
            }
            Page page = this.pages[this.currentPosition];
            this.appendPage(this.tessBaseAPI, this.tessPdfRenderer, page, this.detectedText);
            if (this.currentPosition == this.pages.length - 1) {
                this.tessBaseAPI.endDocument(this.tessPdfRenderer);
            }
            ++this.currentPosition;
            return true;
        }

        private void appendPage(@NotNull TessBaseAPI tessBaseAPI, @NotNull TessPdfRenderer tessPdfRenderer, @NotNull Page page, @NotNull StringBuilder detectedText) throws IOException {
            File imageFile = OcrPdfRenderer.this.pageStoreStrategy.getImageFile(page.getId(), Page.ImageType.OPTIMIZED);
            if (!imageFile.exists()) {
                return;
            }
            Bitmap bitmap = this.rotateBitmap(page, imageFile);
            File rotatedPageFile = this.writeRotatedBitmapTempFile(page, bitmap);
            Pix pix = ReadFile.readBitmap((Bitmap)bitmap);
            tessBaseAPI.addPageToDocument(pix, rotatedPageFile.getPath(), tessPdfRenderer);
            detectedText.append(tessBaseAPI.getUTF8Text());
            pix.recycle();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private File writeRotatedBitmapTempFile(Page page, Bitmap bitmap) throws IOException {
            File rotatedPageFile = File.createTempFile("scanbot_", page.getId() + OcrPdfRenderer.ROTATED_TEMP_FILE_SUFFIX, OcrPdfRenderer.this.context.getExternalCacheDir());
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(rotatedPageFile);
                bitmap.compress(Bitmap.CompressFormat.JPEG, 90, (OutputStream)fos);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fos);
                throw throwable;
            }
            IOUtils.closeQuietly((OutputStream)fos);
            this.tempRotatedFiles.add(rotatedPageFile);
            return rotatedPageFile;
        }

        private Bitmap rotateBitmap(Page page, File pageFile) {
            Bitmap bitmap = BitmapFactory.decodeFile((String)pageFile.getPath());
            Matrix matrix = new Matrix();
            matrix.setRotate((float)page.getRotationType().getDegrees());
            return Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)false);
        }

        @Override
        public String getDetectedText() {
            return this.detectedText.toString();
        }

        @Override
        public Page getLastProcessedPage() {
            return this.currentPosition < this.pages.length ? this.pages[this.currentPosition] : null;
        }

        @Override
        public int getLastProcessedPosition() {
            return this.currentPosition - 1;
        }

        @Override
        public void recycle() {
            for (File tempFile : this.tempRotatedFiles) {
                FileUtils.deleteQuietly((File)tempFile);
            }
            this.tempRotatedFiles.clear();
            this.tessBaseAPI.end();
            this.tessPdfRenderer.recycle();
        }
    }

    public static interface RenderIterator {
        public boolean renderNextPage() throws IOException;

        public String getDetectedText();

        public Page getLastProcessedPage();

        public int getLastProcessedPosition();

        public void recycle();
    }
}

