/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.process.compose;

import android.content.ContentResolver;
import android.content.Context;
import android.os.SystemClock;
import com.google.inject.Inject;
import io.scanbot.sap.SapManager;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.doo.snap.blob.BlobManager;
import net.doo.snap.entity.Document;
import net.doo.snap.entity.DocumentType;
import net.doo.snap.entity.Language;
import net.doo.snap.entity.OcrStatus;
import net.doo.snap.entity.Page;
import net.doo.snap.intelligence.DocumentClassifier;
import net.doo.snap.intelligence.DooTextBasedLanguageDetector;
import net.doo.snap.intelligence.OcrPdfRenderer;
import net.doo.snap.intelligence.UserLanguageProvider;
import net.doo.snap.persistence.DocumentStoreStrategy;
import net.doo.snap.process.PDFProcessor;
import net.doo.snap.process.compose.Composer;
import net.doo.snap.process.compose.SimpleComposer;
import net.doo.snap.util.log.Logger;
import net.doo.snap.util.log.LoggerProvider;
import org.apache.commons.io.FileUtils;

public class OcrComposer
implements Composer {
    private final Logger logger = LoggerProvider.getLogger();
    @Inject
    private Context context;
    @Inject
    private DocumentStoreStrategy documentStoreStrategy;
    @Inject
    private DooTextBasedLanguageDetector textLanguageDetector;
    @Inject
    private UserLanguageProvider userLanguageDetector;
    @Inject
    private BlobManager blobManager;
    @Inject
    private DocumentClassifier documentClassifier;
    @Inject
    private OcrPdfRenderer pdfRenderer;
    @Inject
    private PDFProcessor pdfProcessor;
    @Inject
    private ContentResolver contentResolver;
    @Inject
    private SimpleComposer simpleComposer;
    @Inject
    private SapManager sapManager;

    @Inject
    public OcrComposer() {
    }

    public OcrComposer(Context context, DocumentStoreStrategy documentStoreStrategy, DooTextBasedLanguageDetector textLanguageDetector, UserLanguageProvider userLanguageDetector, BlobManager blobManager, DocumentClassifier documentClassifier, OcrPdfRenderer pdfRenderer, PDFProcessor pdfProcessor, ContentResolver contentResolver, SimpleComposer simpleComposer) {
        this.context = context;
        this.documentStoreStrategy = documentStoreStrategy;
        this.textLanguageDetector = textLanguageDetector;
        this.userLanguageDetector = userLanguageDetector;
        this.blobManager = blobManager;
        this.documentClassifier = documentClassifier;
        this.pdfRenderer = pdfRenderer;
        this.pdfProcessor = pdfProcessor;
        this.contentResolver = contentResolver;
        this.simpleComposer = simpleComposer;
    }

    public void composeDocument(Document document, Page ... pages) throws IOException {
        if (!this.sapManager.isLicenseActive() || !this.sapManager.isFeatureEnabled(16)) {
            return;
        }
        try {
            long ocrStartedMillis = SystemClock.elapsedRealtime();
            this.ensureNoActiveDownloads();
            Set availableLanguages = this.blobManager.getAllLanguagesWithAvailableOcrBlobs();
            Language defaultLanguage = this.userLanguageDetector.getMostCommonLanguage();
            if (!availableLanguages.contains(defaultLanguage)) {
                this.logger.d("OCR", "Default language is not available - abort OCR: " + defaultLanguage);
                throw new IOException("Blob for default language is not available");
            }
            String detectedText = this.createPDF(document, pages, defaultLanguage, availableLanguages);
            this.saveMetaData(document, availableLanguages, defaultLanguage, detectedText);
            this.trackDuration(document, ocrStartedMillis);
        }
        catch (IOException e) {
            this.simpleComposer.composeDocument(document, pages);
        }
    }

    private void ensureNoActiveDownloads() throws IOException {
        if (this.blobManager.hasActiveDownloads()) {
            throw new IOException("Downloading in progress");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String createPDF(Document document, Page[] pages, final Language defaultLanguage, Set<Language> availableLanguages) throws IOException {
        ExecutorService initializer = Executors.newSingleThreadExecutor();
        initializer.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    OcrComposer.this.documentClassifier.initialize(defaultLanguage);
                }
                catch (IOException e) {
                    OcrComposer.this.logger.logException((Throwable)e);
                }
            }
        });
        try {
            String detectedText = this.performOCR(document, pages, availableLanguages, defaultLanguage);
            this.pdfProcessor.processPDF(document, pages);
            String string = detectedText;
            return string;
        }
        finally {
            initializer.shutdownNow();
        }
    }

    private String performOCR(Document document, Page[] pages, Set<Language> availableLanguages, Language defaultLanguage) throws IOException {
        String detectedText;
        this.logger.d("OCR", "Starting OCR with language: " + defaultLanguage);
        try {
            detectedText = this.ocrWithDefaultLanguage(document, pages, availableLanguages, defaultLanguage);
        }
        catch (WrongLanguageException e) {
            detectedText = this.cleanupAndRunWithNewLanguages(document, pages, e.getNewLanguages());
        }
        return detectedText;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String ocrWithDefaultLanguage(Document document, Page[] pages, Set<Language> availableLanguages, Language defaultLanguage) throws IOException, WrongLanguageException {
        String detectedText = null;
        OcrPdfRenderer.RenderIterator renderIterator = this.pdfRenderer.startRender(document, pages, Collections.singletonList(defaultLanguage));
        try {
            boolean languageDetected = false;
            while (renderIterator.renderNextPage()) {
                if (languageDetected) continue;
                try {
                    HashSet<Language> languages = new HashSet<Language>(this.textLanguageDetector.detectTextBasedLanguages(renderIterator.getDetectedText()));
                    this.logger.d("OCR", "Detected languages: " + Arrays.toString(languages.toArray()));
                    languages.retainAll(availableLanguages);
                    if (languages.isEmpty()) {
                        languages.addAll(availableLanguages);
                        this.logger.d("OCR", "None of them are available");
                    }
                    if (languages.size() == 1 && languages.contains(defaultLanguage)) {
                        languageDetected = true;
                        this.logger.d("OCR", "Continue with current language");
                        continue;
                    }
                    this.logger.d("OCR", "Languages are not match. Restart with languages: " + Arrays.toString(languages.toArray()));
                    throw new WrongLanguageException(languages);
                }
                catch (IOException e) {
                    this.logger.logException((Throwable)e);
                    languageDetected = true;
                }
            }
            detectedText = renderIterator.getDetectedText();
        }
        finally {
            renderIterator.recycle();
        }
        return detectedText;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String cleanupAndRunWithNewLanguages(Document document, Page[] pages, Collection<Language> languages) throws IOException {
        File documentFile = this.documentStoreStrategy.getDocumentFile(document.getId(), document.getName());
        FileUtils.deleteQuietly((File)documentFile);
        OcrPdfRenderer.RenderIterator renderIterator = this.pdfRenderer.startRender(document, pages, languages);
        try {
            while (renderIterator.renderNextPage()) {
            }
            String string = renderIterator.getDetectedText();
            return string;
        }
        finally {
            renderIterator.recycle();
        }
    }

    private void saveMetaData(Document document, Set<Language> availableLanguages, Language defaultLanguage, String detectedText) throws IOException {
        document.setOcrStatus(OcrStatus.DONE);
        document.setOcrText(detectedText);
        this.detectDocumentLanguage(document, detectedText, availableLanguages, defaultLanguage);
        this.detectDocumentType(document, detectedText);
        this.trackDocument(document);
    }

    private void detectDocumentLanguage(Document document, String detectedText, Set<Language> availableLanguages, Language defaultLanguage) throws IOException {
        ArrayList<Language> languages = new ArrayList<Language>(this.textLanguageDetector.detectTextBasedLanguages(detectedText));
        languages.retainAll(availableLanguages);
        languages.add(defaultLanguage);
        document.setLanguage((Language)languages.get(0));
    }

    private void detectDocumentType(Document document, String detectedText) {
        Language language = document.getLanguage();
        if (language == null) {
            return;
        }
        try {
            DocumentType documentType = this.documentClassifier.classifyDocument(language, detectedText);
            document.setDocumentType(documentType);
        }
        catch (IOException e) {
            this.logger.logException((Throwable)e);
        }
    }

    private void trackDuration(Document document, long ocrStartedMillis) {
        if (document.getLanguage() == null) {
            return;
        }
        long ocrDuration = SystemClock.elapsedRealtime() - ocrStartedMillis;
        this.logger.d("OCR", "Ocr total: " + (float)ocrDuration / 1000.0f + " sec");
    }

    private void trackDocument(Document document) {
        if (document.getLanguage() != null) {
            this.logger.d("OCR", "Document language assigned: " + document.getLanguage().getIsoCode());
        }
    }

    private static class WrongLanguageException
    extends Exception {
        private final Collection<Language> newLanguages;

        public WrongLanguageException(Collection<Language> newLanguages) {
            this.newLanguages = newLanguages;
        }

        public Collection<Language> getNewLanguages() {
            return this.newLanguages;
        }
    }
}

