/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.process.compose;

import android.content.Context;
import com.google.inject.Inject;
import net.doo.snap.entity.Document;
import net.doo.snap.entity.OcrStatus;
import net.doo.snap.process.compose.Composer;
import net.doo.snap.process.compose.ComposerFactory;
import net.doo.snap.process.compose.JpegComposer;
import net.doo.snap.process.compose.OcrComposer;
import net.doo.snap.process.compose.SimpleComposer;
import net.doo.snap.util.device.DeviceUtils;
import org.jetbrains.annotations.NotNull;
import roboguice.RoboGuice;

public class P2ComposerFactory
implements ComposerFactory {
    private final Context context;
    private final DeviceUtils deviceUtils;

    @Inject
    public P2ComposerFactory(Context context, DeviceUtils deviceUtils) {
        this.context = context;
        this.deviceUtils = deviceUtils;
    }

    @NotNull
    public Composer composerForDocument(Document document) {
        if (this.isJpeg(document)) {
            return this.buildJpegOrDummyComposer(document);
        }
        OcrStatus status = document.getOcrStatus();
        if (status == OcrStatus.PENDING_FORCED) {
            return this.buildOcrComposer();
        }
        if (status == OcrStatus.PENDING_ON_CHARGER && this.deviceUtils.isDeviceOnCharger()) {
            return this.buildOcrComposer();
        }
        if (status == OcrStatus.PENDING) {
            return this.buildOcrComposer();
        }
        return this.buildSimpleOrDummyComposer(document);
    }

    private boolean isJpeg(Document document) {
        String lowerCaseName = document.getName().toLowerCase();
        return lowerCaseName.endsWith(".jpg") || lowerCaseName.endsWith(".jpeg");
    }

    private OcrComposer buildOcrComposer() {
        OcrComposer composer = new OcrComposer();
        RoboGuice.getInjector((Context)this.context).injectMembersWithoutViews((Object)composer);
        return composer;
    }

    private Composer buildSimpleOrDummyComposer(Document document) {
        if (document.getSize() > 0L) {
            return new ComposerFactory.DummyComposer();
        }
        SimpleComposer composer = new SimpleComposer();
        RoboGuice.getInjector((Context)this.context).injectMembersWithoutViews((Object)composer);
        return composer;
    }

    private Composer buildJpegOrDummyComposer(Document document) {
        if (document.getSize() > 0L) {
            return new ComposerFactory.DummyComposer();
        }
        JpegComposer composer = new JpegComposer();
        RoboGuice.getInjector((Context)this.context).injectMembersWithoutViews((Object)composer);
        return composer;
    }
}

