/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.intelligence;

import android.content.ContentResolver;
import android.content.Context;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import java.util.MissingResourceException;
import net.doo.snap.entity.Language;
import net.doo.snap.intelligence.source.KeyboardLanguageSource;
import net.doo.snap.util.log.Logger;
import net.doo.snap.util.log.LoggerProvider;
import org.jetbrains.annotations.NotNull;

public class UserLanguageDetector {
    private static final String LANGUAGES_COUNT = "lang_count";
    private final Logger logger = LoggerProvider.getLogger();
    private final ArrayList<LanguageSource> sources = new ArrayList();
    private ContentResolver contentResolver;

    @Inject
    public UserLanguageDetector(Context context) {
        this.contentResolver = context.getContentResolver();
        this.sources.add(new KeyboardLanguageSource(context));
        this.sources.add(new DefaultLanguageSource());
    }

    public UserLanguageDetector(Context context, LanguageSource[] sources) {
        this.contentResolver = context.getContentResolver();
        this.sources.addAll(Arrays.asList(sources));
    }

    @NotNull
    public Collection<Language> detectUserLanguages() {
        HashSet<Language> languages = new HashSet<Language>();
        for (LanguageSource source : this.sources) {
            languages.addAll(source.getLanguages());
        }
        return languages;
    }

    @NotNull
    public Language detectMostCommonLanguage() {
        Language language = null;
        try {
            language = Language.languageByIso((String)Locale.getDefault().getISO3Language());
        }
        catch (MissingResourceException e) {
            this.logger.logException((Throwable)e);
        }
        return language != null ? language : Language.ENG;
    }

    private class DefaultLanguageSource
    implements LanguageSource {
        private DefaultLanguageSource() {
        }

        @Override
        public Collection<Language> getLanguages() {
            HashSet<Language> languages = new HashSet<Language>();
            languages.add(Language.ENG);
            languages.add(UserLanguageDetector.this.detectMostCommonLanguage());
            try {
                Language language = Language.languageByIso((String)Locale.getDefault().getISO3Language());
                if (language != null) {
                    languages.add(language);
                }
            }
            catch (MissingResourceException e) {
                UserLanguageDetector.this.logger.logException((Throwable)e);
            }
            return languages;
        }
    }

    public static interface LanguageSource {
        public Collection<Language> getLanguages();
    }
}

