/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.process.compose;

import android.content.Context;
import com.google.inject.Inject;
import io.scanbot.dynawrapper.DynaPDF;
import io.scanbot.dynawrapper.PDFException;
import java.io.File;
import java.io.IOException;
import net.doo.snap.entity.Document;
import net.doo.snap.entity.Page;
import net.doo.snap.persistence.BlobStoreStrategy;
import net.doo.snap.persistence.DocumentStoreStrategy;
import net.doo.snap.process.compose.Composer;
import net.doo.snap.process.compose.SimpleComposer;
import org.apache.commons.io.FileUtils;

public class ExtractPDFTextComposer
implements Composer {
    private static final String OLD_OCRED_TEMP_DOCUMENT_SUFFIX = "_ocr_old";
    private static final String NEW_OCRED_TEMP_DOCUMENT_SUFFIX = "_ocr_new";
    @Inject
    private Context context;
    @Inject
    private DocumentStoreStrategy documentStoreStrategy;
    @Inject
    private BlobStoreStrategy blobStoreStrategy;
    @Inject
    private SimpleComposer simpleComposer;

    @Inject
    public ExtractPDFTextComposer() {
    }

    public ExtractPDFTextComposer(Context context, DocumentStoreStrategy documentStoreStrategy, BlobStoreStrategy blobStoreStrategy, SimpleComposer simpleComposer) {
        this.context = context;
        this.documentStoreStrategy = documentStoreStrategy;
        this.blobStoreStrategy = blobStoreStrategy;
        this.simpleComposer = simpleComposer;
    }

    public void composeDocument(Document document, Page ... pages) throws IOException {
        this.extractTextFromExistingDocument(document, pages);
    }

    private void extractTextFromExistingDocument(Document document, Page[] pages) throws IOException {
        File tempOldFile = this.moveDocumentToTempFile(document, OLD_OCRED_TEMP_DOCUMENT_SUFFIX);
        this.simpleComposer.composeDocument(document, pages);
        File newFile = this.documentStoreStrategy.getDocumentFile(document.getId(), document.getName());
        File tempNewFile = this.moveDocumentToTempFile(document, NEW_OCRED_TEMP_DOCUMENT_SUFFIX);
        DynaPDF sourcePDF = null;
        DynaPDF destinationPDF = null;
        try {
            sourcePDF = this.prepareSourcePDF(tempOldFile);
            destinationPDF = this.prepareDestinationPDF(newFile, tempNewFile);
            DynaPDF.copyText((DynaPDF)sourcePDF, (DynaPDF)destinationPDF, (String)this.blobStoreStrategy.getOCRDataDirectory().getPath(), (String)"Roboto");
            sourcePDF.closeFile();
            destinationPDF.closeFile();
        }
        catch (PDFException e) {
            throw new IOException(e);
        }
        finally {
            if (sourcePDF != null) {
                sourcePDF.onDestroy();
            }
            if (destinationPDF != null) {
                destinationPDF.onDestroy();
            }
            FileUtils.deleteQuietly((File)tempNewFile);
            FileUtils.deleteQuietly((File)tempOldFile);
        }
    }

    private File moveDocumentToTempFile(Document document, String tempFileSuffix) throws IOException {
        File file = this.documentStoreStrategy.getDocumentFile(document.getId(), document.getName());
        File tempFile = File.createTempFile("scanbot_", document.getId() + tempFileSuffix, this.context.getExternalCacheDir());
        FileUtils.deleteQuietly((File)tempFile);
        FileUtils.moveFile((File)file, (File)tempFile);
        return tempFile;
    }

    private DynaPDF prepareDestinationPDF(File newFile, File tempNewFile) throws PDFException {
        DynaPDF destinationPDF = new DynaPDF();
        destinationPDF.openFile(tempNewFile.getPath(), 0, "");
        destinationPDF.importPDF(1, 1.0, 1.0);
        destinationPDF.closeImportedFile();
        destinationPDF.openOutputFile(newFile.getPath());
        return destinationPDF;
    }

    private DynaPDF prepareSourcePDF(File tempOldFile) throws PDFException {
        DynaPDF sourcePDF = new DynaPDF();
        sourcePDF.openFile(tempOldFile.getPath(), 0, "");
        sourcePDF.importPDF(1, 1.0, 1.0);
        sourcePDF.closeImportedFile();
        return sourcePDF;
    }
}

