/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.ui.upload;

import android.app.LoaderManager;
import android.content.Context;
import android.net.Uri;
import android.os.AsyncTask;
import com.evernote.client.android.EvernoteSession;
import com.evernote.edam.error.EDAMNotFoundException;
import com.evernote.edam.error.EDAMSystemException;
import com.evernote.edam.error.EDAMUserException;
import com.evernote.edam.type.LinkedNotebook;
import com.evernote.edam.type.Notebook;
import com.evernote.thrift.TException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.doo.snap.UploadConstants;
import net.doo.snap.packageFull.R;
import net.doo.snap.ui.themes.ThemesProvider;
import net.doo.snap.ui.upload.ChooserActivity;
import net.doo.snap.ui.upload.CreateEvernoteNotebookFragment;
import net.doo.snap.ui.upload.event.EvernoteNotebookNameChosenEvent;
import net.doo.snap.upload.CloudStorage;
import net.doo.snap.util.ManifestConstantsProvider;
import net.doo.snap.util.log.DebugLog;
import net.doo.snap.util.thread.ExecutionUtils;
import roboguice.event.Observes;

public class EvernoteChooserActivity
extends ChooserActivity
implements LoaderManager.LoaderCallbacks<List<Uri>> {
    private static final String CHOOSE_NOTEBOOK_NAME_FRAGMENT_TAG = "CHOOSE_NOTEBOOK_NAME_FRAGMENT_TAG";
    private EvernoteSession evernoteSession;
    private boolean isBusinessUser = false;

    @Override
    protected void init() {
        this.chooserStorage = CloudStorage.EVERNOTE;
        this.initEvernoteSession();
    }

    @Override
    protected ThemesProvider initThemesProvider(String themeType) {
        return super.initThemesProvider("evernote_chooser_theme");
    }

    private void initEvernoteSession() {
        if (this.evernoteSession == null) {
            this.evernoteSession = EvernoteSession.getInstance((Context)this, (String)ManifestConstantsProvider.getConstantValue((Context)this, (String)"evernote_consumer_key"), (String)ManifestConstantsProvider.getConstantValue((Context)this, (String)"evernote_consumer_secret"), (EvernoteSession.EvernoteService)UploadConstants.EVERNOTE_HOST, (boolean)true);
            try {
                this.isBusinessUser = this.evernoteSession.getClientFactory().createUserStoreClient().isBusinessUser();
            }
            catch (EDAMSystemException | EDAMUserException | TException | IllegalStateException e) {
                DebugLog.logException((Throwable)e);
                this.finish();
            }
        }
    }

    @Override
    protected void createFolder(String name) {
        Notebook scanbotNotebook = new Notebook();
        scanbotNotebook.setName(name);
        try {
            this.evernoteSession.getClientFactory().createNoteStoreClient().getClient().createNotebook(this.evernoteSession.getAuthToken(), scanbotNotebook);
        }
        catch (EDAMSystemException | EDAMUserException | TException e) {
            DebugLog.logException((Throwable)e);
            ExecutionUtils.showToast((Context)this, (int)R.string.unable_create_folder_error);
        }
    }

    private void createBusinessFolder(String name) {
        Notebook scanbotNotebook = new Notebook();
        scanbotNotebook.setName(name);
        try {
            this.evernoteSession.getClientFactory().createBusinessNoteStoreClient().createNotebook(scanbotNotebook);
        }
        catch (EDAMNotFoundException | EDAMSystemException | EDAMUserException | TException e) {
            DebugLog.logException((Throwable)e);
            ExecutionUtils.showToast((Context)this, (int)R.string.unable_create_folder_error);
        }
    }

    @Override
    protected List<Uri> loadFolders() {
        ArrayList<Uri> notebooksUris = new ArrayList<Uri>();
        try {
            List notebooks = this.evernoteSession.getClientFactory().createNoteStoreClient().getClient().listNotebooks(this.evernoteSession.getAuthToken());
            for (Notebook item : notebooks) {
                Uri uri = new Uri.Builder().appendQueryParameter("folder_name", item.getName()).appendQueryParameter("id", item.getName()).build();
                notebooksUris.add(uri);
            }
            if (this.evernoteSession.getClientFactory().createUserStoreClient().isBusinessUser()) {
                List businessNotebooks = this.evernoteSession.getClientFactory().createBusinessNoteStoreClient().listNotebooks();
                for (LinkedNotebook item : businessNotebooks) {
                    Uri uri = new Uri.Builder().appendQueryParameter("folder_name", item.getShareName()).appendQueryParameter("id", item.getShareName()).appendQueryParameter("business", item.isSetBusinessId() ? "true" : "false").build();
                    notebooksUris.add(uri);
                }
            }
        }
        catch (EDAMNotFoundException | EDAMSystemException | EDAMUserException | TException e) {
            DebugLog.logException((Throwable)e);
            ExecutionUtils.showToast((Context)this, (int)R.string.unable_open_folder_error);
        }
        Collections.sort(notebooksUris, new Comparator<Uri>(){

            @Override
            public int compare(Uri lhs, Uri rhs) {
                return lhs.getQueryParameter("folder_name").compareToIgnoreCase(rhs.getQueryParameter("folder_name"));
            }
        });
        return notebooksUris;
    }

    public void onNotebookNameChosen(@Observes EvernoteNotebookNameChosenEvent event) {
        this.showProgress(true);
        this.startCreateFolderTask(event.getNewName(), event.isBusiness());
    }

    private void startCreateFolderTask(final String folderName, final boolean isBusiness) {
        new AsyncTask<Void, Void, Void>(){

            protected Void doInBackground(Void ... params) {
                if (isBusiness) {
                    EvernoteChooserActivity.this.createBusinessFolder(folderName);
                } else {
                    EvernoteChooserActivity.this.createFolder(folderName);
                }
                return null;
            }

            protected void onPostExecute(Void aVoid) {
                super.onPostExecute((Object)aVoid);
                if (!EvernoteChooserActivity.this.isActive) {
                    return;
                }
                EvernoteChooserActivity.this.reloadFoldersList();
            }
        }.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, (Object[])new Void[0]);
    }

    @Override
    protected void openNewFolderNameDialog() {
        if (!this.isBusinessUser) {
            super.openNewFolderNameDialog();
            return;
        }
        CreateEvernoteNotebookFragment newNameFragment = CreateEvernoteNotebookFragment.newInstance();
        newNameFragment.show(this.getSupportFragmentManager(), CHOOSE_NOTEBOOK_NAME_FRAGMENT_TAG);
    }
}

