/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.ui.upload;

import android.app.LoaderManager;
import android.content.Context;
import android.net.Uri;
import com.microsoft.live.LiveAuthClient;
import com.microsoft.live.LiveAuthException;
import com.microsoft.live.LiveAuthListener;
import com.microsoft.live.LiveConnectClient;
import com.microsoft.live.LiveConnectSession;
import com.microsoft.live.LiveOperation;
import com.microsoft.live.LiveOperationException;
import com.microsoft.live.LiveStatus;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import net.doo.snap.packageFull.R;
import net.doo.snap.ui.upload.ChooserActivity;
import net.doo.snap.upload.CloudStorage;
import net.doo.snap.util.ManifestConstantsProvider;
import net.doo.snap.util.log.DebugLog;
import net.doo.snap.util.thread.ExecutionUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class OneDriveChooserActivity
extends ChooserActivity
implements LoaderManager.LoaderCallbacks<List<Uri>> {
    private static final String ROOT_PATH = "me/skydrive";
    private static final String FOLDERS_FILTER = "/files?filter=folders";
    private static final String FILE_ID_KEY = "id";
    private static final String DATA_KEY = "data";
    private static final String NAME_KEY = "name";
    private static final String DESCRIPTION_KEY = "description";
    private static final String FOLDER_DESCRIPTION = "Scanbot folder";
    private CountDownLatch countDownLatch;
    private LiveAuthClient auth;
    private LiveConnectClient client;
    private LiveConnectSession session;

    @Override
    protected void init() {
        this.countDownLatch = new CountDownLatch(1);
        this.chooserStorage = CloudStorage.ONE_DRIVE;
        this.foldersHierarchy.add(new Uri.Builder().appendQueryParameter("folder_name", ROOT_PATH).appendQueryParameter(FILE_ID_KEY, ROOT_PATH).build());
        this.initOneDriveAPI();
        try {
            this.countDownLatch.await();
        }
        catch (InterruptedException e) {
            DebugLog.logException((Throwable)e);
        }
        if (this.session != null && !this.session.isExpired()) {
            this.client = new LiveConnectClient(this.session);
        }
    }

    private void initOneDriveAPI() {
        this.auth = new LiveAuthClient((Context)this, ManifestConstantsProvider.getConstantValue((Context)this, (String)"onedrive_client_id"));
        this.auth.initialize(new LiveAuthListener(){

            public void onAuthComplete(LiveStatus status, LiveConnectSession session, Object userState) {
                OneDriveChooserActivity.this.session = session;
                OneDriveChooserActivity.this.countDownLatch.countDown();
            }

            public void onAuthError(LiveAuthException exception, Object userState) {
                OneDriveChooserActivity.this.countDownLatch.countDown();
            }
        });
    }

    @Override
    protected void createFolder(String name) {
        if (this.client == null) {
            ExecutionUtils.showToast((Context)this, (int)R.string.unable_create_folder_error);
            return;
        }
        try {
            JSONObject body = new JSONObject();
            body.put(NAME_KEY, (Object)name);
            body.put(DESCRIPTION_KEY, (Object)FOLDER_DESCRIPTION);
            LiveOperation operation = this.client.post(((Uri)this.foldersHierarchy.getLast()).getQueryParameter(FILE_ID_KEY), body);
            if (operation.getResult().has(FILE_ID_KEY)) {
                DebugLog.i((String)"OneDrive folder is created!");
            } else {
                ExecutionUtils.showToast((Context)this, (int)R.string.unable_create_folder_error);
            }
        }
        catch (JSONException ex) {
            DebugLog.logException((Throwable)ex);
            ExecutionUtils.showToast((Context)this, (int)R.string.unable_create_folder_error);
        }
        catch (LiveOperationException e) {
            DebugLog.logException((Throwable)e);
            ExecutionUtils.showToast((Context)this, (int)R.string.unable_create_folder_error);
        }
    }

    @Override
    protected List<Uri> loadFolders() {
        ArrayList<Uri> foldersUris = new ArrayList<Uri>();
        if (this.client == null) {
            ExecutionUtils.showToast((Context)this, (int)R.string.unable_open_folder_error);
            return foldersUris;
        }
        try {
            LiveOperation operation = this.client.get(((Uri)this.foldersHierarchy.getLast()).getQueryParameter(FILE_ID_KEY) + FOLDERS_FILTER);
            if (operation.getResult().has(DATA_KEY)) {
                JSONArray folders = operation.getResult().getJSONArray(DATA_KEY);
                for (int index = 0; index < folders.length(); ++index) {
                    Uri uri = new Uri.Builder().appendQueryParameter("folder_name", folders.getJSONObject(index).getString(NAME_KEY)).appendQueryParameter(FILE_ID_KEY, folders.getJSONObject(index).getString(FILE_ID_KEY)).build();
                    foldersUris.add(uri);
                }
            }
        }
        catch (LiveOperationException e) {
            DebugLog.logException((Throwable)e);
            ExecutionUtils.showToast((Context)this, (int)R.string.unable_open_folder_error);
        }
        catch (JSONException e) {
            DebugLog.logException((Throwable)e);
            ExecutionUtils.showToast((Context)this, (int)R.string.unable_open_folder_error);
        }
        return foldersUris;
    }
}

