/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.ui.upload;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.os.Parcelable;
import com.google.inject.Inject;
import io.scanbot.shoeboxed.ApiApplication;
import io.scanbot.shoeboxed.AuthHandler;
import io.scanbot.shoeboxed.ShoeboxedAuthHelper;
import io.scanbot.shoeboxed.entity.Account;
import net.doo.snap.packageFull.R;
import net.doo.snap.ui.CustomThemeActivity;
import net.doo.snap.ui.upload.ShoeboxedAccountChooserActivity;
import net.doo.snap.upload.CloudStorage;
import net.doo.snap.upload.auth.ConnectionResult;
import net.doo.snap.util.ManifestConstantsProvider;
import net.doo.snap.util.NavigationUtils;

public class ShoeboxedActivity
extends CustomThemeActivity {
    private static final int AUTH_REQUEST_CODE = 100;
    private static final int ACCOUNT_REQUEST_CODE = 200;
    @Inject
    private SharedPreferences preferences;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_connect_storage);
        ApiApplication apiApplication = new ApiApplication(ManifestConstantsProvider.getConstantValue((Context)this, (String)"shoeboxed_api_client_id"), ManifestConstantsProvider.getConstantValue((Context)this, (String)"shoeboxed_api_secret"), ManifestConstantsProvider.getConstantValue((Context)this, (String)"shoeboxed_api_redirect_url"));
        new ShoeboxedAuthHelper().launchAuthorization(apiApplication, (Activity)this, 100);
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        switch (requestCode) {
            case 100: {
                this.handleAuthResult(resultCode, data);
                break;
            }
            case 200: {
                this.handleAccountResult(resultCode, data);
            }
        }
    }

    private void handleAuthResult(int resultCode, Intent data) {
        AuthHandler.Tokens tokens = new ShoeboxedAuthHelper().handleAuthorizationResult(resultCode, data);
        if (tokens == null) {
            this.deliverConnectionResult(new ConnectionResult(false, CloudStorage.SHOEBOXED, null));
            return;
        }
        this.preferences.edit().putString("SHOEBOXED_ACCESS_TOKEN", tokens.getAccessToken()).putString("SHOEBOXED_REFRESH_TOKEN", tokens.getRefreshToken()).apply();
        this.startActivityForResult(new Intent((Context)this, ShoeboxedAccountChooserActivity.class), 200);
    }

    private void handleAccountResult(int resultCode, Intent data) {
        if (resultCode != -1 || data == null) {
            this.deliverConnectionResult(new ConnectionResult(false, CloudStorage.SHOEBOXED, null));
            return;
        }
        Account account = (Account)data.getSerializableExtra("RESULT_ACCOUNT");
        this.preferences.edit().putLong("SHOEBOXED_ACCOUNT_ID", account.getId()).putString(CloudStorage.SHOEBOXED.getAccountNameKey(), account.getLabel()).apply();
        this.deliverConnectionResult(new ConnectionResult(true, CloudStorage.SHOEBOXED, account.getLabel()));
    }

    private void deliverConnectionResult(ConnectionResult result) {
        Intent intent = new Intent();
        intent.putExtra("CONNECTION_EXTRA", (Parcelable)result);
        NavigationUtils.deliverResultAndFinish((Activity)this, (int)-1, (Intent)intent);
    }
}

