/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.ui.upload;

import android.app.LoaderManager;
import android.content.Context;
import android.content.SharedPreferences;
import android.net.Uri;
import com.google.inject.Inject;
import com.yandex.disk.client.Credentials;
import com.yandex.disk.client.ListItem;
import com.yandex.disk.client.ListParsingHandler;
import com.yandex.disk.client.TransportClient;
import com.yandex.disk.client.exceptions.WebdavClientInitException;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.doo.snap.packageFull.R;
import net.doo.snap.ui.upload.ChooserActivity;
import net.doo.snap.upload.CloudStorage;
import net.doo.snap.util.log.DebugLog;
import net.doo.snap.util.thread.ExecutionUtils;

public class YandexChooserActivity
extends ChooserActivity
implements LoaderManager.LoaderCallbacks<List<Uri>> {
    private static final String ROOT_PATH = File.separator;
    @Inject
    private SharedPreferences preferences;
    private TransportClient transportClient;

    @Override
    protected void init() {
        this.chooserStorage = CloudStorage.YANDEX_DISK;
        this.foldersHierarchy.add(new Uri.Builder().appendQueryParameter("folder_name", ROOT_PATH).appendQueryParameter("id", "").build());
        this.initYandexClient();
    }

    private void initYandexClient() {
        try {
            this.transportClient = TransportClient.getInstance((Context)this, (Credentials)new Credentials(null, this.preferences.getString("YANDEX_TOKEN_KEY", "")));
        }
        catch (WebdavClientInitException e) {
            DebugLog.logException((Throwable)e);
            ExecutionUtils.showToast((Context)this, (int)R.string.unable_open_folder_error);
            this.finish();
        }
    }

    @Override
    protected void createFolder(String name) {
        try {
            this.transportClient.makeFolder(((Uri)this.foldersHierarchy.getLast()).getQueryParameter("id") + File.separator + name);
        }
        catch (Exception e) {
            DebugLog.logException((Throwable)e);
            ExecutionUtils.showToast((Context)this, (int)R.string.unable_create_folder_error);
        }
    }

    @Override
    protected List<Uri> loadFolders() {
        final ArrayList<Uri> foldersUris = new ArrayList<Uri>();
        try {
            this.transportClient.getList(((Uri)this.foldersHierarchy.getLast()).getQueryParameter("id"), new ListParsingHandler(){

                public boolean handleItem(ListItem listItem) {
                    if (!listItem.isCollection() || ((Uri)YandexChooserActivity.this.foldersHierarchy.getLast()).getQueryParameter("id").equals(listItem.getFullPath())) {
                        return false;
                    }
                    Uri uri = new Uri.Builder().appendQueryParameter("folder_name", listItem.getName()).appendQueryParameter("id", listItem.getFullPath()).build();
                    foldersUris.add(uri);
                    return false;
                }
            });
        }
        catch (Exception e) {
            DebugLog.logException((Throwable)e);
            ExecutionUtils.showToast((Context)this, (int)R.string.unable_open_folder_error);
        }
        return foldersUris;
    }
}

