/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.upload.cloud.amazon;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;
import com.google.inject.Inject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import net.doo.snap.upload.cloud.amazon.AmazonCloudDriveAccountRestApi;
import net.doo.snap.upload.cloud.amazon.AmazonCloudDriveAuthRestApi;
import net.doo.snap.upload.cloud.amazon.AmazonCloudDriveNodeContentRestApi;
import net.doo.snap.upload.cloud.amazon.AmazonCloudDriveNodeMetaDataRestApi;
import net.doo.snap.upload.cloud.amazon.ForbiddenException;
import net.doo.snap.upload.cloud.amazon.model.AmazonFile;
import net.doo.snap.upload.cloud.amazon.model.AmazonFolder;
import net.doo.snap.upload.cloud.amazon.model.EndPointResponse;
import net.doo.snap.upload.cloud.amazon.model.FoldersResponse;
import net.doo.snap.upload.cloud.amazon.model.ProfileResponse;
import net.doo.snap.upload.cloud.amazon.model.TokenResponse;
import net.doo.snap.util.ManifestConstantsProvider;
import net.doo.snap.util.log.DebugLog;
import retrofit.ErrorHandler;
import retrofit.RequestInterceptor;
import retrofit.RestAdapter;
import retrofit.RetrofitError;
import retrofit.client.ApacheClient;
import retrofit.client.Client;
import retrofit.client.Header;
import retrofit.client.Request;
import retrofit.client.Response;
import retrofit.mime.TypedFile;

public class AmazonCloudDriveApi {
    private static final int NOT_AUTHORIZED_ERROR_CODE = 403;
    private static final int REFRESH_TOKEN_ERROR_CODE = 401;
    private static final long ENDPOINT_EXPIRATION_PERIOD_MS = 432000000L;
    private static final String HEADER_AUTHORIZATION_KEY = "Authorization";
    private static final String HEADER_AUTHORIZATION_VALUE = "Bearer %s";
    private static final String GRANT_TYPE_KEY = "grant_type";
    private static final String CODE_KEY = "code";
    private static final String CLIENT_ID_KEY = "client_id";
    private static final String CLIENT_SECRET_KEY = "client_secret";
    private static final String REDIRECT_URI_KEY = "redirect_uri";
    private static final String GRANT_TYPE_AUTHORIZATION_CODE = "authorization_code";
    private static final String GRANT_TYPE_REFRESH_TOKEN = "refresh_token";
    private static final String REFRESH_TOKEN_KEY = "refresh_token";
    private static String accessToken;
    private AmazonCloudDriveAuthRestApi amazonCloudDriveAuthRestApi;
    private AmazonCloudDriveNodeContentRestApi amazonCloudDriveNodeContentRestApi;
    private AmazonCloudDriveNodeMetaDataRestApi amazonCloudDriveNodeMetaDataRestApi;
    private AmazonCloudDriveAccountRestApi amazonCloudDriveAccountRestApi;
    private SharedPreferences preferences;
    private final Context context;
    private String contentUrl;
    private String metadataUrl;
    private long endPointExpiresAt;
    private RequestInterceptor requestInterceptor = new RequestInterceptor(){

        public void intercept(RequestInterceptor.RequestFacade requestFacade) {
            requestFacade.addHeader(AmazonCloudDriveApi.HEADER_AUTHORIZATION_KEY, String.format(AmazonCloudDriveApi.HEADER_AUTHORIZATION_VALUE, accessToken));
        }
    };
    private ErrorHandler errorHandler = new ErrorHandler(){

        public Throwable handleError(RetrofitError retrofitError) {
            DebugLog.logException((Throwable)retrofitError);
            if (retrofitError.getResponse() != null && retrofitError.getResponse().getStatus() == 403) {
                return new ForbiddenException((Throwable)retrofitError);
            }
            return new IOException((Throwable)retrofitError);
        }
    };
    private Client challengeResponseClient = new Client(){
        Client delegate = new ApacheClient();

        public Response execute(Request request) throws IOException {
            Response response = this.delegate.execute(request);
            if (response.getStatus() == 401) {
                AmazonCloudDriveApi.this.refreshToken();
                ArrayList<Header> newHeaders = new ArrayList<Header>();
                for (Header header : request.getHeaders()) {
                    if (header.getName().equalsIgnoreCase(AmazonCloudDriveApi.HEADER_AUTHORIZATION_KEY)) {
                        Header authHeader = new Header(AmazonCloudDriveApi.HEADER_AUTHORIZATION_KEY, String.format(AmazonCloudDriveApi.HEADER_AUTHORIZATION_VALUE, accessToken));
                        newHeaders.add(authHeader);
                        continue;
                    }
                    newHeaders.add(header);
                }
                Request newRequest = new Request(request.getMethod(), request.getUrl(), newHeaders, request.getBody());
                response = this.delegate.execute(newRequest);
            }
            return response;
        }
    };

    @Inject
    public AmazonCloudDriveApi(SharedPreferences preferences, Context context) {
        this.preferences = preferences;
        this.context = context;
        accessToken = preferences.getString("AMAZON_CLOUD_DRIVE_ACCESS_TOKEN", null);
    }

    private void ensureAuthApi() {
        if (this.amazonCloudDriveAuthRestApi == null) {
            RestAdapter authRestAdapter = new RestAdapter.Builder().setEndpoint("https://api.amazon.com").setErrorHandler(this.errorHandler).setClient((Client)new ApacheClient()).build();
            this.amazonCloudDriveAuthRestApi = (AmazonCloudDriveAuthRestApi)authRestAdapter.create(AmazonCloudDriveAuthRestApi.class);
        }
    }

    private void ensureAccountApi() {
        if (this.amazonCloudDriveAccountRestApi == null) {
            RestAdapter authRestAdapter = new RestAdapter.Builder().setEndpoint("https://drive.amazonaws.com").setErrorHandler(this.errorHandler).setRequestInterceptor(this.requestInterceptor).setClient(this.challengeResponseClient).build();
            this.amazonCloudDriveAccountRestApi = (AmazonCloudDriveAccountRestApi)authRestAdapter.create(AmazonCloudDriveAccountRestApi.class);
        }
    }

    private void ensureEndPoints() throws ForbiddenException, IOException {
        if (TextUtils.isEmpty((CharSequence)this.contentUrl) || TextUtils.isEmpty((CharSequence)this.metadataUrl) || this.endPointExpiresAt == 0L) {
            this.contentUrl = this.preferences.getString("AMAZON_CLOUD_DRIVE_CONTENT_URL", null);
            this.metadataUrl = this.preferences.getString("AMAZON_CLOUD_DRIVE_METADATA_URL", null);
            this.endPointExpiresAt = this.preferences.getLong("AMAZON_CLOUD_DRIVE_ENDPOINT_EXPIRES", 0L);
        }
        long currentTime = new Date().getTime();
        if (TextUtils.isEmpty((CharSequence)this.contentUrl) || TextUtils.isEmpty((CharSequence)this.metadataUrl) || currentTime > this.endPointExpiresAt) {
            EndPointResponse endPoint = this.getEndPoints();
            if (endPoint != null) {
                this.contentUrl = endPoint.getContentUrl();
                this.metadataUrl = endPoint.getMetadataUrl();
                this.endPointExpiresAt = currentTime + 432000000L;
                this.preferences.edit().putString("AMAZON_CLOUD_DRIVE_CONTENT_URL", this.contentUrl).putString("AMAZON_CLOUD_DRIVE_METADATA_URL", this.metadataUrl).putLong("AMAZON_CLOUD_DRIVE_ENDPOINT_EXPIRES", this.endPointExpiresAt).apply();
            } else {
                throw new IOException("Can't get endpoints");
            }
        }
    }

    private void ensureNodeContentApi() throws ForbiddenException, IOException {
        if (this.amazonCloudDriveNodeContentRestApi == null) {
            this.ensureEndPoints();
            RestAdapter authRestAdapter = new RestAdapter.Builder().setEndpoint(this.contentUrl).setErrorHandler(this.errorHandler).setRequestInterceptor(this.requestInterceptor).setClient(this.challengeResponseClient).build();
            this.amazonCloudDriveNodeContentRestApi = (AmazonCloudDriveNodeContentRestApi)authRestAdapter.create(AmazonCloudDriveNodeContentRestApi.class);
        }
    }

    private void ensureNodeMetaDataApi() throws ForbiddenException, IOException {
        if (this.amazonCloudDriveNodeMetaDataRestApi == null) {
            this.ensureEndPoints();
            RestAdapter authRestAdapter = new RestAdapter.Builder().setEndpoint(this.metadataUrl).setErrorHandler(this.errorHandler).setRequestInterceptor(this.requestInterceptor).setClient(this.challengeResponseClient).build();
            this.amazonCloudDriveNodeMetaDataRestApi = (AmazonCloudDriveNodeMetaDataRestApi)authRestAdapter.create(AmazonCloudDriveNodeMetaDataRestApi.class);
        }
    }

    TokenResponse getTokensByCode(String code) throws IOException {
        this.ensureAuthApi();
        HashMap<String, String> fields = new HashMap<String, String>();
        fields.put(GRANT_TYPE_KEY, GRANT_TYPE_AUTHORIZATION_CODE);
        fields.put(CODE_KEY, code);
        fields.put(CLIENT_ID_KEY, ManifestConstantsProvider.getConstantValue((Context)this.context, (String)"amazon_client_id"));
        fields.put(CLIENT_SECRET_KEY, ManifestConstantsProvider.getConstantValue((Context)this.context, (String)"amazon_client_secret"));
        fields.put(REDIRECT_URI_KEY, ManifestConstantsProvider.getConstantValue((Context)this.context, (String)"amazon_redirect_url"));
        return this.amazonCloudDriveAuthRestApi.getTokens(fields);
    }

    private TokenResponse getTokensByRefreshToken(String refreshToken) throws IOException {
        this.ensureAuthApi();
        HashMap<String, String> fields = new HashMap<String, String>();
        fields.put(GRANT_TYPE_KEY, "refresh_token");
        fields.put("refresh_token", refreshToken);
        fields.put(CLIENT_ID_KEY, ManifestConstantsProvider.getConstantValue((Context)this.context, (String)"amazon_client_id"));
        fields.put(CLIENT_SECRET_KEY, ManifestConstantsProvider.getConstantValue((Context)this.context, (String)"amazon_client_secret"));
        return this.amazonCloudDriveAuthRestApi.getTokens(fields);
    }

    private boolean refreshToken() throws IOException {
        String refreshToken = this.preferences.getString("AMAZON_CLOUD_DRIVE_REFRESH_TOKEN", null);
        TokenResponse tokens = this.getTokensByRefreshToken(refreshToken);
        if (tokens != null) {
            this.saveTokens(tokens);
            return true;
        }
        return false;
    }

    public ProfileResponse getProfile() throws ForbiddenException, IOException {
        this.ensureAuthApi();
        return this.amazonCloudDriveAuthRestApi.getProfile(String.format(HEADER_AUTHORIZATION_VALUE, accessToken));
    }

    @SuppressLint(value={"CommitPrefEdits"})
    void saveTokens(TokenResponse tokens) {
        accessToken = tokens.getAccessToken();
        this.preferences.edit().putString("AMAZON_CLOUD_DRIVE_ACCESS_TOKEN", tokens.getAccessToken()).putString("AMAZON_CLOUD_DRIVE_REFRESH_TOKEN", tokens.getRefreshToken()).commit();
    }

    @SuppressLint(value={"CommitPrefEdits"})
    void clearTokens() {
        accessToken = null;
        this.preferences.edit().remove("AMAZON_CLOUD_DRIVE_ACCESS_TOKEN").remove("AMAZON_CLOUD_DRIVE_REFRESH_TOKEN").commit();
    }

    public EndPointResponse getEndPoints() throws ForbiddenException, IOException {
        this.ensureAccountApi();
        return this.amazonCloudDriveAccountRestApi.getEndPoint();
    }

    public AmazonFolder getRootFolder() throws ForbiddenException, IOException {
        this.ensureNodeMetaDataApi();
        FoldersResponse foldersResponse = this.amazonCloudDriveNodeMetaDataRestApi.getRootFolder();
        if (foldersResponse != null && foldersResponse.getCount() == 1) {
            return foldersResponse.getFolders().get(0);
        }
        return null;
    }

    public List<AmazonFolder> listSubfolders(String parentId) throws ForbiddenException, IOException {
        this.ensureNodeMetaDataApi();
        FoldersResponse foldersResponse = this.amazonCloudDriveNodeMetaDataRestApi.listSubfolders(parentId);
        return foldersResponse == null ? null : foldersResponse.getFolders();
    }

    public AmazonFolder createFolder(String name, String parentId) throws ForbiddenException, IOException {
        this.ensureNodeMetaDataApi();
        AmazonFolder folder = new AmazonFolder(name, parentId);
        return this.amazonCloudDriveNodeMetaDataRestApi.createFolder(folder);
    }

    public AmazonFile uploadFile(AmazonFile metadata, TypedFile file) throws ForbiddenException, IOException {
        this.ensureNodeContentApi();
        return this.amazonCloudDriveNodeContentRestApi.uploadFile(metadata, file);
    }

    public AmazonFile getMetadata(String id2) throws ForbiddenException, IOException {
        this.ensureNodeMetaDataApi();
        return this.amazonCloudDriveNodeMetaDataRestApi.getMetadata(id2);
    }

    public AmazonFile overwriteFile(String id2, TypedFile file) throws ForbiddenException, IOException {
        this.ensureNodeContentApi();
        return this.amazonCloudDriveNodeContentRestApi.overwriteFile(id2, file);
    }
}

