/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.upload.cloud.slack;

import java.io.IOException;
import net.doo.snap.upload.cloud.slack.model.ChannelResponse;
import net.doo.snap.upload.cloud.slack.model.ChannelsListResponse;
import net.doo.snap.upload.cloud.slack.model.FileResponse;
import net.doo.snap.upload.cloud.slack.model.GroupsListResponse;
import net.doo.snap.upload.cloud.slack.model.ImListResponse;
import net.doo.snap.upload.cloud.slack.model.ProfileResponse;
import net.doo.snap.upload.cloud.slack.model.TokenResponse;
import net.doo.snap.upload.cloud.slack.model.UsersListResponse;
import retrofit.http.GET;
import retrofit.http.Multipart;
import retrofit.http.POST;
import retrofit.http.Part;
import retrofit.http.Query;
import retrofit.mime.TypedFile;
import retrofit.mime.TypedString;

public interface SlackRestApi {
    public static final String ENDPOINT = "https://slack.com/api/";

    @GET(value="/oauth.access")
    public TokenResponse getToken(@Query(value="client_id") String var1, @Query(value="client_secret") String var2, @Query(value="code") String var3) throws IOException;

    @GET(value="/auth.test")
    public ProfileResponse getProfile(@Query(value="token") String var1) throws IOException;

    @GET(value="/im.list")
    public ImListResponse getImChannels(@Query(value="token") String var1) throws IOException;

    @GET(value="/users.list")
    public UsersListResponse getUsers(@Query(value="token") String var1) throws IOException;

    @GET(value="/groups.list")
    public GroupsListResponse getGroups(@Query(value="token") String var1) throws IOException;

    @GET(value="/channels.list")
    public ChannelsListResponse getChannels(@Query(value="token") String var1) throws IOException;

    @GET(value="/channels.create")
    public ChannelResponse createChannel(@Query(value="token") String var1, @Query(value="name") String var2) throws IOException;

    @GET(value="/channels.join")
    public ChannelResponse joinChannel(@Query(value="token") String var1, @Query(value="name") String var2) throws IOException;

    @Multipart
    @POST(value="/files.upload")
    public FileResponse uploadFile(@Part(value="token") TypedString var1, @Part(value="file") TypedFile var2, @Part(value="title") TypedString var3, @Part(value="initial_comment") TypedString var4, @Part(value="channels") TypedString var5) throws IOException;

    @Multipart
    @POST(value="/files.upload")
    public FileResponse uploadFile(@Part(value="token") TypedString var1, @Part(value="file") TypedFile var2, @Part(value="title") TypedString var3, @Part(value="channels") TypedString var4) throws IOException;
}

