/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.ui.adapter;

import android.content.Context;
import android.net.Uri;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.CheckBox;
import android.widget.ImageView;
import android.widget.TextView;
import java.util.List;
import net.doo.snap.packageFull.R;
import net.doo.snap.ui.upload.EvernoteChooserActivity;
import net.doo.snap.util.ThemesHelper;
import org.jetbrains.annotations.NotNull;

public abstract class FoldersAdapter
extends ArrayAdapter<Uri> {
    private Uri checkedItem;
    boolean showCheckerView = true;

    public FoldersAdapter(Uri currentChosenFolder, Context context, List<Uri> objects) {
        super(context, 0, objects);
        this.checkedItem = currentChosenFolder;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        if (convertView == null) {
            convertView = View.inflate((Context)this.getContext(), (int)R.layout.folder_chooser_item, null);
            ViewHolder holder = new ViewHolder();
            holder.folderName = (TextView)convertView.findViewById(R.id.name);
            holder.checker = (CheckBox)convertView.findViewById(R.id.checkmark);
            holder.openItem = convertView.findViewById(R.id.open_item);
            holder.icon = (ImageView)convertView.findViewById(R.id.icon);
            convertView.setTag((Object)holder);
        }
        final Uri item = (Uri)this.getItem(position);
        final ViewHolder itemHolder = (ViewHolder)convertView.getTag();
        itemHolder.folderName.setText((CharSequence)item.getQueryParameter("folder_name"));
        if (this.checkedItem != null) {
            itemHolder.checker.setChecked(item.getQueryParameter("id").equals(this.checkedItem.getQueryParameter("id")));
        }
        itemHolder.checker.setVisibility(this.showCheckerView ? 0 : 8);
        itemHolder.checker.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (itemHolder.checker.isChecked()) {
                    if (FoldersAdapter.this.chooseItem(item)) {
                        FoldersAdapter.this.checkedItem = item;
                        FoldersAdapter.this.notifyDataSetChanged();
                    } else {
                        itemHolder.checker.setChecked(false);
                    }
                } else {
                    itemHolder.checker.setChecked(true);
                }
            }
        });
        itemHolder.openItem.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                FoldersAdapter.this.openItem(item);
            }
        });
        if (this.getContext() instanceof EvernoteChooserActivity) {
            if ("true".equalsIgnoreCase(item.getQueryParameter("business"))) {
                itemHolder.icon.setImageResource(ThemesHelper.getResourceId((Context)this.getContext(), (int)R.attr.ui_folderpicker_ico_evernote_business));
            } else {
                itemHolder.icon.setImageResource(ThemesHelper.getResourceId((Context)this.getContext(), (int)R.attr.ui_folderpicker_ico_evernote));
            }
        }
        return convertView;
    }

    public void showCheckerView(boolean show) {
        this.showCheckerView = show;
    }

    public abstract boolean chooseItem(@NotNull Uri var1);

    public abstract void openItem(Uri var1);

    private class ViewHolder {
        View openItem;
        TextView folderName;
        CheckBox checker;
        ImageView icon;

        private ViewHolder() {
        }
    }
}

