/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.ui.upload;

import android.accounts.AccountManager;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.IntentSender;
import android.content.SharedPreferences;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import android.widget.TextView;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.drive.Drive;
import com.google.android.gms.drive.DriveId;
import com.google.android.gms.drive.DriveResource;
import com.google.android.gms.drive.Metadata;
import com.google.android.gms.drive.OpenFileActivityBuilder;
import com.google.inject.Inject;
import net.doo.snap.packageFull.R;
import net.doo.snap.ui.CustomThemeActivity;
import net.doo.snap.upload.CloudStorage;
import net.doo.snap.util.NavigationUtils;
import net.doo.snap.util.log.DebugLog;

public class GoogleDriveActivity
extends CustomThemeActivity
implements GoogleApiClient.ConnectionCallbacks,
GoogleApiClient.OnConnectionFailedListener {
    private static final String WAITING_FOR_RESULT = "WAITING_FOR_RESULT";
    private static final String FIRST_CONNECT = "FIRST_CONNECT";
    private static final String GOOGLE_ACCOUNT_TYPE = "com.google";
    private static final int GOOGLE_DRIVE_REQUEST_CODE_RESOLUTION = 300;
    private static final String ACCOUNT_NAME = "ACCOUNT_NAME";
    private static final int CHOOSER_REQUEST_CODE = 1;
    @Inject
    private SharedPreferences preferences;
    private String accountName;
    private GoogleApiClient apiClient;
    private boolean waitingForResult;
    private boolean firstConnect = true;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_connect_storage);
        ((TextView)this.findViewById(R.id.connect_description)).setText((CharSequence)this.getString(R.string.connect_source_description, new Object[]{this.getString(CloudStorage.GOOGLE_DRIVE.getNameResource())}));
        if (savedInstanceState != null) {
            this.accountName = savedInstanceState.getString(ACCOUNT_NAME);
            this.waitingForResult = savedInstanceState.getBoolean(WAITING_FOR_RESULT);
            this.firstConnect = savedInstanceState.getBoolean(FIRST_CONNECT);
        }
    }

    protected void onResume() {
        super.onResume();
        if (this.getIntent().getBooleanExtra("PICK_FOLDER", false)) {
            this.accountName = this.preferences.getString(CloudStorage.GOOGLE_DRIVE.getAccountNameKey(), null);
        }
        if (this.accountName == null && !this.waitingForResult) {
            this.startActivityForResult(AccountManager.newChooseAccountIntent(null, null, (String[])new String[]{GOOGLE_ACCOUNT_TYPE}, (boolean)false, null, null, null, null), 300);
            this.waitingForResult = true;
        } else {
            if (this.apiClient != null && (this.apiClient.isConnected() || this.apiClient.isConnecting())) {
                return;
            }
            this.apiClient = new GoogleApiClient.Builder((Context)this).addApi(Drive.API).addScope(Drive.SCOPE_FILE).addConnectionCallbacks((GoogleApiClient.ConnectionCallbacks)this).addOnConnectionFailedListener((GoogleApiClient.OnConnectionFailedListener)this).setAccountName(this.accountName).build();
            this.apiClient.connect();
        }
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putString(ACCOUNT_NAME, this.accountName);
        outState.putBoolean(WAITING_FOR_RESULT, this.waitingForResult);
        outState.putBoolean(FIRST_CONNECT, this.firstConnect);
    }

    public void onConnectionFailed(ConnectionResult result) {
        DebugLog.e((String)("GoogleApiClient connection failed: " + result.toString()));
        if (!result.hasResolution()) {
            if (this.firstConnect) {
                this.firstConnect = false;
                this.apiClient = new GoogleApiClient.Builder((Context)this).addApi(Drive.API).addScope(Drive.SCOPE_FILE).addConnectionCallbacks((GoogleApiClient.ConnectionCallbacks)this).addOnConnectionFailedListener((GoogleApiClient.OnConnectionFailedListener)this).setAccountName(this.accountName).build();
                this.apiClient.connect();
            } else {
                this.deliverConnectionResult(new net.doo.snap.upload.auth.ConnectionResult(false, CloudStorage.GOOGLE_DRIVE, null));
            }
            return;
        }
        try {
            if (!this.waitingForResult) {
                result.startResolutionForResult((Activity)this, 300);
            }
        }
        catch (IntentSender.SendIntentException e) {
            DebugLog.logException((Throwable)e);
            this.deliverConnectionResult(new net.doo.snap.upload.auth.ConnectionResult(false, CloudStorage.GOOGLE_DRIVE, null));
        }
    }

    public void onConnected(Bundle connectionHint) {
        DebugLog.i((String)"API client connected.");
        if (!this.waitingForResult) {
            if (this.getIntent().getBooleanExtra("PICK_FOLDER", false)) {
                this.startFolderChooser();
            } else {
                this.preferences.edit().putString(CloudStorage.GOOGLE_DRIVE.getAccountNameKey(), this.accountName).remove(CloudStorage.GOOGLE_DRIVE.getDefaultFolderKey()).commit();
                this.deliverConnectionResult(new net.doo.snap.upload.auth.ConnectionResult(true, CloudStorage.GOOGLE_DRIVE, this.accountName));
            }
        }
    }

    public void onConnectionSuspended(int i) {
        DebugLog.i((String)"API client disconnected.");
        this.deliverConnectionResult(new net.doo.snap.upload.auth.ConnectionResult(false, CloudStorage.GOOGLE_DRIVE, null));
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 300) {
            this.waitingForResult = false;
            if (resultCode == -1) {
                this.accountName = data.getStringExtra("authAccount");
                if (this.apiClient != null) {
                    this.apiClient.connect();
                }
            } else {
                this.deliverConnectionResult(new net.doo.snap.upload.auth.ConnectionResult(false, CloudStorage.GOOGLE_DRIVE, null));
            }
        } else if (requestCode == 1) {
            if (resultCode == -1) {
                this.handleChoosedFolder(data);
            } else {
                this.deliverConnectionResult(new net.doo.snap.upload.auth.ConnectionResult(true, CloudStorage.GOOGLE_DRIVE, this.accountName));
            }
        }
    }

    private void startFolderChooser() {
        OpenFileActivityBuilder intentSenderBuilder = Drive.DriveApi.newOpenFileActivityBuilder().setActivityTitle(this.getString(R.string.chooser_title)).setMimeType(new String[]{"application/vnd.google-apps.folder"});
        Uri defaultFolder = CloudStorage.GOOGLE_DRIVE.getDefaultFolder(this.preferences);
        if (defaultFolder != null) {
            String folderId = defaultFolder.getQueryParameter("id");
            intentSenderBuilder.setActivityStartFolder(DriveId.decodeFromString((String)folderId));
        }
        IntentSender intentSender = intentSenderBuilder.build(this.apiClient);
        try {
            this.startIntentSenderForResult(intentSender, 1, null, 0, 0, 0);
        }
        catch (IntentSender.SendIntentException e) {
            DebugLog.logException((Throwable)e);
            this.deliverConnectionResult(new net.doo.snap.upload.auth.ConnectionResult(false, CloudStorage.GOOGLE_DRIVE, this.accountName));
        }
    }

    private void handleChoosedFolder(Intent data) {
        final DriveId driveId = (DriveId)data.getParcelableExtra("response_drive_id");
        if (driveId != null) {
            Drive.DriveApi.getFolder(this.apiClient, driveId).getMetadata(this.apiClient).setResultCallback((ResultCallback)new ResultCallback<DriveResource.MetadataResult>(){

                public void onResult(DriveResource.MetadataResult metadataResult) {
                    if (metadataResult != null && metadataResult.getMetadata() != null) {
                        Metadata metadata = metadataResult.getMetadata();
                        Uri uri = new Uri.Builder().appendQueryParameter("folder_name", metadata.getTitle()).appendQueryParameter("id", driveId.encodeToString()).build();
                        SharedPreferences.Editor edit = GoogleDriveActivity.this.preferences.edit();
                        edit.putString(CloudStorage.GOOGLE_DRIVE.getDefaultFolderKey(), uri.toString());
                        edit.commit();
                    }
                    GoogleDriveActivity.this.deliverConnectionResult(new net.doo.snap.upload.auth.ConnectionResult(true, CloudStorage.GOOGLE_DRIVE, GoogleDriveActivity.this.accountName));
                }
            });
        } else {
            this.deliverConnectionResult(new net.doo.snap.upload.auth.ConnectionResult(true, CloudStorage.GOOGLE_DRIVE, this.accountName));
        }
    }

    private void deliverConnectionResult(net.doo.snap.upload.auth.ConnectionResult result) {
        Intent intent = new Intent();
        intent.putExtra("CONNECTION_EXTRA", (Parcelable)result);
        NavigationUtils.deliverResultAndFinish((Activity)this, (int)-1, (Intent)intent);
    }
}

