/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.upload.cloud;

import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;
import com.evernote.client.android.AsyncBusinessNoteStoreClient;
import com.evernote.client.android.AsyncLinkedNoteStoreClient;
import com.evernote.client.android.EvernoteSession;
import com.evernote.edam.error.EDAMNotFoundException;
import com.evernote.edam.error.EDAMSystemException;
import com.evernote.edam.error.EDAMUserException;
import com.evernote.edam.notestore.NoteStore;
import com.evernote.edam.type.LinkedNotebook;
import com.evernote.edam.type.Note;
import com.evernote.edam.type.Notebook;
import com.evernote.edam.type.SharedNotebook;
import com.evernote.edam.userstore.AuthenticationResult;
import com.evernote.thrift.TException;
import com.google.inject.Inject;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import net.doo.snap.UploadConstants;
import net.doo.snap.ui.upload.UploadInfo;
import net.doo.snap.upload.CloudStorage;
import net.doo.snap.upload.cloud.EvernoteUploader;
import net.doo.snap.upload.cloud.OnFileUploadListener;
import net.doo.snap.util.ManifestConstantsProvider;
import net.doo.snap.util.log.DebugLog;

class EvernoteBusinessUploader
extends EvernoteUploader {
    @Inject
    private Context context;
    @Inject
    private SharedPreferences preferences;
    private EvernoteSession evernoteSession;
    private AsyncBusinessNoteStoreClient businessNoteStoreClient;

    @Inject
    EvernoteBusinessUploader() {
    }

    @Override
    public synchronized void upload(UploadInfo info, OnFileUploadListener onFileUploadListener) throws IOException {
        if (this.evernoteSession == null) {
            this.evernoteSession = EvernoteSession.getInstance((Context)this.context, (String)ManifestConstantsProvider.getConstantValue((Context)this.context, (String)"evernote_consumer_key"), (String)ManifestConstantsProvider.getConstantValue((Context)this.context, (String)"evernote_consumer_secret"), (EvernoteSession.EvernoteService)UploadConstants.EVERNOTE_HOST, (boolean)true);
            try {
                this.businessNoteStoreClient = this.evernoteSession.getClientFactory().createBusinessNoteStoreClient();
            }
            catch (EDAMSystemException | EDAMUserException | TException e) {
                DebugLog.logException((Throwable)e);
            }
        }
        this.findNotebookAndSaveFile(info, onFileUploadListener);
    }

    private void processException(Exception e, UploadInfo info, OnFileUploadListener listener) {
        DebugLog.logExceptionWithStackTrace((Throwable)e);
        String id2 = info.getId();
        if (e instanceof EDAMUserException || e instanceof EvernoteUploader.AuthorizationException) {
            listener.onUploadAuthorizationFailed(id2, CloudStorage.EVERNOTE);
        } else {
            listener.onUploadFailed(id2, CloudStorage.EVERNOTE);
        }
    }

    private void findNotebookAndSaveFile(UploadInfo info, OnFileUploadListener listener) {
        try {
            this.ensureLoggedIn();
            if (!this.saveNoteIfNotebookExists(info, listener)) {
                Notebook scanbotNotebook = new Notebook();
                scanbotNotebook.setName("Scanbot");
                LinkedNotebook newNotebook = this.businessNoteStoreClient.createNotebook(scanbotNotebook);
                this.saveNoteToNotebook(info, newNotebook, listener);
            }
        }
        catch (EDAMNotFoundException | EDAMSystemException | EDAMUserException | TException | IOException | NoSuchAlgorithmException | EvernoteUploader.AuthorizationException e) {
            this.processException((Exception)e, info, listener);
        }
    }

    private boolean saveNoteIfNotebookExists(UploadInfo info, OnFileUploadListener listener) throws TException, EDAMUserException, EDAMSystemException, IOException, NoSuchAlgorithmException, EDAMNotFoundException {
        String defaultNotebookName = this.preferences.contains(CloudStorage.EVERNOTE.getDefaultFolderKey()) ? CloudStorage.EVERNOTE.getDefaultFolder(this.preferences).getQueryParameter("id") : "Scanbot";
        List notebooks = this.businessNoteStoreClient.listNotebooks();
        for (LinkedNotebook item : notebooks) {
            if (!item.getShareName().equals(defaultNotebookName)) continue;
            this.saveNoteToNotebook(info, item, listener);
            return true;
        }
        return false;
    }

    private void saveNoteToNotebook(UploadInfo info, LinkedNotebook notebook, OnFileUploadListener listener) {
        Note note = null;
        if (!TextUtils.isEmpty((CharSequence)info.getCloudFileId())) {
            try {
                note = this.businessNoteStoreClient.getAsyncClient().getClient().getNote(this.evernoteSession.getAuthToken(), info.getCloudFileId(), false, false, false, false);
            }
            catch (EDAMNotFoundException | EDAMSystemException | EDAMUserException | TException e) {
                DebugLog.logException((Throwable)e);
            }
        }
        if (note == null) {
            this.createNoteAndSave(info, notebook, listener);
        } else {
            this.saveExistingNote(info, note, listener);
        }
    }

    private void saveExistingNote(UploadInfo info, Note note, OnFileUploadListener listener) {
        this.setNoteInfo(info, note);
        try {
            this.setNoteAttachment(info.getFile(), note);
            this.businessNoteStoreClient.getAsyncClient().getClient().updateNote(this.evernoteSession.getAuthToken(), note);
            listener.onUploadFinished(info.getId(), CloudStorage.EVERNOTE, note == null ? "" : note.getGuid());
        }
        catch (EDAMNotFoundException | EDAMSystemException | EDAMUserException | TException | IOException | NoSuchAlgorithmException e) {
            this.processException((Exception)e, info, listener);
        }
    }

    private void createNoteAndSave(UploadInfo info, LinkedNotebook notebook, OnFileUploadListener listener) {
        Note note = new Note();
        this.setNoteInfo(info, note);
        try {
            this.setNoteAttachment(info.getFile(), note);
            AsyncLinkedNoteStoreClient sharedNoteStore = this.evernoteSession.getClientFactory().createLinkedNoteStoreClient(notebook);
            NoteStore.Client noteStoreClient = sharedNoteStore.getAsyncClient().getClient();
            AuthenticationResult sharedAuthKey = noteStoreClient.authenticateToSharedNotebook(notebook.getShareKey(), this.evernoteSession.getAuthenticationResult().getAuthToken());
            SharedNotebook sharedNotebook = noteStoreClient.getSharedNotebookByAuth(sharedAuthKey.getAuthenticationToken());
            note.setNotebookGuid(sharedNotebook.getNotebookGuid());
            note = noteStoreClient.createNote(sharedAuthKey.getAuthenticationToken(), note);
            listener.onUploadFinished(info.getId(), CloudStorage.EVERNOTE, note == null ? "" : note.getGuid());
        }
        catch (EDAMNotFoundException | EDAMSystemException | EDAMUserException | TException | IOException | NoSuchAlgorithmException e) {
            this.processException((Exception)e, info, listener);
        }
    }

    private void ensureLoggedIn() throws EvernoteUploader.AuthorizationException, TException, EDAMUserException, EDAMSystemException {
        if (this.evernoteSession == null || !this.evernoteSession.isLoggedIn() || !this.evernoteSession.getClientFactory().createUserStoreClient().isBusinessUser()) {
            throw new EvernoteUploader.AuthorizationException();
        }
    }
}

