/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.upload.cloud;

import android.content.Context;
import android.content.SharedPreferences;
import android.net.Uri;
import android.text.TextUtils;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.drive.Drive;
import com.google.android.gms.drive.DriveApi;
import com.google.android.gms.drive.DriveFile;
import com.google.android.gms.drive.DriveFolder;
import com.google.android.gms.drive.DriveId;
import com.google.android.gms.drive.DriveResource;
import com.google.android.gms.drive.MetadataBuffer;
import com.google.android.gms.drive.MetadataChangeSet;
import com.google.android.gms.drive.metadata.SearchableMetadataField;
import com.google.android.gms.drive.query.Filter;
import com.google.android.gms.drive.query.Filters;
import com.google.android.gms.drive.query.Query;
import com.google.android.gms.drive.query.SearchableField;
import com.google.inject.Inject;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.TimeUnit;
import net.doo.snap.entity.DocumentType;
import net.doo.snap.ui.upload.UploadInfo;
import net.doo.snap.upload.CloudStorage;
import net.doo.snap.upload.cloud.CloudUploader;
import net.doo.snap.upload.cloud.OnFileUploadListener;
import net.doo.snap.util.log.DebugLog;
import net.doo.snap.util.thread.MimeUtils;
import org.apache.commons.io.IOUtils;

class GoogleDriveUploader
implements CloudUploader {
    private static final int SERVICES_CONNECTION_TIMEOUT_SEC = 10;
    private static final long GDRIVE_SYNC_INTERVAL_MS = 120000L;
    private static final int MAX_INDEXABLE_TEXT_SIZE = 131072;
    @Inject
    private Context context;
    @Inject
    private SharedPreferences preferences;
    private GoogleApiClient apiClient;

    @Inject
    GoogleDriveUploader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void upload(UploadInfo info, OnFileUploadListener listener) throws IOException {
        this.apiClient = new GoogleApiClient.Builder(this.context).addApi(Drive.API).addScope(Drive.SCOPE_FILE).setAccountName(this.preferences.getString(CloudStorage.GOOGLE_DRIVE.getAccountNameKey(), null)).build();
        try {
            if (!this.apiClient.isConnected()) {
                this.connectClient();
            }
            this.findFolderAndSaveFile(info, listener);
        }
        catch (ApiConnectionException e) {
            listener.onUploadAuthorizationFailed(info.getId(), CloudStorage.GOOGLE_DRIVE);
            DebugLog.logException((Throwable)e);
        }
        finally {
            this.apiClient.disconnect();
        }
    }

    private void connectClient() throws ApiConnectionException {
        ConnectionResult connectionResult;
        if (!this.apiClient.isConnecting() && !(connectionResult = this.apiClient.blockingConnect(10L, TimeUnit.SECONDS)).isSuccess()) {
            DebugLog.i((String)("GoogleApiClient connection failed: " + connectionResult.toString()));
            throw new ApiConnectionException();
        }
    }

    private void findFolderAndSaveFile(UploadInfo info, OnFileUploadListener listener) {
        String id2 = info.getId();
        if (System.currentTimeMillis() - this.preferences.getLong("LAST_GDRIVE_SYNC", 0L) > 120000L) {
            Drive.DriveApi.requestSync(this.apiClient).await();
            this.preferences.edit().putLong("LAST_GDRIVE_SYNC", System.currentTimeMillis()).apply();
        }
        try {
            if (!this.saveFileIfFolderExists(info, listener)) {
                MetadataChangeSet metadataChangeSet = new MetadataChangeSet.Builder().setTitle("Scanbot").build();
                DriveFolder.DriveFolderResult result = (DriveFolder.DriveFolderResult)Drive.DriveApi.getRootFolder(this.apiClient).createFolder(this.apiClient, metadataChangeSet).await();
                if (!result.getStatus().isSuccess()) {
                    listener.onUploadFailed(id2, CloudStorage.GOOGLE_DRIVE);
                    return;
                }
                this.saveFileToDrive(info, result.getDriveFolder().getDriveId(), listener);
            }
        }
        catch (IllegalStateException e) {
            DebugLog.logException((Throwable)e);
            listener.onUploadFailed(id2, CloudStorage.GOOGLE_DRIVE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean saveFileIfFolderExists(UploadInfo info, OnFileUploadListener listener) throws IllegalStateException {
        DriveId folderId;
        block6: {
            Uri folderUri = CloudStorage.GOOGLE_DRIVE.getDefaultFolder(this.preferences);
            if (folderUri == null) {
                Query query = new Query.Builder().addFilter(Filters.and((Filter)Filters.eq((SearchableMetadataField)SearchableField.TRASHED, (Object)false), (Filter[])new Filter[]{Filters.eq((SearchableMetadataField)SearchableField.TITLE, (Object)"Scanbot"), Filters.eq((SearchableMetadataField)SearchableField.MIME_TYPE, (Object)"application/vnd.google-apps.folder")})).build();
                DriveApi.MetadataBufferResult result = (DriveApi.MetadataBufferResult)Drive.DriveApi.getRootFolder(this.apiClient).queryChildren(this.apiClient, query).await();
                if (!result.getStatus().isSuccess()) {
                    throw new IllegalStateException("GDrive folder request failed!");
                }
                try (MetadataBuffer buffer = result.getMetadataBuffer();){
                    if (buffer.getCount() > 0) {
                        folderId = buffer.get(0).getDriveId();
                        break block6;
                    }
                    boolean bl = false;
                    return bl;
                }
            }
            folderId = Drive.DriveApi.getFolder(this.apiClient, DriveId.decodeFromString((String)folderUri.getQueryParameter("id"))).getDriveId();
        }
        this.saveFileToDrive(info, folderId, listener);
        return true;
    }

    private void saveFileToDrive(UploadInfo info, DriveId folderId, OnFileUploadListener listener) {
        DebugLog.i((String)"Creating new contents.");
        MetadataChangeSet.Builder builder = new MetadataChangeSet.Builder().setTitle(info.getFile().getName()).setMimeType(MimeUtils.getMimeByName((String)info.getFile().getName()));
        StringBuilder indexableText = new StringBuilder();
        DocumentType docType = DocumentType.getByMimeType((String)info.getType());
        if (docType != DocumentType.UNKNOWN) {
            indexableText.append(docType.getDisplayName(this.context));
        }
        if (!TextUtils.isEmpty((CharSequence)info.getOcr())) {
            indexableText.append(" ").append(info.getOcr());
        }
        if (!TextUtils.isEmpty((CharSequence)indexableText)) {
            String indexableString = indexableText.toString();
            builder.setIndexableText(indexableString.substring(0, Math.min(indexableString.length(), 131072)));
        }
        MetadataChangeSet metadataChangeSet = builder.build();
        Status changeContentResult = null;
        if (!TextUtils.isEmpty((CharSequence)info.getCloudFileId())) {
            changeContentResult = this.changeExistingFileContents(info, metadataChangeSet, listener);
        }
        if (changeContentResult != null && changeContentResult.isSuccess()) {
            listener.onUploadFinished(info.getId(), CloudStorage.GOOGLE_DRIVE, info.getCloudFileId());
        } else {
            this.createNewFile(info, metadataChangeSet, folderId, listener);
        }
    }

    private Status changeExistingFileContents(UploadInfo info, MetadataChangeSet metadataChangeSet, OnFileUploadListener listener) {
        Status changeContentResult = null;
        DriveFile driveFile = Drive.DriveApi.getFile(this.apiClient, DriveId.decodeFromString((String)info.getCloudFileId()));
        DriveApi.DriveContentsResult contentsResult = (DriveApi.DriveContentsResult)driveFile.open(this.apiClient, 0x20000000, null).await();
        if (contentsResult.getStatus().isSuccess()) {
            DebugLog.i((String)"File contents loaded.");
            this.loadFileContents(contentsResult, info, listener);
            changeContentResult = (Status)contentsResult.getDriveContents().commit(this.apiClient, metadataChangeSet).await();
            DebugLog.i((String)("File change result: " + changeContentResult.getStatus().isSuccess() + ", thread: " + Thread.currentThread().getName()));
        }
        return changeContentResult;
    }

    private void createNewFile(UploadInfo info, MetadataChangeSet metadataChangeSet, DriveId folderId, OnFileUploadListener listener) {
        String id2 = info.getId();
        DriveApi.DriveContentsResult result = (DriveApi.DriveContentsResult)Drive.DriveApi.newDriveContents(this.apiClient).await();
        if (!result.getStatus().isSuccess()) {
            DebugLog.i((String)"Failed to create new contents.");
            listener.onUploadFailed(id2, CloudStorage.GOOGLE_DRIVE);
            return;
        }
        DebugLog.i((String)"New contents created.");
        this.loadFileContents(result, info, listener);
        DriveFolder.DriveFileResult driveFileResult = (DriveFolder.DriveFileResult)Drive.DriveApi.getFolder(this.apiClient, folderId).createFile(this.apiClient, metadataChangeSet, result.getDriveContents()).await();
        if (driveFileResult.getStatus().isSuccess()) {
            DriveResource.MetadataResult metadataResult = (DriveResource.MetadataResult)driveFileResult.getDriveFile().getMetadata(this.apiClient).await();
            String driveId = "";
            if (metadataResult.getStatus().isSuccess()) {
                driveId = metadataResult.getMetadata().getDriveId().encodeToString();
            }
            listener.onUploadFinished(id2, CloudStorage.GOOGLE_DRIVE, driveId);
        } else {
            listener.onUploadFailed(id2, CloudStorage.GOOGLE_DRIVE);
        }
        DebugLog.i((String)("File upload result: " + driveFileResult.getStatus().isSuccess() + ", thread: " + Thread.currentThread().getName()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadFileContents(DriveApi.DriveContentsResult result, UploadInfo info, OnFileUploadListener listener) {
        OutputStream output = result.getDriveContents().getOutputStream();
        FileInputStream input = null;
        try {
            input = new FileInputStream(info.getFile());
            IOUtils.copy((InputStream)input, (OutputStream)output);
        }
        catch (IOException e) {
            try {
                DebugLog.i((String)"Unable to write file contents.");
                listener.onUploadFailed(info.getId(), CloudStorage.GOOGLE_DRIVE);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(input);
                IOUtils.closeQuietly((OutputStream)output);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)input);
            IOUtils.closeQuietly((OutputStream)output);
        }
        IOUtils.closeQuietly((InputStream)input);
        IOUtils.closeQuietly((OutputStream)output);
    }

    public static class ApiConnectionException
    extends Exception {
        public ApiConnectionException() {
        }

        public ApiConnectionException(Throwable throwable) {
            super(throwable);
        }
    }
}

