/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.upload.cloud.slack;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;
import com.google.inject.Inject;
import java.io.File;
import java.io.IOException;
import net.doo.snap.upload.cloud.slack.SlackRestApi;
import net.doo.snap.upload.cloud.slack.model.ChannelResponse;
import net.doo.snap.upload.cloud.slack.model.ChannelsListResponse;
import net.doo.snap.upload.cloud.slack.model.FileResponse;
import net.doo.snap.upload.cloud.slack.model.GroupsListResponse;
import net.doo.snap.upload.cloud.slack.model.ImListResponse;
import net.doo.snap.upload.cloud.slack.model.ProfileResponse;
import net.doo.snap.upload.cloud.slack.model.TokenResponse;
import net.doo.snap.upload.cloud.slack.model.UsersListResponse;
import net.doo.snap.util.ManifestConstantsProvider;
import net.doo.snap.util.log.DebugLog;
import org.jetbrains.annotations.NotNull;
import retrofit.RestAdapter;
import retrofit.mime.TypedFile;
import retrofit.mime.TypedString;

public class SlackApi {
    public static final String INVALID_AUTH = "invalid_auth";
    private SlackRestApi api;
    private SharedPreferences preferences;
    private final Context context;

    @Inject
    public SlackApi(SharedPreferences preferences, Context context) {
        this.preferences = preferences;
        this.context = context;
        RestAdapter authRestAdapter = new RestAdapter.Builder().setEndpoint("https://slack.com/api/").build();
        this.api = (SlackRestApi)authRestAdapter.create(SlackRestApi.class);
    }

    public String getToken(String code) throws IOException {
        TokenResponse tokenResponse = this.api.getToken(ManifestConstantsProvider.getConstantValue((Context)this.context, (String)"slack_client_id"), ManifestConstantsProvider.getConstantValue((Context)this.context, (String)"slack_secret"), code);
        if (tokenResponse.isOk()) {
            return tokenResponse.getAccessToken();
        }
        return null;
    }

    @SuppressLint(value={"CommitPrefEdits"})
    public void saveToken(String token) {
        this.preferences.edit().putString("SLACK_ACCESS_TOKEN", token).commit();
    }

    public ProfileResponse getProfile() throws IOException {
        String token = this.preferences.getString("SLACK_ACCESS_TOKEN", null);
        if (!TextUtils.isEmpty((CharSequence)token)) {
            return this.api.getProfile(token);
        }
        throw new IOException("Token is empty!");
    }

    public ImListResponse getImChannels() throws IOException {
        String token = this.preferences.getString("SLACK_ACCESS_TOKEN", null);
        if (!TextUtils.isEmpty((CharSequence)token)) {
            return this.api.getImChannels(token);
        }
        throw new IOException("Token is empty!");
    }

    public UsersListResponse getUsers() throws IOException {
        String token = this.preferences.getString("SLACK_ACCESS_TOKEN", null);
        if (!TextUtils.isEmpty((CharSequence)token)) {
            return this.api.getUsers(token);
        }
        throw new IOException("Token is empty!");
    }

    public GroupsListResponse getGroups() throws IOException {
        String token = this.preferences.getString("SLACK_ACCESS_TOKEN", null);
        if (!TextUtils.isEmpty((CharSequence)token)) {
            return this.api.getGroups(token);
        }
        throw new IOException("Token is empty!");
    }

    public ChannelsListResponse getChannels() throws IOException {
        String token = this.preferences.getString("SLACK_ACCESS_TOKEN", null);
        if (!TextUtils.isEmpty((CharSequence)token)) {
            return this.api.getChannels(token);
        }
        throw new IOException("Token is empty!");
    }

    public ChannelResponse createChannel(String name) throws IOException {
        String token = this.preferences.getString("SLACK_ACCESS_TOKEN", null);
        if (!TextUtils.isEmpty((CharSequence)token)) {
            return this.api.createChannel(token, name);
        }
        throw new IOException("Token is empty!");
    }

    public ChannelResponse joinChannel(String name) throws IOException {
        String token = this.preferences.getString("SLACK_ACCESS_TOKEN", null);
        if (!TextUtils.isEmpty((CharSequence)token)) {
            return this.api.joinChannel(token, name);
        }
        throw new IOException("Token is empty!");
    }

    public FileResponse uploadFile(@NotNull File file, @NotNull String channels, @NotNull String title, String comment) throws IOException {
        String token = this.preferences.getString("SLACK_ACCESS_TOKEN", null);
        String mime = file.getName().endsWith(".jpg") ? "image/jpeg" : "application/pdf";
        TypedFile typedFile = new TypedFile(mime, file);
        TypedString typedToken = new TypedString(token);
        TypedString typedTitle = new TypedString(title);
        TypedString typedChannels = new TypedString(channels);
        if (!TextUtils.isEmpty((CharSequence)token)) {
            try {
                if (!TextUtils.isEmpty((CharSequence)comment)) {
                    TypedString typedComment = new TypedString(comment);
                    return this.api.uploadFile(typedToken, typedFile, typedTitle, typedComment, typedChannels);
                }
                return this.api.uploadFile(typedToken, typedFile, typedTitle, typedChannels);
            }
            catch (IOException e) {
                DebugLog.logException((Throwable)e);
            }
        }
        throw new IOException("Token is empty!");
    }
}

