/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.security;

import android.app.Application;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

@Singleton
public class LocalKeystoreManager {
    public static final String KEYSTORE_DIR = "keystore";
    public static final String KEYSTORE_FILE = "keystore";
    private Application application;
    private KeyStore keyStore;

    @Inject
    public LocalKeystoreManager(Application application) {
        this.application = application;
    }

    public synchronized KeyStore getKeyStore() throws KeyStoreException, IOException, CertificateException, NoSuchAlgorithmException {
        if (this.keyStore != null) {
            return this.keyStore;
        }
        this.keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        File keystoreFile = this.getKeystoreFile();
        if (keystoreFile.exists()) {
            this.loadKeystoreFromFile(keystoreFile);
        } else {
            this.createNewKeystore();
        }
        return this.keyStore;
    }

    private void createNewKeystore() throws CertificateException, NoSuchAlgorithmException, IOException {
        this.keyStore.load(null);
    }

    private void loadKeystoreFromFile(File keystoreFile) throws IOException, NoSuchAlgorithmException, CertificateException {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(keystoreFile);
            this.keyStore.load(fileInputStream, this.application.getPackageName().toCharArray());
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fileInputStream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)fileInputStream);
    }

    public synchronized void addCertificate(X509Certificate certificate) throws KeyStoreException, CertificateException, NoSuchAlgorithmException, IOException {
        this.ensureKeystore();
        this.keyStore.setCertificateEntry(certificate.getSerialNumber().toString(16), certificate);
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(this.getKeystoreFile());
            this.keyStore.store(fileOutputStream, this.application.getPackageName().toCharArray());
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fileOutputStream);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)fileOutputStream);
    }

    private File getKeystoreFile() {
        return FileUtils.getFile((File)this.application.getDir("keystore", 0), (String[])new String[]{"keystore"});
    }

    private void ensureKeystore() throws CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException {
        if (this.keyStore == null) {
            this.keyStore = this.getKeyStore();
        }
    }
}

