/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.ui.upload;

import android.content.DialogInterface;
import android.os.Bundle;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.EditText;
import com.google.inject.Inject;
import net.doo.snap.packageFull.R;
import net.doo.snap.ui.ScanbotDialogFragment;
import net.doo.snap.ui.upload.event.EvernoteNotebookNameChosenEvent;
import net.doo.snap.util.FileUtils;
import roboguice.event.EventManager;

public class CreateEvernoteNotebookFragment
extends ScanbotDialogFragment {
    @Inject
    private EventManager eventManager;
    private EditText nameView;
    private CheckBox isBusiness;

    public static CreateEvernoteNotebookFragment newInstance() {
        Bundle args = new Bundle();
        args.putString("CURRENT_NAME", "Scanbot");
        CreateEvernoteNotebookFragment fragment = new CreateEvernoteNotebookFragment();
        fragment.setArguments(args);
        return fragment;
    }

    protected View onCreateContentView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        Bundle args = this.getArguments();
        String currentName = args.getString("CURRENT_NAME");
        int titleRes = args.getInt("TITLE", R.string.folder_chooser_new_folder);
        int hintRes = args.getInt("HINT", R.string.folder_chooser_new_folder);
        this.setTitle(titleRes);
        this.setPositiveButton(17039370, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                CreateEvernoteNotebookFragment.this.eventManager.fire((Object)new EvernoteNotebookNameChosenEvent(CreateEvernoteNotebookFragment.this.nameView.getText().toString(), CreateEvernoteNotebookFragment.this.isBusiness.isChecked()));
                CreateEvernoteNotebookFragment.this.dismiss();
            }
        });
        this.setNegativeButton(0x1040000, null);
        View content = inflater.inflate(R.layout.new_evernote_notebook_name, container, false);
        this.nameView = (EditText)content.findViewById(R.id.name);
        this.nameView.setText((CharSequence)currentName);
        this.nameView.setHint(hintRes);
        this.isBusiness = (CheckBox)content.findViewById(R.id.is_business);
        return content;
    }

    public void onStart() {
        super.onStart();
        this.getDialog().getWindow().setSoftInputMode(21);
        final Button positiveButton = this.getButton(-1);
        this.nameView.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
                positiveButton.setEnabled(FileUtils.isFileNameSafe((CharSequence)s));
            }

            public void afterTextChanged(Editable s) {
            }
        });
    }
}

