/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.ui.upload;

import android.content.Context;
import android.content.SharedPreferences;
import android.net.Uri;
import com.google.inject.Inject;
import io.scanbot.shoeboxed.ApiApplication;
import io.scanbot.shoeboxed.ShoeboxedApi;
import io.scanbot.shoeboxed.ShoeboxedSession;
import io.scanbot.shoeboxed.entity.Category;
import io.scanbot.shoeboxed.entity.request.CreateCategoryRequest;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.doo.snap.packageFull.R;
import net.doo.snap.ui.upload.ChooserActivity;
import net.doo.snap.upload.CloudStorage;
import net.doo.snap.util.ManifestConstantsProvider;
import net.doo.snap.util.log.DebugLog;
import net.doo.snap.util.thread.ExecutionUtils;

public class ShoeboxedChooserActivity
extends ChooserActivity {
    @Inject
    private SharedPreferences preferences;
    private ShoeboxedApi shoeboxedApi;
    private long accountId;

    @Override
    protected void init() {
        this.chooserStorage = CloudStorage.SHOEBOXED;
        if (!this.preferences.contains("SHOEBOXED_ACCOUNT_ID")) {
            this.finish();
            return;
        }
        this.accountId = this.preferences.getLong("SHOEBOXED_ACCOUNT_ID", 0L);
        ApiApplication apiApplication = new ApiApplication(ManifestConstantsProvider.getConstantValue((Context)this, (String)"shoeboxed_api_client_id"), ManifestConstantsProvider.getConstantValue((Context)this, (String)"shoeboxed_api_secret"), ManifestConstantsProvider.getConstantValue((Context)this, (String)"shoeboxed_api_redirect_url"));
        ShoeboxedSession session = new ShoeboxedSession.Builder(apiApplication).accessToken(this.preferences.getString("SHOEBOXED_ACCESS_TOKEN", null)).refreshToken(this.preferences.getString("SHOEBOXED_REFRESH_TOKEN", null)).build();
        this.shoeboxedApi = ShoeboxedApi.forSession((ShoeboxedSession)session);
    }

    @Override
    protected void createFolder(String name) {
        try {
            this.shoeboxedApi.createCategory(this.accountId, new CreateCategoryRequest.Builder(name).build());
        }
        catch (IOException e) {
            DebugLog.logException((Throwable)e);
            ExecutionUtils.showToast((Context)this, (int)R.string.unable_create_folder_error);
        }
    }

    @Override
    protected List<Uri> loadFolders() {
        ArrayList<Uri> categoryUris = new ArrayList<Uri>();
        try {
            List categories = this.shoeboxedApi.getCategories(this.accountId);
            for (Category category : categories) {
                Uri uri = new Uri.Builder().appendQueryParameter("folder_name", category.getName()).appendQueryParameter("id", String.valueOf(category.getId())).build();
                categoryUris.add(uri);
            }
        }
        catch (IOException e) {
            DebugLog.logException((Throwable)e);
            ExecutionUtils.showToast((Context)this, (int)R.string.unable_open_folder_error);
        }
        return categoryUris;
    }
}

