/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.ui.upload;

import android.app.LoaderManager;
import android.content.Context;
import android.content.SharedPreferences;
import android.net.Uri;
import android.text.TextUtils;
import com.google.inject.Inject;
import de.aflx.sardine.DavResource;
import de.aflx.sardine.Sardine;
import de.aflx.sardine.SardineFactory;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.doo.snap.packageFull.R;
import net.doo.snap.ui.upload.ChooserActivity;
import net.doo.snap.upload.CloudStorage;
import net.doo.snap.util.log.DebugLog;
import net.doo.snap.util.thread.ExecutionUtils;

public class WebdavChooserActivity
extends ChooserActivity
implements LoaderManager.LoaderCallbacks<List<Uri>> {
    private static final String ROOT_PATH = File.separator;
    @Inject
    private SharedPreferences preferences;
    @Inject
    private SardineFactory sardineFactory;
    private Sardine sardine;
    private String username;
    private String password;
    private String rootFolderUrl;

    @Override
    protected void init() {
        if (this.getIntent() != null) {
            int storageDatabaseId = this.getIntent().getIntExtra("CLOUD_STORAGE", CloudStorage.WEBDAV_STORAGE.getDatabaseId());
            this.chooserStorage = CloudStorage.getByDatabaseId(storageDatabaseId);
        }
        this.initWebdavClient();
    }

    private void initWebdavClient() {
        switch (this.chooserStorage) {
            case WEBDAV_STORAGE: {
                this.rootFolderUrl = this.preferences.getString("WEBDAV_HOST", "");
                this.username = this.preferences.getString("WEBDAV_USERNAME", "");
                this.password = this.preferences.getString("WEBDAV_PASS", "");
                break;
            }
            case TELEKOM_CLOUD: {
                this.rootFolderUrl = "https://webdav.mediencenter.t-online.de";
                this.username = this.preferences.getString("TELEKOM_USERNAME", "");
                this.password = this.preferences.getString("TELEKOM_PASS", "");
                break;
            }
            case BOX: {
                this.rootFolderUrl = "https://dav.box.com/dav";
                this.username = this.preferences.getString("BOX_USERNAME", "");
                this.password = this.preferences.getString("BOX_PASS", "");
            }
        }
        if (TextUtils.isEmpty((CharSequence)this.username) || TextUtils.isEmpty((CharSequence)this.password) || TextUtils.isEmpty((CharSequence)this.rootFolderUrl)) {
            ExecutionUtils.showToast((Context)this, (int)R.string.unable_open_folder_auth_error);
            this.finish();
            return;
        }
        this.sardine = this.sardineFactory.begin(this.username, this.password);
        if (this.sardine == null) {
            ExecutionUtils.showToast((Context)this, (int)R.string.unable_open_folder_auth_error);
            this.finish();
            return;
        }
        this.foldersHierarchy.add(new Uri.Builder().appendQueryParameter("folder_name", ROOT_PATH).appendQueryParameter("id", this.rootFolderUrl).build());
    }

    @Override
    protected void createFolder(String name) {
        Uri.Builder builder = new Uri.Builder().encodedPath(((Uri)this.foldersHierarchy.getLast()).getQueryParameter("id")).appendPath(name);
        try {
            this.sardine.createDirectory(builder.toString());
        }
        catch (IOException e) {
            DebugLog.logException((Throwable)e);
            ExecutionUtils.showToast((Context)this, (int)R.string.unable_create_folder_error);
        }
    }

    @Override
    protected List<Uri> loadFolders() {
        List list;
        ArrayList<Uri> foldersUris = new ArrayList<Uri>();
        String folderPath = ((Uri)this.foldersHierarchy.getLast()).getQueryParameter("id");
        try {
            list = this.sardine.list(folderPath);
        }
        catch (IOException e) {
            DebugLog.logException((Throwable)e);
            ExecutionUtils.showToast((Context)this, (int)R.string.unable_open_folder_error);
            return foldersUris;
        }
        Uri rootFolderUri = Uri.parse((String)this.rootFolderUrl);
        for (DavResource item : list) {
            if (!item.isDirectory()) continue;
            Uri.Builder builder = new Uri.Builder().scheme(rootFolderUri.getScheme()).authority(rootFolderUri.getAuthority());
            List itemPathSegments = Uri.parse((String)item.getHref().getPath()).getPathSegments();
            for (String segment : itemPathSegments) {
                builder.appendPath(segment);
            }
            String itemPath = builder.toString();
            if (folderPath.equals(itemPath)) continue;
            Uri uri = new Uri.Builder().appendQueryParameter("folder_name", item.getName()).appendQueryParameter("id", itemPath).build();
            foldersUris.add(uri);
        }
        return foldersUris;
    }
}

